@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
			<li class="active">Live Visitors</li>
		</ol>

		@include('themes.basic.user.site.live_ribbon')

		<div class="page-header">
			<h1>Live Visitors</h1>
		</div>

		<div class="row">

			<!-- Live Count -->
			<div class="col-md-4 text-center">
				<h3 class="live-users">0</h3>
				<p>active users on site</p>
				<!-- Device Type -->
				<div class="live-device-type">
					<div class="row">
						<div class="col-md-12">
							<ul class="device-list">
								<li><i class="fa fa-square device-desktop"></i>Desktop</li>
								<li><i class="fa fa-square device-mobile"></i>Mobile</li>
								<li><i class="fa fa-square device-tablet"></i>Tablet</li>
								<li><i class="fa fa-square device-other"></i>Other</li>
							</ul>
						</div>
					</div>
					<div class="progress">
						<div class="progress-bar progress-bar-success bar-desktop" style="width: 0%">
							<span class="sr-only">0%</span>
						</div>
						<div class="progress-bar progress-bar-warning bar-mobile" style="width: 0%">
							<span class="sr-only">20%</span>
						</div>
						<div class="progress-bar progress-bar-danger bar-tablet" style="width: 0%">
							<span class="sr-only">10%</span>
						</div>
						<div class="progress-bar progress-bar-info bar-other" style="width: 0%">
							<span class="sr-only">10%</span>
						</div>
					</div>
				</div>
			</div>		
			<!-- /Live Count -->

			<!-- Pageviews -->
			<div class="col-md-8">
				<div class="panel panel-default">
					<div class="panel-heading">Actions</div>
					<div id="bar-actions" style="height: 160px;"></div>
				</div>
			</div>
			<!-- /Pageviews -->

		</div>

		<div class="row">
			<div class="col-md-12">

				<div class="panel panel-default">
					<div class="panel-heading">Top Active Pages</div>
					<table class="table top-active-pages">
						<thead>
							<tr>
								<th width="50%">Page</th>
								<th class="text-right">Active Actions</th>
							</tr>
						</thead>
						<tbody>

						</tbody>
					</table>
				</div>

			</div>		
		</div>

		<div class="row">
			<div class="col-md-6">

				<div class="panel panel-default">
					<div class="panel-heading">Top Locations</div>
					<table class="table top-active-locations">
						<thead>
							<tr>
								<th width="50%">Location</th>
								<th class="text-right">Active Actions</th>
							</tr>
						</thead>
						<tbody>

						</tbody>
					</table>
				</div>

			</div>
			<div class="col-md-6">

				<div class="panel panel-default">
					<div class="panel-heading">Top Browsers</div>
					<table class="table top-active-browsers">
						<thead>
							<tr>
								<th width="50%">Browser</th>
								<th class="text-right">Active Actions</th>
							</tr>
						</thead>
						<tbody>

						</tbody>
					</table>
				</div>

			</div>		
		</div>

	</div>
</div>

@stop

@section('head')
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
@endsection

@section('page-end')
@parent
<script>

/**
 * Function to grab live data from the server
 *
 */
function getLiveData() 
{
	$.get('{{ action('User\SiteController@getLiveStats', $site->uuid) }}', function(data) {

		//-- Main visitors
		$('.live-users').html(data.visitors);
		$('.bar-desktop, .bar-mobile, .bar-tablet, .bar-other').css('width', 0).html('<span class="sr-only">0%</span>');
		if (data.device != null) {
			if (data.device.Desktop != null) { $('.bar-desktop').css('width', data.device.Desktop + "%").html(data.device.Desktop + '%'); }
			if (data.device.Mobile != null)  { $('.bar-mobile').css('width', data.device.Mobile + "%").html(data.device.Mobile + '%'); }
			if (data.device.Tablet != null)  { $('.bar-tablet').css('width', data.device.Tablet + "%").html(data.device.Tablet + '%'); }
			if (data.device.Other != null)   { $('.bar-other').css('width', data.device.Other + "%").html(data.device.Other + '%'); }
		}

		//-- Clear tables
		$('.top-active-pages > tbody, .top-active-locations > tbody, .top-active-browsers > tbody').html("");

		//-- Re-do tables
		$.each(data.pages, function(p, v) { $('.top-active-pages tbody').append('<tr><td>' + p + '</td><td class="text-right">' + v + '</td></tr>'); });
		$.each(data.locations, function(p, v) { $('.top-active-locations tbody').append('<tr><td>' + p + '</td><td class="text-right">' + v + '</td></tr>'); });
		$.each(data.browsers, function(p, v) { $('.top-active-browsers tbody').append('<tr><td>' + p + '</td><td class="text-right">' + v + '</td></tr>'); });

		//-- Graph
		action_graph.setData(data.pageviews_json);
	});

	//-- Fire again in 5 seconds
	setTimeout(getLiveData, 5000)
}

</script>
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script>
var action_graph = Morris.Bar({
  element: 'bar-actions',
  data: [
    { y: '-10 min', a: 0 },
    { y: '-9 min', a: 0 },
    { y: '-8 min', a: 0 },
    { y: '-7 min', a: 0 },
    { y: '-6 min', a: 0 },
    { y: '-5 min', a: 0 },
    { y: '-4 min', a: 0 },
    { y: '-3 min', a: 0 },
    { y: '-2 min', a: 0 },
    { y: '-1 min', a: 0 },
  ],
  xkey: 'y',
  ykeys: ['a'],
  labels: ['Actions']
});
//-- Run get live data
getLiveData();
</script>
@endsection