@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
			<li class="active">Dashboard</li>
		</ol>

		@include('themes.basic.user.site.live_ribbon')

		<div class="page-header">
			<h1>Site Dashboard</h1>
		</div>

		<div class="row">
			<div class="col-sm-12">

				<div class="panel panel-default">
					<div class="panel-heading">Basic Statistics</div>
					<div class="panel-body">

						<div class="col-xs-6 col-sm-3">
							<div class="stat">
								<span>Visitors</span>
								{{ number_format($site->getVisitorDateRange($report['start_format'], $report['end_format']), 0) }}
							</div>
						</div>

						<div class="col-xs-6 col-sm-3">
							<div class="stat">
								<span>Actions</span>
								{{ number_format($site->getHitsDateRange($report['start_format'], $report['end_format']), 0) }}
							</div>
						</div>

						<div class="col-xs-6 col-sm-3">
							<div class="stat">
								<span>Actions / Visitor</span>
								{{ $site->getHitsPerVisit($report['start_format'], $report['end_format']) }}
							</div>
						</div>

						<div class="col-xs-6 col-sm-3">
							<div class="stat">
								<span>Average time on site</span>
								{{ secs_to_human($site->getAvgTimeOnSite($report['start_format'], $report['end_format'])) }}
							</div>
						</div>

					</div>

				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">

				<div class="panel panel-default">
					<div class="panel-heading">Page Actions</div>
					<div class="panel-body">
						<div id="myfirstchart" style="height: 250px;"></div>
					</div>
				</div>

			</div>
		</div>

		<div class="row">
			<div class="col-sm-6">

				<div class="panel panel-default">
					<div class="panel-heading">Top Devices</div>
					<table class="table">
						<thead>
							<tr>
								<th>Device</th>
								<th>Actions</th>
							</tr>
						</thead>
						<tbody>
							@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'device') AS $r)
							<tr>
								<td>{{ $r->device }}</td>
								<td>{{ number_format($r->total_hits, 0) }}</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>

			</div>

			<div class="col-sm-6">

				<div class="panel panel-default">
					<div class="panel-heading">Top Locations</div>
					<table class="table">
						<thead>
							<tr>
								<th>Location</th>
								<th>Actions</th>
							</tr>
						</thead>
						<tbody>
							@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'country') AS $r)
							<tr>
								<td>{{ $r->country }}</td>
								<td>{{ number_format($r->total_hits, 0) }}</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>

			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">

				<div class="panel panel-default">
					<div class="panel-heading">Top Referers</div>
					<table class="table">
						<thead>
							<tr>
								<th width="50%">Referer</th>
								<th class="text-right">Actions</th>
								<th class="text-right">Visitors</th>
								<th class="text-right">Avg Time</th>
							</tr>
						</thead>
						<tbody>
							@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'referer_url') AS $row)
							<?php $stats = $site->getContentStats($report['start_format'], $report['end_format'], 'referer_url', $row->referer_url); ?>
							<tr>
								<td>
								@if ($row->referer_url == '')
								Direct or no Referer
								@else
								{{ $row->referer_url }}
								@endif
								</td>
								<td class="text-right">{{ number_format($row->total_hits, 0) }}</td>
								<td class="text-right">{{ $stats['visitors'] }}</td>
								<td class="text-right">{{ secs_to_human($stats['avg']) }}</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>

			</div>
		</div>

	</div>
</div>

@stop

@section('head')
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
@endsection

@section('page-end')
@parent
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script>
	new Morris.Line({
		element: 'myfirstchart',
		data: [
		@foreach($site->arrayDatesMethod($report['start_format'], $report['end_format'], "1 day", "getHitsDateRange") AS $date => $v)
		{ year: '{{ $date }}', value: {{ $v }} },
		@endforeach
		],
		xkey: 'year',
		ykeys: ['value'],
		labels: ['Value']
	});
</script>
@endsection