<div class="list-group">
	<div class="list-group-item active">Your Sites</div>
	@foreach(Auth::user()->sites AS $site) 
	<a href="{{ action('User\SiteController@siteDashboard', [$site->uuid]) }}" class="list-group-item">
		{{ $site->name }}
	</a>
	@endforeach
	<a href="{{ action('User\SiteController@createSite') }}" class="list-group-item">Add a site</a>
</div>

@if (Auth::user()->package->adverts == 1)
<!-- Advert slot -->
<div class="ad-slot">
	<a href=''><img src='{{ asset('assets/ads/1.png') }}' width="100%" /></a>
</div>
<!-- /Advert slot -->
@endif


@if (isset($site_selected))
<div class="list-group">
	<div class="list-group-item active">Site Navigation</div>
	<a href="{{ action('User\SiteController@siteDashboard', $site_selected->uuid) }}" class="list-group-item">Dashboard</a>
	<a href="{{ action('User\SiteController@siteLive', $site_selected->uuid) }}" class="list-group-item">Live</a>
	<a href="{{ action('User\SiteController@siteContent', $site_selected->uuid) }}" class="list-group-item">Content</a>
	<a href="{{ action('User\SiteController@siteLocation', $site_selected->uuid) }}" class="list-group-item">Locations</a>
	<a href="{{ action('User\SiteController@siteTech', $site_selected->uuid) }}" class="list-group-item">Technology</a>
	<a href="{{ action('User\SiteController@siteRefs', $site_selected->uuid) }}" class="list-group-item">Referers</a>
	<a href="{{ action('User\SiteController@siteSettings', $site_selected->uuid) }}" class="list-group-item">Site Settings</a>
</div>
@endif