@extends('themes.basic.master')

@section('content')


<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li class="active">Dashboard</li>
		</ol>

		<div class="page-header">
			<h1>Dashboard</h1>
		</div>

		@if (session()->get('warning') != null)
		<div class="alert alert-warning">
			{!! session()->get('warning') !!}
		</div>
		@endif

		<table class="table">
			<thead>
				<tr>
					<th width="60%">Site Name</th>
					<th class="text-right">Live</th>
					<th class="text-right">Visitors</th>
					<th class="text-right">Actions</th>
				</tr>
			</thead>
			<tbody>

				@foreach(Auth::user()->sites AS $site)
				<?php 

                $visitors = $site->arrayDatesMethod(date("Y-m-d", strtotime("-7 days")), date("Y-m-d"), '1 day', 'getVisitorDateRange');
                $actions = $site->arrayDatesMethod(date("Y-m-d", strtotime("-7 days")), date("Y-m-d"), '1 day', 'getHitsDateRange');

                ?>
				<tr>
					<td><a href='{{ action('User\SiteController@siteDashboard', $site->uuid) }}'>{{ $site->name }}</a></td>
					<td class="text-right">{{ $site->getLiveVisitors() }}</td>
					<td class="text-right">{{ $site->getVisitorDateRange() }} today <span class="inlinesparkline">{{ implode(",", $visitors) }}</span></td>
					<td class="text-right">{{ $site->getHitsDateRange() }} today <span class="inlinesparkline">{{ implode(",", $actions) }}</span></td>
				</tr>
				@endforeach

			</tbody>
		</table>

	</div>
</div>

@stop

@section('page-end')
<script src='{{ asset('assets/themes/basic/js/sparkline.min.js') }}'></script>
<script>
	$(function() {

		$('.inlinesparkline').sparkline('html', {
			defaultPixelsPerValue: 8
		}); 

	});
</script>
@stop