<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
	<meta name="description" content="">
	<meta name="author" content="">
	<link rel="icon" href="../../favicon.ico">

	<title>@yield('title', getConfig('name'))</title>

	<!-- Bootstrap core CSS -->
	<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet">
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css" rel="stylesheet" >
	<link href="{{ asset('assets/themes/basic/css/navbar.css') }}" rel="stylesheet">
	<link href="{{ asset('assets/themes/basic/css/site.css') }}" rel="stylesheet">

	<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    @yield('head')

</head>

<body>

	<div class="container">

		<!-- Static navbar -->
		<nav class="navbar navbar-default">
			<div class="container-fluid">
				<div class="navbar-header">
					<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<a class="navbar-brand" href="{{ url('/') }}">{{ getConfig('name') }}</a>
				</div>
				<div id="navbar" class="navbar-collapse collapse">
					<ul class="nav navbar-nav">

					</ul>
					<ul class="nav navbar-nav navbar-right">
						@if (Auth::check())
						<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
						@if (Auth::user()->admin == 1)
							<li><a href="{{ action('Admin\AdminController@showDashboard') }}">Admin</a></li>
						@endif
						@if (getConfig('upgrade'))
						<li><a href="{{ action('User\UserController@showUserUpgrade') }}">Upgrade</a></li>
						@endif
						<li><a href="{{ action('Auth\UserAuthController@logoutSystem') }}">Logout</a></li>
						@else
						<li><a href="{{ action('Auth\UserAuthController@loginSystem') }}">Login</a></li>
						<li><a href="{{ action('Auth\UserAuthController@registerSystem') }}">Register</a></li>
						@endif
					</ul>
				</div><!--/.nav-collapse -->
			</div><!--/.container-fluid -->
		</nav>

		@yield('content')

	</div> <!-- /container -->


    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="{{ asset('assets/themes/basic/js/bootstrap.min.js') }}"></script>

    @yield('page-end')

</body>
</html>