@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-6 col-sm-offset-3">

		@if (getConfig('registration') == 'false')

		<div class="alert alert-warning">
			<p><strong>Registrations are turned off.</strong></p>
			<p>Please contact the admin.</p>
		</div>

		@else

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title">Register Form</h3>
			</div>
			<div class="panel-body">

				@if (count($errors) > 0)
				<div class="alert alert-danger">
					<p><strong>There was a problem registering you.</strong></p>
					<ul style="margin-top: 10px">
						@foreach ($errors->all() as $error)
						<li>{{ $error }}</li>
						@endforeach
					</ul>
				</div>
				@endif

				@if (isset($success))
				<div class="alert alert-success">
					{!! $success !!}
				</div>
				@endif
				
				<form method="POST">

					{{ csrf_field() }}

					<div class="form-group">
						<label for="exampleInputEmail1">Username</label>
						<input type="text" name="username" class="form-control" id="exampleInputEmail1" placeholder="" value="{{ old('username') }}">
					</div>
					<div class="form-group">
						<label for="exampleInputEmail1">Email Address</label>
						<input type="email" name="email" class="form-control" id="exampleInputEmail1" placeholder="" value="{{ old('email') }}">
					</div>
					<div class="form-group">
						<label for="exampleInputPassword1">Password</label>
						<input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
					</div>
					<div class="form-group">
						<label for="exampleInputPassword1">Repeat Password</label>
						<input type="password" name="password2" class="form-control" id="exampleInputPassword1" placeholder="Password">
					</div>
					<button type="submit" class="btn btn-default">Submit</button>
					
				</form>

			</div>
		</div>

		@endif

	</div>
</div>

@stop