@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-6 col-sm-offset-3">

		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title">Login Form</h3>
			</div>
			<div class="panel-body">

				@if (count($errors) > 0)
				<div class="alert alert-danger">
					<p><strong>There was a problem logging you in.</strong></p>
					<ul style="margin-top: 10px">
						@foreach ($errors->all() as $error)
						<li>{{ $error }}</li>
						@endforeach
					</ul>
				</div>
				@endif

				@if (isset($success))
				<div class="alert alert-success">
					{!! $success !!}
				</div>
				@endif
				
				<form method="POST">

					{{ csrf_field() }}

					<div class="form-group">
						<label for="exampleInputEmail1">Username</label>
						<input type="text" name="username" class="form-control" id="exampleInputEmail1" placeholder="">
					</div>
					<div class="form-group">
						<label for="exampleInputPassword1">Password</label>
						<input type="password" name="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
					</div>
					<div class="checkbox">
						<label>
							<input type="checkbox"> Remember me
						</label>
					</div>

					<div class="row">
						<div class="col-sm-6">
							<button type="submit" class="btn btn-default">Submit</button>
						</div>
						<div class="col-sm-6 text-right">
							<a href='{{ action('Auth\UserAuthController@forgotPasswordSystem') }}'>Forgot password?</a>
						</div>
					</div>

				</form>

			</div>
		</div>

	</div>
</div>

@stop