@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>User Accounts</h2>
			</div>
			<div class="col-md-6 text-right">
				<a href='{{ action('Admin\AdminController@showAddUserAccount') }}' class="btn btn-primary btntop"><i class="fa fa-plus"></i>Add Account</a>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="content-panel">

					<table class="table">
						<thead>
							<tr>
								<th>Username</th>
								<th class="text-right">Account type</th>
								<th class="text-right">Sites</th>
								<th class="text-right">Last active</th>
								<th class="text-right">Member since</th>
								<th class="text-right" data-orderable="false">&nbsp;</th>
							</tr>
						</thead>
						<tbody>
						@foreach($users AS $user)
							<tr>
								<td>{{ $user->name }}</td>
								<td class="text-right">{{ $user->package->name }}</td>
								<td class="text-right">{{ count($user->sites) }}</td>
								<td class="text-right" data-order="{{ strtotime($user->last_logged) }}">{{ date("d M Y H:i", strtotime($user->last_logged)) }}</td>
								<td class="text-right" data-order="{{ $user->created_at->format("U") }}">{{ $user->created_at->format("d M Y H:i") }}</td>
								<td class="text-right"><a href='{{ action('Admin\AdminController@showEditUserAccount', $user->id) }}'>View Account</a></td>
							</tr>
						@endforeach
						</tbody>
					</table>				

				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.11/css/dataTables.bootstrap.min.css">
@endsection

@section('javascript')
<script src='https://cdn.datatables.net/1.10.11/js/jquery.dataTables.min.js'></script>
<script src='{{ asset('assets/admin/js/bstrap_datatables.js') }}'></script>
<script>
$(document).ready(function() {
    $('.table').DataTable();
});
</script>
@endsection