@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Edit User Account</h2>
			</div>
			<div class="col-md-6 text-right">

			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-8">

				<div class="content-panel-header">Edit User Form</div>
				<div class="content-panel">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
					<p><strong>There was a problem creating this user.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					@if (isset($success))
					<div class="alert alert-success">
						{!! $success !!}
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label>Username</label>
							<input type="text" name="username" class="form-control" placeholder="Required" value="{{ $user->name }}">
						</div>	

						<div class="form-group">
							<label>Email Address</label>
							<input type="email" name="email" class="form-control" placeholder="Required" value="{{ $user->email }}">
						</div>	

						<div class="form-group">
							<label for="exampleInputEmail1">Package</label>
							<select class="form-control" name="package">
								@foreach($packages AS $p)
								<option value="{{ $p->id }}" @if ($user->package_id == $p->id) selected @endif>{{ $p->name }}</option>
								@endforeach
							</select>
						</div>	

						<div class="form-group">
							<label>Password</label>
							<input type="text" name="password" class="form-control" placeholder="Leave blank to not change">
						</div>	

						<hr />

						<div class="row">
							<div class="col-md-12">
								<div class="col-sm-6" style="padding-left: 0">
									<button type="submit" class="btn btn-primary">Edit this user</button>
								</div>
								<div class="col-sm-6 text-right" style="padding-right: 0">
									<a href='{{ action('Admin\AdminController@loginAsUser', $user->id) }}' class="btn btn-warning">Login as this user</a>
								</div>
							</div>
						</div>

					</form>

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>You can edit this user on this page. All fields are available to be edited, but are still required.</p>
						<p>The password is not shown as it is <a href='https://en.wikipedia.org/wiki/Salt_(cryptography)' style="border-bottom: 1px dotted">securely hashed</a> and stored inside the database. You cannot recover the password, but you can set a new one.</p>
						<p>You can also log in as this user. This will reset your user account, so you will have to logout and log back in as your admin account once you are finished.</p> 
					</div>
				</div>

			</div>
		</div>

		<div class="row" style="margin-top: 30px">
			<div class="col-md-8">			
				<div class="content-panel-header">View Users Sites</div>
				<div class="content-panel content-panel-table">

					<table class="table">
						<thead>
							<tr>
								<th>Site Name</th>
								<th>URL</th>
								<th>Created</th>
								<th>Hits today</th>
								<th>Hits all time</th>
							</tr>
						</thead>
						<tbody>
						@foreach($user->sites AS $site)
							<tr>
								<td><a href=''>{{ $site->name }}</a></td>
								<td><a href='{{ $site->url }}'>{{ $site->url }}</a></td>
								<td>{{ $site->created_at->format("d M Y H:i") }}</td>
								<td>{{ $site->getHitsDateRange() }}</td>
								<td>{{ $site->getHitsDateRange("2000-01-01") }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>These are the sites that this user has setup on the system. By logging in as this user, you can view their statistics.</p> 
					</div>
				</div>

			</div>
		</div>

		<div class="row" style="margin-top: 30px">
			<div class="col-md-8">
			
				<div class="content-panel-header">Delete User</div>
				<div class="content-panel">

					<p>By deleting this user, you will also delete:</p>
					<ul>
						<li>All sites this user owns.</li>
						<li>All data for the sites they own.</li>
						<li>All reports for this sites they own.</li>
					</ul>
					<hr />

					<a href='{{ action('Admin\AdminController@deleteUser', $user->id) }}' class='btn btn-danger' onClick="return confirm('There is no system to bring back deleted data - please be sure before you click Confirm.')">Delete this user</a>

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>Please make sure you 100% confirm before pushing the delete button. <strong>There is no system to bring back deleted data at all.</strong></p> 
					</div>
				</div>

			</div>
		</div>
	</div>
</div>

@endsection
