@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Add User Account</h2>
			</div>
			<div class="col-md-6 text-right">

			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-8">
				<div class="content-panel-header">Add User Form</div>
				<div class="content-panel">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
					<p><strong>There was a problem creating this user.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label>Username</label>
							<input type="text" name="username" class="form-control" placeholder="Required">
						</div>	

						<div class="form-group">
							<label>Email Address</label>
							<input type="email" name="email" class="form-control" placeholder="Required">
						</div>	

						<div class="form-group">
							<label for="exampleInputEmail1">Package</label>
							<select class="form-control" name="package">
								@foreach($packages AS $p)
								<option value="{{ $p->id }}">{{ $p->name }}</option>
								@endforeach
							</select>
						</div>	

						<div class="form-group">
							<label>Password</label>
							<input type="text" name="password" class="form-control" placeholder="Required">
						</div>	

						<hr />

						<button type="submit" class="btn btn-primary">Create new user</button>

					</form>

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>You can create a new user for your system on this page. Please make sure you let them know there username and password so they can login.</p>
						<p>You can give the new user whatever package you like - even ones that are not usually active. This enables you to give users better packages than might be available for other users.</p>
						<p>This user will skip email validation as well, so they will be instantly available to login using the credentials you give.</p>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>

@endsection
