@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-8 text-left">
				<h2>System Wide Statistics</h2>
			</div>
			<div class="col-md-4 text-right">
				<div class="input-group" id="reportrange">
					<input type="text" class="form-control reportrange-value text-right" value="{{ date("F jS Y", strtotime($start)) }} - {{ date("F jS Y", strtotime($end)) }}">
					<span class="input-group-addon reportrange-spinner"><i class="fa fa-calendar"></i></span>
				</div>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">

		<div class="row">
			<div class="col-md-8">
				<div class="content-panel-header">Hits and Visitors</div>
				<div class="content-panel">
					<div id="hit-data" style="height: 192px"></div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="content-panel-header">Basic Stats</div>
				<div class="content-panel">
					<table class="table">
						<tbody>
							<tr>
								<td width="60%">Visitors</td>
								<th class="text-right">{{ $stats['visitors'] }}</th>
							</tr>
							<tr>
								<td>Hits</td>
								<th class="text-right">{{ $stats['hits'] }}</th>
							</tr>
							<tr>
								<td>Hits per Visitor</td>
								<th class="text-right">{{ $stats['hitsper'] }}</th>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div class="row topm">
			<div class="col-md-12">
				<div class="content-panel-header">Top Sites</div>
				<div class="content-panel content-panel-table">
					<table class="table ">	
						<thead>
							<tr>
								<th width="40%">Site Name</th>
								<th>URL</th>
								<th>Owner</th>
								<th>Hits</th>
								<th>Visitors</th>
							</tr>
						</thead>
						<tbody>
						@foreach($stats['sites'] AS $s)
						<?php $site = \App\Site::find($s->site_id); ?>
							<tr>
								<td>{{ $site->name }}</td>
								<td>{{ $site->url }}</td>
								<td><a href='{{ action('Admin\AdminController@showEditUserAccount', $site->user->id) }}'>{{ $site->user->name }}</a></td>
								<td>{{ $s->total_hits }}</td>
								<td>{{ $site->getVisitorDateRange($start, $end) }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div class="row topm">

			<div class="col-sm-4">
				<div class="content-panel-header">Top Browsers</div>
				<div class="content-panel content-panel-table">
					<table class="table ">	
						<thead>
							<tr>
								<th width="60%">Browser</th>
								<th>Hits</th>
							</tr>
						</thead>
						<tbody>
						@foreach($stats['browsers'] AS $b)
							<tr>
								<td>{{ $b->browser_name }}</td>
								<td>{{ $b->total_hits }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>

			<div class="col-sm-4">
				<div class="content-panel-header">Top Devices</div>
				<div class="content-panel content-panel-table">
					<table class="table ">	
						<thead>
							<tr>
								<th width="60%">Device</th>
								<th>Hits</th>
							</tr>
						</thead>
						<tbody>
						@foreach($stats['devices'] AS $b)
							<tr>
								<td>{{ $b->device }}</td>
								<td>{{ $b->total_hits }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>

			<div class="col-sm-4">
				<div class="content-panel-header">Top Locations</div>
				<div class="content-panel content-panel-table">
					<table class="table ">	
						<thead>
							<tr>
								<th width="60%">Location</th>
								<th>Hits</th>
							</tr>
						</thead>
						<tbody>
						@foreach($stats['locations'] AS $b)
							<tr>
								<td>{{ $b->country }}</td>
								<td>{{ $b->total_hits }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>

		</div>

	</div>
</div>

@endsection

@section('head')
@parent
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
@endsection

@section('javascript')
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="{{ asset('assets/themes/basic/js/daterangepicker.js') }}"></script>
<script>
//-- Code to power the date control at the top
//-- of the page. Will refresh the page and data
//-- when changed
$(function() {

	$('#reportrange').daterangepicker({
		"opens": "left",
		"startDate": moment('{{ $start }}'),
		"endDate": moment('{{ $end }}'),
		locale: {
	      format: 'MMMM Do YYYY'
	    },
	}, function(start, end) {
		//-- Asthetics change and send away
		$('.reportrange-value').val(start.format('MMMM Do YYYY') + " - " + end.format('MMMM Do YYYY'));
		$('.reportrange-spinner').html("<i class='fa fa-refresh fa-spin'></i>");	
		window.location = "{{ action('Admin\AdminController@showStats') }}?start=" + start.format('MMMM Do YYYY') + "&end=" + end.format('MMMM Do YYYY');
	});

});
</script>
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script>
graph_data = Morris.Line({
  element: 'hit-data',
  data: [
    @foreach($stats['graph'] as $date => $d)
		{ y: '{{ $date }}', a: {{ $d['hits'] }}, b: {{ $d['visits'] }} },
    @endforeach
  ],
  xkey: 'y',
  ykeys: ['a', 'b'],
  labels: ['Actions', 'Visitors']
});
</script>
@endsection