@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Settings</h2>
			</div>
			<div class="col-md-6 text-right">
				<a href='{{ action('Admin\AdminController@showSystemLogs') }}' class="btn btn-primary btntop"><i class="fa fa-tasks"></i>View System Logs</a>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-8">

				<div class="content-panel-header">Site Settings</div>
				<div class="content-panel">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
						<p><strong>There was a problem creating this package.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					@if (session()->get('success') != null)
					<div class="alert alert-success">
						{!! session()->get('success') !!}
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label>System Name</label>
							<input type="text" name="name" class="form-control" placeholder="Required" value="{{ getConfig('name') }}">
						</div>

						<div class="form-group">
							<label>System Theme</label>
							<select name="theme" class="form-control">
								@foreach(config('analytics.themes') AS $theme)
								<option value="{{ $theme }}" @if (getConfig('theme') == $theme) selected @endif >{{ $theme }}</option>
								@endforeach
							</select>
						</div>

						<div class="form-group">
							<label>Live Users Timeout</label>
							<input type="number" name="live_users" class="form-control" placeholder="Required" value="{{ getConfig('live_test') }}">
						</div>

						<div class="checkbox" style="margin-left: -25px">
							<label>
								<input type="checkbox" style="margin-top: 12px;" name="upgrade" value="true" @if (getConfig('upgrade') == 'true') checked @endif> Show Upgrade Panel
							</label>
						</div>

						<div class="checkbox" style="margin-left: -25px">
							<label>
								<input type="checkbox" style="margin-top: 12px;" name="reg" value="true" @if (getConfig('registration') == 'true') checked @endif> Allow User Registrations
							</label>
						</div>

						<hr />

						<button type="submit" class="btn btn-primary">Save Settings</button>

					</form>					

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>These settings change major parts of the system - please make sure you are <strong>100% correct</strong> before pressing save!</p> 
						<p>The <strong>Live Users Timeout</strong> option tells the system how many minutes to look back from now to check if a user is live on the system.</p>
						<p>The <strong>Show Upgrade Panel </strong> option tells the system if we should show the upgrade panel to the users. This option is perfect if you are running the system for clients!</p>
						<p>The <strong>Allow User Registrations</strong> option tells the system if we should show the option for new users to register to the system. This option is perfect if you are running the system for clients, and do not want the general public signing up for your system.</p>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.11/css/dataTables.bootstrap.min.css">
@endsection

@section('javascript')
<script src='https://cdn.datatables.net/1.10.11/js/jquery.dataTables.min.js'></script>
<script src='https://cdn.datatables.net/1.10.11/js/dataTables.bootstrap.min.js'></script>
<script>
$(document).ready(function() {
    $('.table').DataTable();
});
</script>
@endsection