@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Settings</h2>
			</div>
			<div class="col-md-6 text-right">
				<a href='{{ action('Admin\AdminController@showSystemLogs') }}' class="btn btn-primary btntop"><i class="fa fa-tasks"></i>View System Logs</a>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-12">

				<div class="content-panel-header">System Logs</div>
				<div class="content-panel">

					<table class="table">
						<thead>
							<tr>
								<th>Type</th>
								<th>Log</th>
								<th>Date</th>
							</tr>
						</thead>
						<tbody>
						@foreach($logs AS $log)
						<tr>
							<td>{{ $log->type }}</td>
							<td>{{ $log->log }}</td>
							<td>{{ date("d M Y H:i", strtotime($log->created_at)) }}</td>
						</tr>
						@endforeach
						</tbody>
					</table>

					{!! $logs->links() !!}

				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('javascript')
<script>
$(document).ready(function() {

	$('.pagination').removeClass('pagination').addClass('pagination-plain');
});
</script>
@endsection