@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>List All Payments</h2>
			</div>
			<div class="col-md-6 text-right">
				<h3 style="line-height: 30px;margin: 10px 0;">$ {{ number_format($total, 2) }} - {{ count($payments) }} Transactions</h3>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="content-panel">

					<table class="table">
						<thead>
							<tr>
								<th>User</th>
								<th class="text-right">Package</th>
								<th class="text-right">Payment ID</th>
								<th class="text-right">Amount</th>
								<th class="text-right">Created</th>
							</tr>
						</thead>
						<tbody>
						@foreach($payments AS $payment)
							<tr>
								<td><a href='{{ action('Admin\AdminController@showEditUserAccount', $payment->user->id) }}'>{{ $payment->user->name }}</a></td>
								<td class="text-right">{{ $payment->package->name }}</td>
								<td class="text-right">{{ $payment->payment_id }}</td>
								<td class="text-right" data-order="{{ $payment->amount }}">$ {{ number_format($payment->amount, 2) }}</td>
								<td class="text-right" data-order="{{ $payment->created_at->format("U") }}">{{ $payment->created_at->format("d M Y H:i") }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>

				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.11/css/dataTables.bootstrap.min.css">
@endsection

@section('javascript')
<script src='https://cdn.datatables.net/1.10.11/js/jquery.dataTables.min.js'></script>
<script src='https://cdn.datatables.net/1.10.11/js/dataTables.bootstrap.min.js'></script>
<script>
$(document).ready(function() {
    $('.table').DataTable();
});
</script>
@endsection