@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>List Packages Accounts</h2>
			</div>
			<div class="col-md-6 text-right">
				<a href='{{ action('Admin\AdminController@showAddPackage') }}' class="btn btn-primary btntop"><i class="fa fa-plus"></i>Add Package</a>
				<a href='{{ action('Admin\AdminController@showPackagePayments') }}' class="btn btn-primary btntop"><i class="fa fa-credit-card"></i>View Payments</a>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="content-panel">

					<table class="table">
						<thead>
							<tr>
								<th width="40%">Name</th>
								<th class="text-right">Users</th>
								<th class="text-right">Cost</th>
								<th class="text-right">Ads</th>
								<th class="text-right">Daily Hits</th>
								<th class="text-right">History</th>
								<th class="text-right">Sites</th>
								<th class="text-right" data-orderable="false">&nbsp;</th>
							</tr>
						</thead>
						<tbody>
						@foreach($packages AS $package)
							<tr>
								<td>{{ $package->name }} @if ($package->active == 1) <label class="label label-success">Active</label> @else <label class="label label-danger">Not active</label> @endif</td>
								<td class="text-right">{{ $package->getUsersType() }}</td>
								<td class="text-right">{{ $package->costString() }}</td>
								<td class="text-right">{{ $package->adverts }}</td>
								<td class="text-right">{{ $package->daily_hits }}</td>
								<td class="text-right">{{ $package->history }}</td>
								<td class="text-right">{{ $package->sites }}</td>
								<td class="text-right"><a href='{{ action('Admin\AdminController@showEditPackage', $package->id) }}'>Edit Package</a></td>
							</tr>
						@endforeach
						</tbody>
					</table>				

				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.11/css/dataTables.bootstrap.min.css">
@endsection

@section('javascript')
<script src='https://cdn.datatables.net/1.10.11/js/jquery.dataTables.min.js'></script>
<script src='https://cdn.datatables.net/1.10.11/js/dataTables.bootstrap.min.js'></script>
<script>
$(document).ready(function() {
    $('.table').DataTable();
});
</script>
@endsection