@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Add Package</h2>
			</div>
			<div class="col-md-6 text-right">

			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">
		<div class="row">
			<div class="col-md-8">
				<div class="content-panel-header">Add Package Form</div>
				<div class="content-panel">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
						<p><strong>There was a problem creating this package.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label>Package Name</label>
							<input type="text" name="name" class="form-control" placeholder="Required">
						</div>	

						<div class="checkbox" style="margin-left: -25px">
							<label>
								<input type="checkbox" style="margin-top: 12px;" name="ads" value="1"> Show Adverts
							</label>
						</div>	

						<div class="form-group">
							<label>Daily hits allowed</label>
							<input type="text" name="hits" class="form-control" placeholder="Required - Set as 0 for unlimited">
						</div>

						<div class="form-group">
							<label>How long to keep historical data in days</label>
							<input type="text" name="history" class="form-control" placeholder="Required - Set as 0 for unlimited">
						</div>

						<div class="form-group">
							<label>How many sites allowed</label>
							<input type="text" name="sites" class="form-control" placeholder="Required - Set as 0 for unlimited">
						</div>

						<hr />

						<div class="form-group">
							<label>Cost</label>
							<input type="text" name="cost" class="form-control" placeholder="Required - Set as 0 for free">
						</div>

						<div class="form-group">
							<label>Cost time period</label>
							<select name="time_period" class="form-control">
								<option value="One-off Payment">One-off Payment</option>
								<option value="Monthly">Monthly</option>
								<option value="Yearly">Yearly</option>
							</select>
						</div>

						<div class="form-group">
							<label>Braintree ID</label>
							<input type="text" name="braintree_id" class="form-control" placeholder="Required for monthly and yearly">
						</div>

						<hr />

						<button type="submit" class="btn btn-primary">Create new package</button>

					</form>

				</div>
			</div>
			<div class="col-md-4">

				<div class="help-zone">
					<div class="help-heading"><i class="fa fa-info-circle"></i>Information</div>
					<div class="help-body">
						<p>You can create a new package for your system on this page.</p>
						<p>The <strong>Advert</strong> option lets you choose to display adverts to users who use this package. This feature is based on whether your chosen theme supports adverts.</p>
						<p>The <strong>Daily hits</strong> option lets you set how many hits each site may be recorded a day. If you enter 0, it means there is no limit.</p>
						<p>The <strong>History</strong> option lets you set how long data is kept for. If you enter 0, it means there is no limit, and data will never be deleted.</p>
						<p>The <strong>Sites</strong> option lets you set how many sites the user can have. If you enter 0, it means there is no limit.</p>
						<p>The <strong>Cost</strong> option lets you set how much the package will cost for the user to be part of it. If this is set to 0 then it will be a free package. If it is set to an amount, then please also set the <strong>Cost Time Period</strong>. This option lets you set how often the user is billed. If you set this to Monthly or Yearly, you'll also have to set the <strong>Braintree ID</strong> which is the ID you get when creating a subscription plan in the Branintree admin portal. Please see the help documents if you need more advise and help.</p>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>

@endsection
