@extends('admin.master')

@section('body')

<div class="container installer">
	<div class="row">
		<div class="col-sm-8 col-sm-offset-2">

			<div class="content-panel-header">wrAnalytics - Installer</div>
			<div class="content-panel">
				<div class="container-fluid">
					<div class="row">

						<div class="col-md-4">
							<ul class="wizard">
								<li class="previous"><i class="fa fa-check"></i>Home</li>
								<li class="previous"><i class="fa fa-check"></i>Database</li>
								<li>Test Data</li>
								<li>Admin User</li>
								<li>Confirm</li>
							</ul>
						</div>
						<div class="col-md-8 wizard-text">
							<h3>Test Data</h3>
							<p>&nbsp;</p>
							<p>You can pre-fill your new wrAnalytics system with data so you can get a good grip on how the system works. Adding test data is perfect if you are new to the system, and want to follow the video tutorials. The test data will load the system with 20 users, 40 sites and 1,000 hits from the past week, and will take upto 5 minutes to generate.</p>
							<p>Of course, you can skip this section and proceed with a blank database.</p>
							<div class="row wiz-btns">
								<div class="col-sm-6">
									<a href='{{ action('User\InstallerController@showTestDataCreate') }}?do=true' class="btn btn-warning btn-next">Create Test Data<i class="fa fa-database"></i></a>
								</div>
								<div class="col-sm-6 text-right">
									<a href='{{ action('User\InstallerController@showAdminUserCreate') }}' class="btn btn-success">Skip This Step<i class="fa fa-arrow-right"></i></a>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>

		</div>
	</div>
</div>

@endsection


@section('javascript')
<script>
$('.btn-next').on('click', function() {
	$(this).attr('disabled', 'disabled').html("Creating Test Data<i class='fa fa-refresh fa-spin'></i>");
});
</script>
@endsection