@extends('admin.master')

@section('body')

<div class="container installer">
	<div class="row">
		<div class="col-sm-8 col-sm-offset-2">

			<div class="content-panel-header">wrAnalytics - Installer</div>
			<div class="content-panel">
				<div class="container-fluid">
					<div class="row">

						<div class="col-md-4">
							<ul class="wizard">
								<li class="previous"><i class="fa fa-check"></i>Home</li>
								<li class="previous"><i class="fa fa-check"></i>Database</li>
								<li class="previous"><i class="fa fa-check"></i>Test Data</li>
								<li>Admin User</li>
								<li>Confirm</li>
							</ul>
						</div>
						<div class="col-md-8 wizard-text">
							<h3>Admin User</h3>
							<p>&nbsp;</p>
							<p>You need to now setup an admin user for this system. You can do this by filling in the form below:</p>
							<form method="POST">

								@if (count($errors) > 0)
								<div class="alert alert-danger">
									<p><strong>There was a problem creating this user.</strong></p>
									<ul style="margin-top: 10px">
										@foreach ($errors->all() as $error)
										<li>{{ $error }}</li>
										@endforeach
									</ul>
								</div>
								@endif

								{{ csrf_field() }}

								<div class="form-group">
									<label>Username</label>
									<input type="text" name="username" class="form-control" placeholder="Required">
								</div>	

								<div class="form-group">
									<label>Email Address</label>
									<input type="email" name="email" class="form-control" placeholder="Required">
								</div>	

								<div class="form-group">
									<label>Password</label>
									<input type="text" name="password" class="form-control" placeholder="Required">
								</div>	

								<hr />

								<div class="row wiz-btns">
									<div class="col-sm-6">
										&nbsp;
									</div>
									<div class="col-sm-6 text-right">
										<button type="submit" class="btn btn-success">Create Admin User<i class="fa fa-arrow-right"></i></button>
									</div>
								</div>

							</form>

						</div>

					</div>
				</div>
			</div>

		</div>
	</div>
</div>

@endsection


@section('javascript')
<script>
	$('.btn-next').on('click', function() {
		$(this).attr('disabled', 'disabled').html("Creating DB<i class='fa fa-refresh fa-spin'></i>");
	});
</script>
@endsection