@extends('admin.master')

@section('body')

@include('admin.topbar')

<div id="header-content">
	<div class="container">
		<div class="row">
			<div class="col-md-6 text-left">
				<h2>Dashboard</h2>
			</div>
			<div class="col-md-6 text-right">
				<a href='{{ action('User\UserController@showDashboard') }}' class="btn btn-primary btntop"><i class="fa fa-bolt"></i>View Front End</a>
			</div>
		</div>
	</div>
</div>

<div id="content">
	<div class="container">

		<div class="row" style="margin-bottom: 30px">
			<div class="col-md-4">

				<div class="content-panel-header">Live Data</div>
				<div class="content-panel live-data-section">

					<div class="text-center">
						<h3 class="live-users">{{ $live['visitors'] }}</h3>
						<p>active visitors</p>
					</div>
					<!-- Device Type -->
					<div class="live-device-type">
						<div class="row">
							<div class="col-md-12">
								<ul class="device-list">
									<li><i class="fa fa-square device-desktop"></i>Desktop</li>
									<li><i class="fa fa-square device-mobile"></i>Mobile</li>
									<li><i class="fa fa-square device-tablet"></i>Tablet</li>
									<li><i class="fa fa-square device-other"></i>Other</li>
								</ul>
							</div>
						</div>
						<div class="progress">
							<div class="progress-bar progress-bar-success bar-desktop" style="width: 0%">
								<span class="sr-only">0%</span>
							</div>
							<div class="progress-bar progress-bar-warning bar-mobile" style="width: 0%">
								<span class="sr-only">20%</span>
							</div>
							<div class="progress-bar progress-bar-danger bar-tablet" style="width: 0%">
								<span class="sr-only">10%</span>
							</div>
							<div class="progress-bar progress-bar-info bar-other" style="width: 0%">
								<span class="sr-only">10%</span>
							</div>
						</div>

					</div>	

				</div>
			</div>
			<div class="col-md-8">

				<div class="content-panel-header">Last 10 Days</div>
				<div class="content-panel">
					<div id="last-10" style="height: 192px"></div>
				</div>

			</div>

		</div>

		<div class="row">
			<div class="col-md-12">

				<div class="content-panel-header">Todays Statistics</div>
				<div class="content-panel">

					<div class="row">	
						<div class="col-sm-3 dash-stats active-sites">
							{{ $live['active'] }} 
							<span>active sites</span>
						</div>
						<div class="col-sm-3 dash-stats total-visitors">
							{{ number_format($live['visits'], 0) }}
							<span>total visitors</span>
						</div>
						<div class="col-sm-3 dash-stats total-actions">
							{{ number_format($live['hits'], 0) }}
							<span>total actions</span>
						</div>
						<div class="col-sm-3 dash-stats">
							<div class="render-stat">{{ $live['render'] }} s</div>
							<span>render time&nbsp;&nbsp;<i class="fa fa-info-circle" data-toggle="popover" data-placement="left" title="Render Time" data-content="This is the amount of time taken to render the system on each computer. If this time is over 0.200 s, then please investigate."></i></span>
						</div>
					</div>

				</div>
			</div>
		</div>

	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
@endsection

@section('javascript')
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/1.4.5/numeral.min.js"></script>
<script>
	$(function () {
		$('[data-toggle="popover"]').popover()
	})
</script>
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script>
graph_data = Morris.Line({
  element: 'last-10',
  data: [
    @foreach($live['graph'] as $date => $d)
		{ y: '{{ $date }}', a: {{ $d['hits'] }}, b: {{ $d['visits'] }} },
    @endforeach
  ],
  xkey: 'y',
  ykeys: ['a', 'b'],
  labels: ['Actions', 'Visitors']
});
</script>
<script>
getLiveData();
/**
 * Function to grab live data from the server
 *
 */
function getLiveData() 
{
	$.get('{{ action('Admin\AdminController@getLiveJSON') }}', function(data) {

		//-- Main visitors
		$('.live-users').html(data.visitors);
		$('.bar-desktop, .bar-mobile, .bar-tablet, .bar-other').css('width', 0).html('<span class="sr-only">0%</span>');
		if (data.device != null) {
			if (data.device.Desktop != null) { $('.bar-desktop').css('width', data.device.Desktop + "%").html(data.device.Desktop + '%'); }
			if (data.device.Mobile != null)  { $('.bar-mobile').css('width', data.device.Mobile + "%").html(data.device.Mobile + '%'); }
			if (data.device.Tablet != null)  { $('.bar-tablet').css('width', data.device.Tablet + "%").html(data.device.Tablet + '%'); }
			if (data.device.Other != null)   { $('.bar-other').css('width', data.device.Other + "%").html(data.device.Other + '%'); }
		}
		$('.active-sites').html(data.active + "<span>active sites</span>");
		$('.total-visitors').html(numeral(data.visits).format('0,0') + "<span>total visitors</span>");
		$('.total-actions').html(numeral(data.hits).format('0,0') + "<span>total actions</span>");
		$('.render-stat').html(data.render + " s");

		graph_data.setData(data.json);
	});

	//-- Fire again in 5 seconds
	setTimeout(getLiveData, 5000)
}

</script>
@endsection