<?php

use Illuminate\Database\Seeder;

class RawDataTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //-- Create raw data
        $data    = rand(5000, 7000);
        $site_id = 1;
        $days    = 12;
        $sites   = 4;

        for ($i = 0; $i < $data; $i++) {
            $f = \Faker\Factory::create();

            $random_user = str_random(1);
            $time = $f->dateTimeBetween("-".$days." days", "now");
            $rand_site = rand(1, $sites);

            $id = \DB::table('raw')->insertGetId([
                'site_id'           => $rand_site,
                'visitor_id'        => $random_user,
                'page_url'          => random_array(array("index", "analytics", "dashboard", "live", "other")),
                'referer_type'      => 3,
                'referer_url'       => $f->url,
                'os'                => random_array(array("Windows", "Linux", "Mac", "iOS", "Android")),
                'browser_name'      => random_array(array("Chrome", "IE", "Firefox", "Safari", "Opera")),
                'browser_version'   => '10.0.0',
                'device'            => random_array(array("Desktop", "Mobile", "Tablet", "Other")),
                'resolution'        => random_array(array("1024x768", "1920x1080", "800x600")),
                'ip'                => $f->ipv4,
                'browser_lang'      => $f->locale,
                'country'           => $f->country,
                'city'              => $f->city,
                'javascript'        => random_array(array(0, 1)),
                'pageload_time'     => rand(10, 100),
                'system_time'       => rand(10, 100) / 1000,
                'created_at'        => $time
            ]);

            //-- When was the last time this user visited the site?
            $check = \DB::table('raw')->where('site_id', $rand_site)->where('visitor_id', $random_user)->where('id', '!=', $id)->orderBy('id', 'DESC')->first();
            if ($check != false) {
                //-- Check to see if we are within our session time of 10 mins
                $diff = abs(strtotime($time->format('Y-m-d H:i:s')) - strtotime($check->created_at));
                if ($diff < 600) {
                    \DB::table('raw')->where('id', $id)->update(array('time_since_last_visit' => $diff));
                }
            }
        }
    }
}
