<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->increments('id');

            $table->string('name');
            $table->string('name_slug');

            //-- These are features that make up a package
            $table->integer('adverts');
            $table->integer('daily_hits');
            $table->integer('history');
            $table->integer('sites');

            //-- Whats the cost for this package
            $table->string('cost');
            $table->string('time_period')->default('');
            $table->string('braintree_id')->default('');

            //-- Can this package be selected
            $table->integer('active');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('packages');
    }
}
