<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRawTable extends Migration
{
    /**
     * Run the migrations. Based on 
     * https://developer.piwik.org/guides/persistence-and-the-mysql-backend
     *
     * @return void
     */
    public function up()
    {
        Schema::create('raw', function (Blueprint $table) {

            $table->increments('id');

            //-- IDs
            $table->string('site_id');
            $table->string('visitor_id');

            //-- What data do we need
            $table->string('page_url');
            $table->string('referer_type');
            $table->string('referer_name');
            $table->string('referer_url');
            $table->string('os');
            $table->string('browser_name');
            $table->string('browser_version');
            $table->string('device');
            $table->string('resolution');
            $table->string('ip');
            $table->string('browser_lang');
            $table->string('country');
            $table->string('city');
            $table->string('javascript');

            //-- Basic visitor information
            $table->string('time_since_last_visit');
            $table->string('pageload_time');

            //-- System Info
            $table->string('system_time');

            //-- Time
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('raw');
    }
}
