<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');

            $table->text('user_validation');
            $table->text('password_reset');

            $table->integer('active');
            $table->integer('admin');
            $table->integer('package_id');
            $table->string('current_package_subscription')->default('');

            $table->rememberToken();
            $table->datetime('last_logged');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
