<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

$factory->define(App\User::class, function (Faker\Generator $faker) {
    return [
        'name'            => $faker->name,
        'email'        => $faker->safeEmail,
        'password'        => bcrypt(str_random(10)),
        'active'        => 1,
        'package_id'    => 1,
        'remember_token' => str_random(10),
    ];
});

$factory->define(App\Site::class, function (Faker\Generator $faker) {
    return [
        'uuid'            => createUniqueStrings('sites', 'uuid', 10),
        'name'            => $faker->domainName,
        'url'            => "http://" . $faker->domainName,
        'timezone'        => $faker->timezone,
        'author_id'    => rand(1, 20),
    ];
});
