<?php

namespace app;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Get our sites
     */
    public function sites()
    {
        return $this->hasMany('App\Site', 'author_id', 'id');
    }

    /** 
     * Get our package
     */
    public function package()
    {
        return $this->belongsTo('App\Package');
    }
}
