<?php

namespace app;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    //

    /**
     * Get how many people use this package type
     *
     * @return int
     */
    public function getUsersType()
    {
        $count = \App\User::where('package_id', $this->id)->get();
        return count($count);
    }

    /**
     * Gets a string of our payment terms
     *
     * @return string
     */
    public function costString()
    {
        $cost = "$" . number_format($this->cost, 2);
        if ($this->time_period != '') {
            return $cost . " / " . $this->time_period;
        }
        return $cost;
    }
}
