<?php

namespace app\Http\ViewComposers;

use Illuminate\View\View;
use Illuminate\Http\Request;

class SidebarComposer
{
    /**
     * The user repository implementation.
     *
     * @var UserRepository
     */
    protected $site;

    /**
     * Create a new profile composer.
     *
     * @param  UserRepository  $users
     * @return void
     */
    public function __construct(Request $request)
    {
        //-- Do we have a particular site selected?
        $uuid = $request->uuid;
        $check = \App\Site::where('uuid', $uuid)->where('uuid', '!=', '')->where('author_id', \Auth::user()->id)->first();
        if ($check == false) {
            $this->site = null;
        } else {
            $this->site = $check;
        }
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('site_selected', $this->site);
    }
}
