<?PHP 

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| This route group applies the "web" middleware group to every route
| it contains. The "web" middleware group is defined in your HTTP
| kernel and includes session state, CSRF protection, and more.
|
*/

Route::group(['middleware' => ['web']], function () {
    
    //-- Authentication Routes
    Route::group(['prefix' => 'auth'], function () {

        Route::any('login',            'Auth\UserAuthController@loginSystem');
        Route::any('logout',            'Auth\UserAuthController@logoutSystem');
        Route::any('register',            'Auth\UserAuthController@registerSystem');
        Route::any('validate/{val}',    'Auth\UserAuthController@validateUserRegistration');
        Route::any('forgot',            'Auth\UserAuthController@forgotPasswordSystem');
        Route::any('reset/{val}',        'Auth\UserAuthController@resetPasswordSystem');
    });

    //-- Authenticated routes
    Route::group(['middleware' => ['auth'], 'prefix' => 'user'], function () {

        Route::any('dashboard',                'User\UserController@showDashboard');
        Route::any('date-control',        'User\UserController@changeDateControl');
        Route::any('upgrade',                'User\UserController@showUserUpgrade');
        Route::any('upgrade/to/{slug}',        'User\UserController@showUserUpgradePayment');

        //-- Sites Creation
        Route::any('sites/create', 'User\SiteController@createSite');

        //-- Site Specific
        Route::any('site/{uuid}/dashboard',    'User\SiteController@siteDashboard');
        Route::any('site/{uuid}/content',        'User\SiteController@siteContent');
        Route::any('site/{uuid}/locations',    'User\SiteController@siteLocation');
        Route::any('site/{uuid}/technology',    'User\SiteController@siteTech');
        Route::any('site/{uuid}/referers',        'User\SiteController@siteRefs');
        Route::any('site/{uuid}/settings',        'User\SiteController@siteSettings');
        Route::any('site/{uuid}/live',            'User\SiteController@siteLive');
        Route::any('site/{uuid}/delete',        'User\SiteController@siteDelete');
        
        //-- Site API Stuff
        Route::any('site/{uuid}/stats/live',    'User\SiteController@getLiveStats');
        
    });

});
