<?PHP 

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| This route group applies the "web" middleware group to every route
| it contains. The "web" middleware group is defined in your HTTP
| kernel and includes session state, CSRF protection, and more.
|
*/

Route::group(['middleware' => ['web']], function () {

    //-- Routes used for data collection
    Route::any('api/js/{name}',        'API\APIController@sendJS');
    Route::any('api/visit/{name}',    'API\APIController@visitBeacon');

});

//-- Payment webhoks
Route::any('api/webhook/braintree',            'API\APIController@paymentBraintreeWebhook');

//-- Installer Routes
Route::group(['middleware' => ['web']], function () {

    route::any('install/home',    'User\InstallerController@showHomeInstaller');
    route::any('install/one',    'User\InstallerController@showDatabaseCheck');
    route::any('install/two',    'User\InstallerController@showTestDataCreate');
    route::any('install/three',    'User\InstallerController@showAdminUserCreate');
    route::any('install/final',    'User\InstallerController@showConfirm');
});
