<?PHP 

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| This route group applies the "web" middleware group to every route
| it contains. The "web" middleware group is defined in your HTTP
| kernel and includes session state, CSRF protection, and more.
|
*/

Route::group(['middleware' => ['web']], function () {

    Route::group(['middleware' => ['admin'], 'prefix' => 'admin'], function () {

        Route::any('dashboard',            'Admin\AdminController@showDashboard');
        Route::any('live',                'Admin\AdminController@getLiveJSON');
        Route::any('stats',                'Admin\AdminController@showStats');

        //-- Users
        Route::any('users/list',            'Admin\AdminController@showUserAccounts');
        Route::any('users/add',                'Admin\AdminController@showAddUserAccount');
        Route::any('users/edit/{id}',        'Admin\AdminController@showEditUserAccount');
        Route::any('users/loginas/{id}',    'Admin\AdminController@loginAsUser');
        Route::any('users/delete/{id}',        'Admin\AdminController@deleteUser');

        //-- Packages
        Route::any('packages/list',            'Admin\AdminController@showPackages');
        Route::any('packages/add',            'Admin\AdminController@showAddPackage');
        Route::any('packages/edit/{id}',    'Admin\AdminController@showEditPackage');
        Route::any('packages/payments',        'Admin\AdminController@showPackagePayments');

        //-- Settings
        Route::any('settings/main',            'Admin\AdminController@showSettings');
        Route::any('settings/logs',            'Admin\AdminController@showSystemLogs');

    });

});
