<?php

namespace app\Http\Controllers\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class InstallerController extends Controller
{
    /**
     * Shows the main page of the installer
     *
     * @return void
     */
    public function showHomeInstaller(Request $request)
    {
        //-- Installer check
        if (config('analytics.installed')) {
            return redirect()->to('/');
        }
        return view('admin.installer.home');
    }

    /**
     * Shows page one of the installer. Database check
     *
     * @return void
     */
    public function showDatabaseCheck(Request $request)
    {
        //-- Installer check
        if (config('analytics.installed')) {
            return redirect()->to('/');
        }

        //-- Lets create our tables
        if ($request->input('do', '') == true) {

            //-- Delete all tables just in case. We'll wrap this in a try catch 
            //-- as hopefully it'll error saying they do not exist
            try {
                \DB::statement("DROP TABLE `users`;");
                \DB::statement("DROP TABLE `sites`;");
                \DB::statement("DROP TABLE `raw`;");
                \DB::statement("DROP TABLE `packages`;");
                \DB::statement("DROP TABLE `settings`;");
                \DB::statement("DROP TABLE `log`;");
                \DB::statement("DROP TABLE `payments`;");
            } catch (\Exception $e) {
                //-- Do nothing :)
            }

            //-- Users Table
            \DB::statement("create table `users` (`id` int unsigned not null auto_increment primary key, `name` varchar(255) not null, `email` varchar(255) not null, `password` varchar(255) not null, `user_validation` text not null, `password_reset` text not null, `active` int not null, `admin` int not null, `package_id` int not null, `current_package_subscription` varchar(255) not null default '', `remember_token` varchar(100) null, `last_logged` datetime not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci");
            \DB::statement('alter table `users` add unique `users_email_unique`(`email`)');
            //-- Sites
            \DB::statement('create table `sites` (`id` int unsigned not null auto_increment primary key, `uuid` varchar(255) not null, `name` varchar(255) not null, `url` varchar(255) not null, `timezone` varchar(255) not null, `author_id` int not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci');
            //-- Raw
            \DB::statement("create table `raw` (`id` int unsigned not null auto_increment primary key, `site_id` varchar(255) not null, `visitor_id` varchar(255) not null, `page_url` varchar(255) not null, `referer_type` varchar(255) not null, `referer_name` varchar(255) not null, `referer_url` varchar(255) not null, `os` varchar(255) not null, `browser_name` varchar(255) not null, `browser_version` varchar(255) not null, `device` varchar(255) not null, `resolution` varchar(255) not null, `ip` varchar(255) not null, `browser_lang` varchar(255) not null, `country` varchar(255) not null, `city` varchar(255) not null, `javascript` varchar(255) not null, `time_since_last_visit` varchar(255) not null, `pageload_time` varchar(255) not null, `system_time` varchar(255) not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci");
            //-- Packages
            \DB::statement("create table `packages` (`id` int unsigned not null auto_increment primary key, `name` varchar(255) not null, `name_slug` varchar(255) not null, `adverts` int not null, `daily_hits` int not null, `history` int not null, `sites` int not null, `cost` varchar(255) not null, `time_period` varchar(255) not null default '', `braintree_id` varchar(255) not null default '', `active` int not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci");
            //-- Settings
            \DB::statement("create table `settings` (`name` varchar(255) not null, `value` varchar(255) not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci");
            //-- Logs
            \DB::statement('create table `log` (`id` int unsigned not null auto_increment primary key, `type` varchar(255) not null, `log` text not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci');
            //-- Payments
            \DB::statement("create table `payments` (`id` int unsigned not null auto_increment primary key, `user_id` int not null, `package_id` int not null, `payment_id` text not null, `amount` varchar(255) not null, `created_at` timestamp null, `updated_at` timestamp null) default character set utf8 collate utf8_unicode_ci");

            //-- Place settings in database
            \DB::table('settings')->insert(['name' => 'theme', 'value' => 'basic']);
            \DB::table('settings')->insert(['name' => 'name', 'value' => 'WRAnalytics']);
            \DB::table('settings')->insert(['name' => 'live_test', 'value' => '10']);
            \DB::table('settings')->insert(['name' => 'upgrade', 'value' => 'true']);
            \DB::table('settings')->insert(['name' => 'registration', 'value' => 'true']);

            //-- Create our default package
            \DB::table('packages')->insert([
                'name' => 'Default',
                'name_slug' => 'default',
                'adverts' => 1,
                'daily_hits' => 1000,
                'history' => 7,
                'sites' => 3,
                'cost' => 0,
                'active' => 1,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ]);

            //-- Awesome, next page!	        
            return redirect()->to(action('User\InstallerController@showTestDataCreate'));
        }

        return view('admin.installer.page_one', []);
    }

    /**
     * Show the test data page
     *
     * @return void
     */
    public function showTestDataCreate(Request $request)
    {
        //-- Installer check
        if (config('analytics.installed')) {
            return redirect()->to('/');
        }

        //-- Lets create our tables
        if ($request->input('do', '') == true) {

            //-- First, lets create 20 users
            factory(\App\User::class, 20)->create();
            //-- Secondly, 40 sites
            factory(\App\Site::class, 40)->create();
            //-- Finally, 10,000 hits
            $data    = 1000;
            $days    = 7;
            $sites   = 40;
            for ($i = 0; $i < $data; $i++) {
                $f = \Faker\Factory::create();

                $random_user = str_random(1);
                $time = $f->dateTimeBetween("-".$days." days", "now");
                $rand_site = rand(1, $sites);

                $id = \DB::table('raw')->insertGetId([
                    'site_id'           => $rand_site,
                    'visitor_id'        => $random_user,
                    'page_url'          => random_array(array("index", "analytics", "dashboard", "live", "other")),
                    'referer_type'      => 3,
                    'referer_url'       => $f->url,
                    'os'                => random_array(array("Windows", "Linux", "Mac", "iOS", "Android")),
                    'browser_name'      => random_array(array("Chrome", "IE", "Firefox", "Safari", "Opera")),
                    'browser_version'   => '10.0.0',
                    'device'            => random_array(array("Desktop", "Mobile", "Tablet", "Other")),
                    'resolution'        => random_array(array("1024x768", "1920x1080", "800x600")),
                    'ip'                => $f->ipv4,
                    'browser_lang'      => $f->locale,
                    'country'           => $f->country,
                    'city'              => $f->city,
                    'javascript'        => random_array(array(0, 1)),
                    'pageload_time'     => rand(10, 100),
                    'system_time'       => rand(10, 100) / 100,
                    'created_at'        => $time
                    ]);

                //-- When was the last time this user visited the site?
                $check = \DB::table('raw')->where('site_id', $rand_site)->where('visitor_id', $random_user)->where('id', '!=', $id)->orderBy('id', 'DESC')->first();
                if ($check != false) {
                    //-- Check to see if we are within our session time of 10 mins
                    $diff = abs(strtotime($time->format('Y-m-d H:i:s')) - strtotime($check->created_at));
                    if ($diff < 600) {
                        \DB::table('raw')->where('id', $id)->update(array('time_since_last_visit' => $diff));
                    }
                }
            }

            //-- Forward to next stage
            return redirect()->to(action('User\InstallerController@showAdminUserCreate'));
        }

        return view('admin.installer.page_two', []);
    }

    /** 
     * Shows the admin account page
     *
     * @return void
     */
    public function showAdminUserCreate(Request $request)
    {
        //-- Installer check
        if (config('analytics.installed')) {
            return redirect()->to('/');
        }

        //-- Lets create our tables
        if ($request->isMethod('post')) {

            //-- Run Validations
            $validator = \Validator::make($request->all(), [
                'username'    => 'required|unique:users,name|min:5|max:100',
                'email'    => 'required|email|unique:users,email',
                'password'    => 'required|min:5',
                ]);

            if ($validator->fails()) {
                //-- GO back and show errors
                return redirect()
                ->back()
                ->withErrors($validator)
                ->withInput();
            }

            //-- Passed validation, lets setup the user on the system
            $u = new \App\User;
            $u->name        = $request->input('username');
            $u->email        = $request->input('email');
            $u->password    = bcrypt($request->input('password'));
            $u->active        = 1;
            $u->admin        = 1;
            $u->package_id    = 1;
            $u->save();

            //-- Lets forward to 
            return redirect()->to(action('User\InstallerController@showConfirm'));
        }

        return view('admin.installer.page_three', []);
    }

    /**
     * Show confirm page
     *
     * @return void
     */
    public function showConfirm(Request $request)
    {
        //-- Installer check
        if (config('analytics.installed')) {
            return redirect()->to('/');
        }

        return view('admin.installer.page_final', []);
    }
}
