<?php

namespace app\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        // Commands\Inspire::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //-- Run the historical data cull every day at middnight!
        $schedule->call(function () {
            $sites = \App\Site::get();
            foreach ($sites as $site) {
                $site->deleteHistorical();
                \DB::table('log')->insert(['type' => 'History CRON', 'log' => "History CRON finished", 'created_at' => date("Y-m-d H:i:s")]);
            }
        })->daily();
    }
}
