<?php
/*Front end view of testimonials shortcode
==================================*/
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

	if($testimonials_grid_column==4)
	{
		$carousel_col_class = 3;
	}
	elseif($testimonials_grid_column==3)
	{
		$carousel_col_class = 4;
	}
	elseif($testimonials_grid_column==6)
	{
		$carousel_col_class = 2;
	}
	elseif($testimonials_grid_column==12)
	{
		$carousel_col_class = 1;
	}
	
	$post_output = '<div class="'.esc_attr( $css_class ).'">';
	if($testimonials_view=="carousel"){
		$post_output .= '<div class="carousel-wrapper">';
	} else {
		$post_output .= '<div class="row">';
	}
	if($testimonials_view=="carousel")
	{
		if ( is_rtl() )
		{
			$data_rtl = 'data-rtl="rtl"';
		}
		else
		{
			$data_rtl = 'data-rtl="ltr"';
		}
		if($testimonials_carousel_arrows==1){
			$carrows = 'yes';
		} else {
			$carrows = 'no';
		}
		if($testimonials_carousel_pagi==1){
			$cpagi = 'yes';
		} else {
			$cpagi = 'no';
		}
		if($testimonials_carousel_rotate!=''){
			$cauto = $testimonials_carousel_rotate;
		} else {
			$cauto = '';
		}
		$post_output .= '<div class="row"><ul class="owl-carousel '.$testimonials_center.' '.$testimonials_skin.' carousel-fw testimonials-carousel" data-columns="'.esc_attr($carousel_col_class).'" data-autoplay="'.$cauto.'" data-pagination="'.$cpagi.'" data-arrows="'.$carrows.'" data-single-item="no" data-items-desktop="'.esc_attr($carousel_col_class).'" data-items-desktop-small="'.esc_attr($carousel_col_class).'" data-items-tablet="1" data-items-mobile="1" '.$data_rtl.'>';
	}
	elseif($testimonials_view=="grid")
	{
		$post_output .= '<ul class="grid-holder isotope gallery-items '.$testimonials_center.' '.$testimonials_skin.'" data-sort-id="gallery">';
	}
	if($testimonials_terms!='')
	{
		$terms = explode(',', $testimonials_terms);
		$post_args = array('post_type'=>'testimonial', 'posts_per_page'=>$testimonials_number, 'paged' => $paged, 'tax_query'=>array(array('taxonomy'=>'testimonial-category', 'field'=>'term_id', 'terms'=>$terms, 'operator'=>'IN')));
	}
	else
	{
		$post_args = array('post_type'=>'testimonial', 'posts_per_page'=>$testimonials_number, 'paged' => $paged);
	}
	$post_list = new WP_Query($post_args);
	if($post_list->have_posts()):while($post_list->have_posts()):$post_list->the_post();
	$testi_subtitle = get_post_meta(get_the_ID(), 'tentered_testi_sub_title', true);
	
	// Carousel View
	if($testimonials_view=="carousel")
	{
	$post_output .= '<li class="item testimonial">';
	if($testimonials_photo == 1){
		if(has_post_thumbnail())
		{
			$post_output .= '<div class="img-block">'.get_the_post_thumbnail(get_the_ID(),'tentered-200x200').'</div>';
		} else {
			$post_output .= '<div class="img-block"><i class="fa fa-quote-left"></i></div>';
		}
	} else {
		$post_output .= '<div class="img-block"><i class="fa fa-quote-left"></i></div>';
	}
	$post_output .= '<blockquote>';
	$post_output .= get_the_excerpt();
		if($testimonials_author == 1){
			$post_output .= '<cite>'.get_the_title().'</cite>';
			if($testimonials_subtitle == 1){
				$post_output .= '<span class="meta-data">'.$testi_subtitle.'</span>';
			}
		}
		$post_output .= '</blockquote></li>';
	}
	
	// Grid View
	else
	{
		$post_output .= '<li class="col-md-'.$testimonials_grid_column.' col-sm-6 grid-item testimonial testimonial-grid-item format-standard">';
	if($testimonials_photo == 1){
		if(has_post_thumbnail())
		{
			$post_output .= '<div class="img-block">'.get_the_post_thumbnail(get_the_ID(),'tentered-200x200').'</div>';
		} else {
			$post_output .= '<div class="img-block"><i class="fa fa-quote-left"></i></div>';
		}
	} else {
		$post_output .= '<div class="img-block"><i class="fa fa-quote-left"></i></div>';
	}
	$post_output .= '<blockquote>';
	$post_output .= get_the_excerpt();
		if($testimonials_author == 1){
			$post_output .= '<cite>'.get_the_title().'</cite>';
			if($testimonials_subtitle == 1){
				$post_output .= '<span class="meta-data">'.$testi_subtitle.'</span>';
			}
		}
		$post_output .= '</blockquote></li>';
	}
	endwhile; endif; wp_reset_postdata();
	$post_output .= '</ul>';
	if($testimonials_view=="carousel")
	{
		$post_output .= '</div></div></div>';
	}
	else
	{
		$post_output .= '</div></div>';
	}
	
	global $tentered_allowed_tags;
	echo wp_kses($post_output, $tentered_allowed_tags);
	if($testimonials_pagination == 1){
		$post_output .= '<div class="margin-10"></div>';
		$GLOBALS['wp_query'] = $post_list;
		$post_output .= tentered_pagination();
 		wp_reset_query();
	}
?>