<?php
/*Front end view of team shortcode
==================================*/
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

	if($team_grid_column==4)
	{
		$carousel_col_class = 3;
	}
	elseif($team_grid_column==3)
	{
		$carousel_col_class = 4;
	}
	elseif($team_grid_column==6)
	{
		$carousel_col_class = 2;
	}
	elseif($team_grid_column==12)
	{
		$carousel_col_class = 1;
	}
	elseif($team_grid_column==2)
	{
		$carousel_col_class = 6;
	}
	$post_output = '<div class="'.esc_attr( $css_class ).'">';
	if($team_view=="carousel"){
		$post_output .= '<div class="carousel-wrapper">';
	} elseif($team_view=="grid"){
		$post_output .= '<div class="row">';
	}
	if($team_view=="carousel")
	{
		if ( is_rtl() )
		{
			$data_rtl = 'data-rtl="rtl"';
		}
		else
		{
			$data_rtl = 'data-rtl="ltr"';
		}
		if($team_carousel_arrows==1){
			$carrows = 'yes';
		} else {
			$carrows = 'no';
		}
		if($team_carousel_pagi==1){
			$cpagi = 'yes';
		} else {
			$cpagi = 'no';
		}
		if($team_carousel_rotate!=''){
			$cauto = $team_carousel_rotate;
		} else {
			$cauto = '';
		}
		$post_output .= '<div class="row"><ul class="owl-carousel carousel-fw team-carousel" data-columns="'.esc_attr($carousel_col_class).'" data-autoplay="'.$cauto.'" data-pagination="'.$cpagi.'" data-arrows="'.$carrows.'" data-single-item="no" data-items-desktop="'.esc_attr($carousel_col_class).'" data-items-desktop-small="'.esc_attr($carousel_col_class).'" data-items-tablet="2" data-items-mobile="1" '.$data_rtl.'>';
	}
	elseif($team_view=="list")
	{
		$post_output .= '<div class="listings-block">';
	}
	elseif($team_view=="grid")
	{
		$post_output .= '<ul class="grid-holder isotope gallery-items" data-sort-id="gallery">';
	}
	if($team_terms!='')
	{
		$terms = explode(',', $team_terms);
		$post_args = array('post_type'=>'team', 'posts_per_page'=>$team_number, 'paged' => $paged, 'tax_query'=>array(array('taxonomy'=>'team-category', 'field'=>'term_id', 'terms'=>$terms, 'operator'=>'IN')));
	}
	else
	{
		$post_args = array('post_type'=>'team', 'posts_per_page'=>$team_number, 'paged' => $paged);
	}
	$post_list = new WP_Query($post_args);
	if($post_list->have_posts()):while($post_list->have_posts()):$post_list->the_post();
	$position = get_post_meta(get_the_ID(), 'tentered_staff_position', true);
	$facebook = get_post_meta(get_the_ID(), 'tentered_staff_member_facebook', true);
	$twitter = get_post_meta(get_the_ID(), 'tentered_staff_member_twitter', true);
	$gplus = get_post_meta(get_the_ID(), 'tentered_staff_member_gplus', true);
	$linkedin = get_post_meta(get_the_ID(), 'tentered_staff_member_linkedin', true);
	$pinterest = get_post_meta(get_the_ID(), 'tentered_staff_member_pinterest', true);
	$email = get_post_meta(get_the_ID(), 'tentered_staff_member_email', true);
	$phone = get_post_meta(get_the_ID(), 'tentered_staff_member_phone', true);
	$social = '';
	$social_data = array();
	$social_data = array('phone'=>$phone, 'envelope'=>$email, 'facebook'=>$facebook, 'twitter'=>$twitter, 'google-plus'=>$gplus, 'linkedin'=>$linkedin, 'pinterest'=>$pinterest);
	if($facebook!=''||$twitter!=''||$gplus!=''||$linkedin!=''||$pinterest!=''||$email!=''||$phone!='')
	{
	foreach($social_data as $key=>$value)
	{
		if($value!='')
		{
			$url = $value;
			if($key=="envelope")
			{
				$url = 'mailto:'.$value;
			}
			if($key=="phone")
			{
				$url = 'tel:'.$value;
			}
			$social .= '<a href="'.$url.'">
						  <i class="fa fa-2x fa-'.$key.'"></i>
					  </a>';
		}
	}
	}
	$thumbnail = '';
	if($team_img_size != ''){
		$post_thumbnail = wpb_getImageBySize( array('post_id' => get_the_ID(),'thumb_size' => $team_img_size) );
		$thumbnail = $post_thumbnail['thumbnail'];
	} else {
		$post_thumbnail = get_the_post_thumbnail(get_the_ID(),'tentered-400x400');
		$thumbnail = $post_thumbnail;
	}
	
	// Carousel View
	if($team_view=="carousel")
	{
	$post_output .= '<li class="item">
                     <div class="grid-item team-item team-carousel-item format-standard">';
	
		if(has_post_thumbnail())
		{
			$post_output .= '<div class="team-image">'.$thumbnail.'';
		} else {
			$post_output .= '<div class="team-image"><img src="' . vc_asset_url( 'vc/no_image.png' ) . '" alt="" width="400" height="400">';
		}
		if($team_social == 1){
			$post_output .= '<div class="team-overlay"><div class="team-overlay-bg"></div> <div class="team-info"> <div class="social-icon">'.$social.'</div></div></div>';
		}
	$post_output .= '</div><h4 class="team-name">';
	if($team_permalink == 1){
		$post_output .= '<a href="'.get_permalink().'">';
	}
	$post_output .= get_the_title();
	if($team_permalink == 1){
		$post_output .= '</a>';
	}
	$post_output .= '</h4>';
	if($team_position == 1){
		$post_output .= '<div class="team-position">'.$position.'</div>';
	}
	$post_output .= '</div></li>';
  	}
	
	// List View
	elseif($team_view=="list")
	
	
	{
		$post_output .= '<div class="team-list-item format-standard">
                        	<div class="row">';
			if(has_post_thumbnail())
			{
				$post_output .= '<div class="col-md-4 col-sm-4 team-list-thumb">';
				$post_output .= $thumbnail;
				$post_output .= '</div><div class="col-md-8 col-sm-8"><h3>';
			} else {
				$post_output .= '<div class="col-md-4 col-sm-4 team-list-thumb">';
				$post_output .= '<img src="' . vc_asset_url( 'vc/no_image.png' ) . '" alt="" width="400" height="400">';
				$post_output .= '</div><div class="col-md-8 col-sm-8"><h3>';
			}
			if($team_permalink == 1){
				$post_output .= '<a href="'.get_permalink().'">';
			}
   		$post_output .= ''.get_the_title().'';
		if($team_permalink == 1){
			$post_output .= '</a>';
		}
		$post_output .= '</h3>';
		if($team_position == 1){
			$post_output .= '<span class="meta-data">'.$position.'</span>';
		}
		if($team_social == 1){
			$post_output .= '<div class="social-icons-list">'.$social.'</div>';
		}
		if($team_excerpt == 1){
			$post_output .= '<div class="team-item-excerpt">'.tentered_excerpt($team_excerpt_number).'</div>';
		}
		if($team_more == 1){
			$post_output .= '<a href="'.get_permalink().'" class="basic-link">'.$team_more_text.'</a>';
		}
		$post_output .= '</div>
				</div>
			</div>';
	}
	
	// Grid View
	else
	
	
	{
		$post_output .= '<li class="col-md-'.$team_grid_column.' col-sm-6 grid-item team-grid-item format-standard"><div class="team-item">';
	
		if(has_post_thumbnail())
		{
			$post_output .= '<div class="team-image">'.$thumbnail.'';
		} else {
			$post_output .= '<div class="team-image"><img src="' . vc_asset_url( 'vc/no_image.png' ) . '" alt="" width="400" height="400">';
		}
		if($team_social == 1){
			$post_output .= '<div class="team-overlay"><div class="team-overlay-bg"></div> <div class="team-info"> <div class="social-icon">'.$social.'</div></div></div>';
		}
		$post_output .= '</div><h4 class="team-name">';
		if($team_permalink == 1){
			$post_output .= '<a href="'.get_permalink().'">';
		}
		$post_output .= get_the_title();
		if($team_permalink == 1){
			$post_output .= '</a>';
		}
		$post_output .= '</h4>';
		if($team_position == 1){
			$post_output .= '<div class="team-position">'.$position.'</div>';
		}
		$post_output .= '</div></li>';
	}
	endwhile; endif; wp_reset_postdata();
	if($team_view=="carousel")
	{
		$post_output .= '</ul></div>';
	}
	elseif($team_view=="list")
	{
		$post_output .= '</div>';
	}
	else
	{
		$post_output .= '</ul>';
	}
	
	if($team_view!="list")
	{
		$post_output .= '</div>';
	}
	$post_output .= '</div>';

	global $tentered_allowed_tags;
	echo wp_kses($post_output, $tentered_allowed_tags);
	if($team_pagination == 1){
		$post_output .= '<div class="margin-10"></div>';
		$GLOBALS['wp_query'] = $post_list;
		$post_output .= tentered_pagination();
 		wp_reset_query();
	}
?>