<?php
/*Front end view of featured block shortcode
==================================*/

$a_href = $a_title = $a_target = $a_rel = $fblock_link = $fblock_style = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

// Enqueue needed icon font.
vc_icon_element_fonts_enqueue( $type );

$iconClass = isset( ${'icon_' . $type} ) ? esc_attr( ${'icon_' . $type} ) : '';

$link = ( '||' === $fblock_link ) ? '' : $fblock_link;
$link = vc_build_link( $link );
$use_link = false;
if ( strlen( $link['url'] ) > 0 ) {
	$use_link = true;
	$a_href = $link['url'];
	$a_title = $link['title'];
	$a_target = $link['target'];
	$a_rel = $link['rel'];
}
if ( $use_link ) {
	$attributes[] = 'href="' . trim( $a_href ) . '"';
	$attributes[] = 'title="' . esc_attr( trim( $a_title ) ) . '"';
	if ( ! empty( $a_target ) ) {
		$attributes[] = 'target="' . esc_attr( trim( $a_target ) ) . '"';
	}
	if ( ! empty( $a_rel ) ) {
		$attributes[] = 'rel="' . esc_attr( trim( $a_rel ) ) . '"';
	}
	$attributes = implode( ' ', $attributes );
}

// Icon Classes
$icon_classes = array();
$icon_class = '';
if( !empty( $ibox_icon_color ) && $ibox_icon_color != 'custom' ) {
	$icon_classes[] = ' '.esc_attr($ibox_icon_color);
}
if( !empty( $icon_classes ) ) {
	$icon_class = join(' ', $icon_classes);
}
// Icon Styles
$icon_style = '';
$icon_styles = array();
if( !empty( $fblock_icon_size ) ) {
	$icon_styles[] = 'font-size:' . esc_attr( $fblock_icon_size );
}
if( $fblock_icon_color == 'custom' && !empty( $fblock_icon_color_custom ) ) {
	$icon_styles[] = 'color:' . esc_attr( $fblock_icon_color_custom );
}
if( $fblock_icon_color == 'custom' && !empty( $fblock_icon_color_custom ) ) {
	$icon_styles[] = 'border-color:' . esc_attr( $fblock_icon_color_custom );
}
if( !empty( $icon_styles ) ) {
	$icon_style = ' style="'. implode( ';', $icon_styles ) .'"';
}

// Icon BG Classes
$icon_bg_classes = array();
$icon_bg_class = '';
if( !empty( $ibox_icon_bg_color ) && $ibox_icon_bg_color != 'custom' ) {
	$icon_bg_classes[] = ' '.esc_attr($ibox_icon_bg_color);
}
if( !empty( $icon_bg_classes ) ) {
	$icon_bg_class = join(' ', $icon_bg_classes);
}
// Icon BG Styles
$icon_bg_style = '';
$icon_bg_styles = array();
if( $fblock_icon_bg_color == 'custom' && !empty( $fblock_icon_bg_color_custom ) ) {
	$icon_bg_styles[] = 'background-color:' . esc_attr( $fblock_icon_bg_color_custom );
}
if( !empty( $icon_bg_styles ) ) {
	$icon_bg_style = ' style="'. implode( ';', $icon_bg_styles ) .'"';
}

//Title Classes
$title_classes = array();
$title_class = '';
if( !empty( $fblock_title_color ) && $fblock_title_color != 'custom' ) {
	$title_classes[] = ' '.esc_attr($fblock_title_color);
}
if( !empty( $title_classes ) ) {
	$title_class = join(' ', $title_classes);
}
// Title Styles
$title_style = '';
$title_styles = array();
if( !empty( $fblock_title_size ) ) {
	$title_styles[] = 'font-size:' . esc_attr( $fblock_title_size );
}
if( $fblock_title_color == 'custom' && !empty( $fblock_title_color_custom ) ) {
	$title_styles[] = 'color:' . esc_attr( $fblock_title_color_custom );
}
if( !empty( $title_styles ) ) {
	$title_style = ' style="'. implode( ';', $title_styles ) .'"';
}

// Description Classes
$desc_classes = array();
$desc_class = '';
if( !empty( $fblock_desc_color ) && $fblock_desc_color != 'custom' ) {
	$desc_classes[] = ' '.esc_attr($fblock_desc_color);
}
if( !empty( $desc_classes ) ) {
	$desc_class = join(' ', $desc_classes);
}
// Description Styles
$desc_style = '';
$desc_styles = array();
if( !empty( $fblock_desc_size ) ) {
	$desc_styles[] = 'font-size:' . esc_attr( $fblock_desc_size );
}
if( $fblock_desc_color == 'custom' && !empty( $fblock_desc_color_custom ) ) {
	$desc_styles[] = 'color:' . $fblock_desc_color_custom;
}
if( !empty( $desc_styles ) ) {
	$desc_style = ' style="'. implode( ';', $desc_styles ) .'"';
}

	$output = '<div class="features '.$fblock_style.'" style="background:'.$fblock_bg_color.' '.esc_attr( $css_class ).'">';
		if ( $use_link ) {
			$output .= '<a '.$attributes.'>';
		}
		if($fblock_style=='fblock-style1') {
			$output .= '<span class="features-icon '.$icon_bg_class.'" '.$icon_bg_style.'>';
		}
		if($iconClass) {
			$output .= '<i class="fblock-icon '.$iconClass.$icon_class.'" '.$icon_style.'></i>';
		}	
		if($fblock_style=='fblock-style1') {
			$output .= '</span>';
		}
		$output .= '<h4 class="'.$title_class.'"'.$title_style.'>'.$fblock_title.'</h4>';
		if($fblock_link!='') {
			$output .= '</a>';
		}
		$output .= '<p class="'.$desc_class.'"'.$desc_style.'>'.$fblock_desc.'</p>';
		if ( $use_link ) {
			$output .= '<a '.$attributes.'><i class="fa fa-plus fa-lg"></i></a>';
		}
		$output .= '</div>';
		
		
	global $tentered_allowed_tags;
echo wp_kses($output, $tentered_allowed_tags);
?>