<?php

if ( function_exists( 'vc_set_default_editor_post_types' ) ) {
	vc_set_default_editor_post_types( array(
		'page',
		'post',
		'project',
		'team',
		'service',
		'testimonial',
	) );
}

add_action( 'vc_before_init', 'tentered_vc_set_as_theme' );

if( ! function_exists( 'tentered_vc_set_as_theme' ) ) {
	function tentered_vc_set_as_theme() {
		vc_set_as_theme( true );
	}
}

if ( is_admin() ) {
	if ( ! function_exists( 'tentered_vc_remove_teaser_metabox' ) ) {
		function tentered_vc_remove_teaser_metabox() {
			$post_types = get_post_types( '', 'names' );
			foreach ( $post_types as $post_type ) {
				remove_meta_box( 'vc_teaser', $post_type, 'side' );
			}
		}

		add_action( 'do_meta_boxes', 'tentered_vc_remove_teaser_metabox' );
	}
}

/* START THEME ELEMENTS */
if ( function_exists( 'vc_map' ) ) {
	add_action( 'init', 'tentered_vc_elements' );
}

if ( ! function_exists( 'tentered_vc_elements' ) ) {
	function tentered_vc_elements() {

		$projectterms = array();
		$servicesterms = array();
		$poststerms = array();
		$testimonialsterms = array();
		$teamterms = array();
		
		$project_cats = get_terms('project-category');
		if(!is_wp_error($project_cats))
		{
			foreach($project_cats as $project_cat)
			{ 
				$projectterms[] = array('value'=>$project_cat->term_id, 'label'=>$project_cat->name); 
			}
		}
		$service_cats = get_terms('service-category');
		if(!is_wp_error($service_cats))
		{
			foreach($service_cats as $service_cat)
			{ 
				$servicesterms[] = array('value'=>$service_cat->term_id, 'label'=>$service_cat->name); 
			}
		}
		$posts_cats = get_terms('category');
		if(!is_wp_error($posts_cats))
		{
			foreach($posts_cats as $posts_cat)
			{ 
				$poststerms[] = array('value'=>$posts_cat->term_id, 'label'=>$posts_cat->name); 
			}
		}
		$testimonials_cats = get_terms('testimonial-category');
		if(!is_wp_error($testimonials_cats))
		{
			foreach($testimonials_cats as $testimonials_cat)
			{ 
				$testimonialsterms[] = array('value'=>$testimonials_cat->term_id, 'label'=>$testimonials_cat->name); 
			}
		}
		$team_cats = get_terms('team-category');
		if(!is_wp_error($team_cats))
		{
			foreach($team_cats as $team_cat)
			{ 
				$teamterms[] = array('value'=>$team_cat->term_id, 'label'=>$team_cat->name); 
			}
		}
		/* Projects Grid/List Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Projects", "tentered" ),
			"base" => "tentered_project",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'View Style', 'tentered' ),
					'param_name' => 'project_view',
					'value' => array(esc_html__( 'Grid', 'tentered' ) => 'grid', esc_html__( 'Carousel', 'tentered' ) => 'carousel' ) ,
					'description' => esc_html__( 'Select view style for projects.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Column', 'tentered' ),
					'param_name' => 'project_grid_column',
					'value' => array( esc_html__( 'One Column', 'tentered' ) => 12, esc_html__( 'Two Columns', 'tentered' ) => 6, esc_html__( 'Three Columns', 'tentered' ) => 4, esc_html__( 'Four Columns', 'tentered' ) => 3, esc_html__( 'Six Columns', 'tentered' ) => 2) ,
					'description' => esc_html__( 'Select columns of grid/carousel.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Spaced items', 'tentered' ),
					'param_name' => 'project_spacing',
					'value' => array( esc_html__( 'Spaced', 'tentered' ) => 'spaced', esc_html__( 'No space', 'tentered' ) => 'non-spaced') ,
					'description' => esc_html__( 'Choose if you want to have space/gutter between portfolio items or now.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
					'dependency' => array(
						'element' => 'project_view',
						'value' => array( 'grid' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show project category filters?', 'tentered'),
					'param_name' => 'project_filters',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'project_view',
						'value' => array('grid'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Filters style', 'tentered' ),
					'param_name' => 'project_filters_style',
					'value' => array( esc_html__( 'Pills', 'tentered' ) => 'pills', esc_html__( 'Tabs', 'tentered' ) => 'tabs' ) ,
					'description' => esc_html__( 'Select style for the category filters.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
					'dependency' => array(
						'element' => 'project_filters',
						'value' => array( '1' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel next/prev arrows?', 'tentered'),
					'param_name' => 'project_carousel_arrows',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'project_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel pagination?', 'tentered'),
					'param_name' => 'project_carousel_pagi',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'project_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Auto Rotate?', 'tentered' ),
					'param_name' => 'project_carousel_rotate',
					'description' => esc_html__('If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.', 'tentered'),
					'std' => '',
					'dependency' => array(
						'element' => 'project_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show read more button?', 'tentered' ),
					'param_name' => 'project_more',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show zoom button?', 'tentered' ),
					'param_name' => 'project_zoom',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'autocomplete',
					'class' => '',
					'heading' => esc_html__( 'Project Categories', 'tentered' ),
					'param_name' => 'project_terms',
					'description' => esc_html__( 'Show projects by specific categories. Search and enter by typing category names.', 'tentered' ),
					'settings'		=> array( 'values' => $projectterms,'multiple' => true,
					'min_length' => 1,
					'groups' => true,
					// In UI show results grouped by groups, default false
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend, default false
					'display_inline' => true,
					// In UI show results inline view, default false (each value in own line)
					'delay' => 500,
					// delay for search. default 500
					'auto_focus' => true, ),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of projects', 'tentered' ),
					'param_name' => 'project_number',
					'value' => 4,
					'description' => esc_html__( 'Insert number of projects to show per page.', 'tentered' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'tentered' ),
					'param_name' => 'project_img_size',
					'value' => '600x400',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'tentered' ),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'tentered' ),
					'param_name' => 'project_pagination',
					'description' => esc_html__( 'Show pagination for Projects.', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'project_view',
						'value' => array( 'grid' ),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	/* Services Grid/List Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Services", "tentered" ),
			"base" => "tentered_services",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'View Style', 'tentered' ),
					'param_name' => 'services_view',
					'value' => array( esc_html__( 'List', 'tentered' ) => 'list', esc_html__( 'Grid', 'tentered' ) => 'grid', esc_html__( 'Carousel', 'tentered' ) => 'carousel' ) ,
					'description' => esc_html__( 'Select view style for services.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Column', 'tentered' ),
					'param_name' => 'services_grid_column',
					'value' => array( esc_html__( 'One Column', 'tentered' ) => 12, esc_html__( 'Two Columns', 'tentered' ) => 6, esc_html__( 'Three Columns', 'tentered' ) => 4, esc_html__( 'Four Columns', 'tentered' ) => 3) ,
					'description' => esc_html__( 'Select columns of grid/carousel.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
					'dependency' => array(
						'element' => 'services_view',
						'value' => array( 'grid','carousel' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel next/prev arrows?', 'tentered'),
					'param_name' => 'services_carousel_arrows',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'services_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel pagination?', 'tentered'),
					'param_name' => 'services_carousel_pagi',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'services_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Auto Rotate?', 'tentered' ),
					'param_name' => 'services_carousel_rotate',
					'description' => esc_html__('If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.', 'tentered'),
					'std' => '',
					'dependency' => array(
						'element' => 'services_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of words to show as excerpt', 'tentered' ),
					'param_name' => 'services_excerpt_number',
					'value' => 20,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show read more button?', 'tentered' ),
					'param_name' => 'services_more',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'services_view',
						'value' => array('list'),
					),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Read more button label', 'tentered' ),
					'param_name' => 'services_more_text',
					'value' => 'Read More',
					'dependency' => array(
						'element' => 'services_more',
						'value' => '1',
					),
				),
				array(
					'type' => 'autocomplete',
					'class' => '',
					'heading' => esc_html__( 'Service Categories', 'tentered' ),
					'param_name' => 'services_terms',
					'description' => esc_html__( 'Show services by specific categories. Search and enter by typing category names.', 'tentered' ),
					'settings'		=> array( 'values' => $servicesterms,'multiple' => true,
					'min_length' => 1,
					'groups' => true,
					// In UI show results grouped by groups, default false
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend, default false
					'display_inline' => true,
					// In UI show results inline view, default false (each value in own line)
					'delay' => 500,
					// delay for search. default 500
					'auto_focus' => true, ),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of Services', 'tentered' ),
					'param_name' => 'services_number',
					'value' => 4,
					'description' => esc_html__( 'Insert number of services to show per page.', 'tentered' )
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Show Thumbnail or Icon', 'tentered' ),
					'param_name' => 'services_thumb',
					'value' => array( esc_html__( 'Icon', 'tentered' ) => 'icon', esc_html__( 'Thumbnail', 'tentered' ) => 'thumbnail') ,
					'description' => esc_html__( 'Select thumbnail or icon view for services.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'tentered' ),
					'param_name' => 'services_img_size',
					'value' => '450x400',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'tentered' ),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Link Image/Icon block to single service page?', 'tentered' ),
					'param_name' => 'services_linked',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'tentered' ),
					'param_name' => 'services_pagination',
					'description' => esc_html__( 'Show pagination for services.', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'services_view',
						'value' => array( 'grid','list' ),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	/* Posts Grid/List Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Posts", "tentered" ),
			"base" => "tentered_posts",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'View Style', 'tentered' ),
					'param_name' => 'posts_view',
					'value' => array( esc_html__( 'Medium Thumbnails', 'tentered' ) => 'medium',esc_html__( 'Full Width', 'tentered' ) => 'full', esc_html__( 'Grid', 'tentered' ) => 'grid', esc_html__( 'Carousel', 'tentered' ) => 'carousel' ) ,
					'description' => esc_html__( 'Select view style for posts.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Column', 'tentered' ),
					'param_name' => 'posts_grid_column',
					'value' => array( esc_html__( 'One Column', 'tentered' ) => 12, esc_html__( 'Two Columns', 'tentered' ) => 6, esc_html__( 'Three Columns', 'tentered' ) => 4, esc_html__( 'Four Columns', 'tentered' ) => 3) ,
					'description' => esc_html__( 'Select columns of grid/carousel.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array( 'grid','carousel' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel next/prev arrows?', 'tentered'),
					'param_name' => 'posts_carousel_arrows',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel pagination?', 'tentered'),
					'param_name' => 'posts_carousel_pagi',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Auto Rotate?', 'tentered' ),
					'param_name' => 'posts_carousel_rotate',
					'description' => esc_html__('If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.', 'tentered'),
					'std' => '',
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post media?', 'tentered' ),
					'param_name' => 'posts_media_show',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post featured image only', 'tentered' ),
					'description' => esc_html__( 'Check to show only featured image instead of different media content.', 'tentered' ),
					'param_name' => 'posts_media_image_only',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'posts_media_show',
						'value' => array( '1' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post date?', 'tentered' ),
					'param_name' => 'posts_date',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post author name?', 'tentered' ),
					'param_name' => 'posts_author',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post categories?', 'tentered' ),
					'param_name' => 'posts_categories',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show post comments number?', 'tentered' ),
					'param_name' => 'posts_comments',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Excerpt?', 'tentered' ),
					'param_name' => 'posts_excerpt',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of words to show as excerpt', 'tentered' ),
					'param_name' => 'posts_excerpt_number',
					'value' => 30,
					'dependency' => array(
						'element' => 'posts_excerpt',
						'value' => '1',
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show read more button?', 'tentered' ),
					'param_name' => 'posts_more',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Read more button label', 'tentered' ),
					'param_name' => 'posts_more_text',
					'value' => 'Read More',
					'dependency' => array(
						'element' => 'posts_more',
						'value' => '1',
					),
				),
				array(
					'type' => 'autocomplete',
					'class' => '',
					'heading' => esc_html__( 'Posts Categories', 'tentered' ),
					'param_name' => 'posts_terms',
					'description' => esc_html__( 'Show posts by specific categories. Search and enter by typing category names.', 'tentered' ),
					'settings'		=> array( 'values' => $poststerms,'multiple' => true,
					'min_length' => 1,
					'groups' => true,
					// In UI show results grouped by groups, default false
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend, default false
					'display_inline' => true,
					// In UI show results inline view, default false (each value in own line)
					'delay' => 500,
					// delay for search. default 500
					'auto_focus' => true, ),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of Posts', 'tentered' ),
					'param_name' => 'posts_number',
					'value' => 4,
					'description' => esc_html__( 'Insert number of posts to show per page.', 'tentered' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'tentered' ),
					'param_name' => 'posts_img_size',
					'value' => '600x400',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size. This works for only standard or Image format posts.', 'tentered' ),
					'dependency' => array(
						'element' => 'posts_media_show',
						'value' => array( '1' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'tentered' ),
					'param_name' => 'posts_pagination',
					'description' => esc_html__( 'Show pagination for posts.', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array( 'grid','medium','full' ),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'No border around content', 'tentered' ),
					'param_name' => 'tentered_style',
					'group'      => esc_html__( 'Style', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'posts_view',
						'value' => array( 'grid','carousel' ),
					),
				),
			)
		) 
	);
	
	
	/* Testimonial Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Testimonials", "tentered" ),
			"base" => "tentered_testimonials",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'View Style', 'tentered' ),
					'param_name' => 'testimonials_view',
					'value' => array( esc_html__( 'Grid', 'tentered' ) => 'grid', esc_html__( 'Carousel', 'tentered' ) => 'carousel' ) ,
					'description' => esc_html__( 'Select view style for testimonials.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Column', 'tentered' ),
					'param_name' => 'testimonials_grid_column',
					'value' => array( esc_html__( 'One Column', 'tentered' ) => 12, esc_html__( 'Two Columns', 'tentered' ) => 6, esc_html__( 'Three Columns', 'tentered' ) => 4, esc_html__( 'Four Columns', 'tentered' ) => 3) ,
					'description' => esc_html__( 'Select columns of grid/carousel.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Center Aligned?', 'tentered' ),
					'param_name' => 'testimonials_center',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => 'text-align-center', esc_html__( 'No', 'tentered' ) => 'text-align-left') ,
					'description' => esc_html__( 'Select testimonials alignment.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Skin/Style', 'tentered' ),
					'param_name' => 'testimonials_skin',
					'value' => array( esc_html__( 'Dark', 'tentered' ) => 'testimonials-default', esc_html__( 'Light', 'tentered' ) => 'testimonial-alt color-text') ,
					'description' => esc_html__( 'Select testimonials style. Use dark when showing on a plain light color like white background. Choose light when using over an image/parallax.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel next/prev arrows?', 'tentered'),
					'param_name' => 'testimonials_carousel_arrows',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'testimonials_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel pagination?', 'tentered'),
					'param_name' => 'testimonials_carousel_pagi',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'testimonials_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Auto Rotate?', 'tentered' ),
					'param_name' => 'testimonials_carousel_rotate',
					'description' => esc_html__('If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.', 'tentered'),
					'std' => '',
					'dependency' => array(
						'element' => 'testimonials_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show testimonial author photo?', 'tentered' ),
					'param_name' => 'testimonials_photo',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show testimonial author title?', 'tentered' ),
					'param_name' => 'testimonials_author',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show testimonial sub title?', 'tentered' ),
					'param_name' => 'testimonials_subtitle',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'autocomplete',
					'class' => '',
					'heading' => esc_html__( 'Testimonial Categories', 'tentered' ),
					'param_name' => 'testimonials_terms',
					'description' => esc_html__( 'Show testimonials by specific categories. Search and enter by typing category names.', 'tentered' ),
					'settings'		=> array( 'values' => $testimonialsterms,'multiple' => true,
					'min_length' => 1,
					'groups' => true,
					// In UI show results grouped by groups, default false
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend, default false
					'display_inline' => true,
					// In UI show results inline view, default false (each value in own line)
					'delay' => 500,
					// delay for search. default 500
					'auto_focus' => true, ),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of Testimonials', 'tentered' ),
					'param_name' => 'testimonials_number',
					'value' => 4,
					'description' => esc_html__( 'Insert number of testimonials to show per page.', 'tentered' )
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'tentered' ),
					'param_name' => 'testimonials_pagination',
					'description' => esc_html__( 'Show pagination for tesimonials.', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'testimonials_view',
						'value' => array( 'grid' ),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	/* Team Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Team", "tentered" ),
			"base" => "tentered_team",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'View Style', 'tentered' ),
					'param_name' => 'team_view',
					'value' => array( esc_html__( 'List', 'tentered' ) => 'list', esc_html__( 'Grid', 'tentered' ) => 'grid', esc_html__( 'Carousel', 'tentered' ) => 'carousel' ) ,
					'description' => esc_html__( 'Select view style for team.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Grid Column', 'tentered' ),
					'param_name' => 'team_grid_column',
					'value' => array( esc_html__( 'One Column', 'tentered' ) => 12, esc_html__( 'Two Columns', 'tentered' ) => 6, esc_html__( 'Three Columns', 'tentered' ) => 4, esc_html__( 'Four Columns', 'tentered' ) => 3, esc_html__( 'Six Columns', 'tentered' ) => 2) ,
					'description' => esc_html__( 'Select columns of grid/carousel.', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
					'dependency' => array(
						'element' => 'team_view',
						'value' => array( 'grid','carousel' ),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel next/prev arrows?', 'tentered'),
					'param_name' => 'team_carousel_arrows',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'team_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__('Show carousel pagination?', 'tentered'),
					'param_name' => 'team_carousel_pagi',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
					'dependency' => array(
						'element' => 'team_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__('Auto Rotate?', 'tentered' ),
					'param_name' => 'team_carousel_rotate',
					'description' => esc_html__('If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.', 'tentered'),
					'std' => '',
					'dependency' => array(
						'element' => 'team_view',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show team member position?', 'tentered' ),
					'param_name' => 'team_position',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show team member contact/social links?', 'tentered' ),
					'param_name' => 'team_social',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Excerpt?', 'tentered' ),
					'param_name' => 'team_excerpt',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'team_view',
						'value' => array('list'),
					),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of words to show as excerpt', 'tentered' ),
					'param_name' => 'team_excerpt_number',
					'value' => 60,
					'dependency' => array(
						'element' => 'team_excerpt',
						'value' => '1',
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show read more button?', 'tentered' ),
					'param_name' => 'team_more',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
					'dependency' => array(
						'element' => 'team_view',
						'value' => array('list'),
					),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Read more button label', 'tentered' ),
					'param_name' => 'team_more_text',
					'value' => 'Read More',
					'dependency' => array(
						'element' => 'team_more',
						'value' => '1',
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Link team member name to details page?', 'tentered' ),
					'param_name' => 'team_permalink',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'tentered' ),
					'param_name' => 'team_img_size',
					'value' => '400x400',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'tentered' ),
				),
				array(
					'type' => 'autocomplete',
					'class' => '',
					'heading' => esc_html__( 'Team Categories', 'tentered' ),
					'param_name' => 'team_terms',
					'description' => esc_html__( 'Show team by specific categories. Search and enter by typing category names.', 'tentered' ),
					'settings'		=> array( 'values' => $teamterms,'multiple' => true,
					'min_length' => 1,
					'groups' => true,
					// In UI show results grouped by groups, default false
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend, default false
					'display_inline' => true,
					// In UI show results inline view, default false (each value in own line)
					'delay' => 500,
					// delay for search. default 500
					'auto_focus' => true, ),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Number of Team members', 'tentered' ),
					'param_name' => 'team_number',
					'value' => 4,
					'description' => esc_html__( 'Insert number of team to show per page.', 'tentered' )
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'tentered' ),
					'param_name' => 'team_pagination',
					'description' => esc_html__( 'Show pagination. This will work on an individual team page not on homepage.', 'tentered' ),
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'dependency' => array(
						'element' => 'team_view',
						'value' => array( 'grid','list' ),
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	/* Icon Box Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Icon Box", "tentered" ),
			"base" => "tentered_ibox",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => __( 'Icon library', 'tentered' ),
					'value' => array(
						__( 'Font Awesome', 'tentered' ) => 'fontawesome',
						__( 'Open Iconic', 'tentered' ) => 'openiconic',
						__( 'Typicons', 'tentered' ) => 'typicons',
						__( 'Entypo', 'tentered' ) => 'entypo',
						__( 'Linecons', 'tentered' ) => 'linecons',
						__( 'Mono Social', 'tentered' ) => 'monosocial',
						__( 'Material', 'tentered' ) => 'material',
					),
					'admin_label' => true,
					'param_name' => 'type',
					'description' => __( 'Select icon library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'fontawesome',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'openiconic',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'typicons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'linecons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_monosocial',
					'value' => 'vc-mono vc-mono-fivehundredpx',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'monosocial',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'monosocial',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_material',
					'value' => 'vc-material vc-material-cake',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'material',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'material',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon - Size', 'tentered' ),
					'param_name' => 'ibox_icon_size',
					'value' => array( esc_html__( '16px', 'tentered' ) => '16px', esc_html__( '32px', 'tentered' ) => '32px', esc_html__( '48px', 'tentered' ) => '48px', esc_html__( '64px', 'tentered' ) => '64px') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => '32px'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Color', 'tentered' ),
					'param_name' => 'ibox_icon_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Icon - Color Custom', 'tentered' ),
					'param_name' => 'ibox_icon_color_custom',
					'dependency' => array('element' => 'ibox_icon_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'ibox_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title - Font Size (px)', 'tentered' ),
					'param_name' => 'ibox_title_size',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Title - Color', 'tentered' ),
					'param_name' => 'ibox_title_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Title - Color Custom', 'tentered' ),
					'param_name' => 'ibox_title_color_custom',
					'dependency' => array('element' => 'ibox_title_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Description', 'tentered' ),
					'param_name' => 'ibox_desc',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Description - Font Size (px)', 'tentered' ),
					'param_name' => 'ibox_desc_size',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Description - Color', 'tentered' ),
					'param_name' => 'ibox_desc_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Description - Color Custom', 'tentered' ),
					'param_name' => 'ibox_desc_color_custom',
					'dependency' => array('element' => 'ibox_desc_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'vc_link',
					'heading'    => esc_html__( 'Link', 'tentered' ),
					'param_name' => 'ibox_link',
					'description' => esc_html__( 'Enter/Select URL that will be added to Icon and Title.', 'tentered' )
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Center Align?', 'tentered' ),
					'param_name' => 'ibox_calign',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Hover Effect?', 'tentered' ),
					'param_name' => 'ibox_hover',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 1,
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Outline or Border', 'tentered' ),
					'param_name' => 'ibox_border',
					'value' => array( esc_html__( 'Outline', 'tentered' ) => 'ibox-outline', esc_html__( 'Border', 'tentered' ) => 'ibox-border') ,
					'description' => esc_html__( 'Outline comes with background plus border', 'tentered' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon box shape', 'tentered' ),
					'param_name' => 'ibox_shape',
					'value' => array( esc_html__( 'Circle', 'tentered' ) => '', esc_html__( 'Rounded', 'tentered' ) => 'ibox-rounded', esc_html__( 'Plain', 'tentered' ) => 'ibox-plain') ,
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon Box Theme', 'tentered' ),
					'param_name' => 'ibox_theme',
					'value' => array( esc_html__( 'Dark', 'tentered' ) => 'ibox-dark', esc_html__( 'Light', 'tentered' ) => 'ibox-light', esc_html__( 'Theme Primary Color', 'tentered' ) => 'ibox-primary') ,
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	
	/* Featured Block Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Featured Block", "tentered" ),
			"base" => "tentered_fblock",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Featured Block Style', 'tentered' ),
					'param_name' => 'fblock_style',
					'value' => array( esc_html__( 'Style1', 'tentered' ) => 'fblock-style1', esc_html__( 'Style2', 'tentered' ) => 'fblock-style2') ,
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Icon library', 'tentered' ),
					'value' => array(
						__( 'Font Awesome', 'tentered' ) => 'fontawesome',
						__( 'Open Iconic', 'tentered' ) => 'openiconic',
						__( 'Typicons', 'tentered' ) => 'typicons',
						__( 'Entypo', 'tentered' ) => 'entypo',
						__( 'Linecons', 'tentered' ) => 'linecons',
						__( 'Mono Social', 'tentered' ) => 'monosocial',
						__( 'Material', 'tentered' ) => 'material',
					),
					'admin_label' => true,
					'param_name' => 'type',
					'description' => __( 'Select icon library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'fontawesome',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'openiconic',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'typicons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'linecons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_monosocial',
					'value' => 'vc-mono vc-mono-fivehundredpx',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'monosocial',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'monosocial',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_material',
					'value' => 'vc-material vc-material-cake',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => false,
						// default true, display an "EMPTY" icon?
						'type' => 'material',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'material',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon Size', 'tentered' ),
					'param_name' => 'fblock_icon_size',
					'value' => array( esc_html__( '16px', 'tentered' ) => '16px', esc_html__( '32px', 'tentered' ) => '32px', esc_html__( '48px', 'tentered' ) => '48px', esc_html__( '64px', 'tentered' ) => '64px') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => '32px'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Color', 'tentered' ),
					'param_name' => 'fblock_icon_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Icon - Color Custom', 'tentered' ),
					'param_name' => 'fblock_icon_color_custom',
					'dependency' => array('element' => 'fblock_icon_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Background Color', 'tentered' ),
					'param_name' => 'fblock_icon_bg_color',
					'value'      => array(
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-bg',
						esc_html__( 'Custom', 'tentered' ) => 'custom',
					),
					'dependency' => array(
						'element' => 'fblock_style',
						'value' => 'fblock-style1',
					),
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Icon - Background Color Custom', 'tentered' ),
					'param_name' => 'fblock_icon_bg_color_custom',
					'dependency' => array('element' => 'fblock_icon_bg_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'fblock_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title Font Size (px)', 'tentered' ),
					'param_name' => 'fblock_title_size',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Title - Color', 'tentered' ),
					'param_name' => 'fblock_title_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Title - Color Custom', 'tentered' ),
					'param_name' => 'fblock_title_color_custom',
					'dependency' => array('element' => 'fblock_title_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Description', 'tentered' ),
					'param_name' => 'fblock_desc',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Description Font Size (px)', 'tentered' ),
					'param_name' => 'fblock_desc_size',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Description - Color', 'tentered' ),
					'param_name' => 'fblock_desc_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color',
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Description - Color Custom', 'tentered' ),
					'param_name' => 'fblock_desc_color_custom',
					'dependency' => array('element' => 'fblock_desc_color', 'value' => 'custom'),
					'weight'     => 1
				),
				array(
					'type'       => 'vc_link',
					'heading'    => esc_html__( 'Link', 'tentered' ),
					'param_name' => 'fblock_link',
					'description' => esc_html__( 'Enter/Select URL that will be added to Icon and Title.', 'tentered' )
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Background Color', 'tentered' ),
					'param_name' => 'fblock_bg_color',
					'weight'     => 1
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	
	/* Progress Bar Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Progress Bar", "tentered" ),
			"base" => "tentered_pbar",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'pbar_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Percentage (add %)', 'tentered' ),
					'param_name' => 'pbar_perc',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Animation delay (Milliseconds)', 'tentered' ),
					'param_name' => 'pbar_animation',
					'value'      => '100',
					'weight'     => 1
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Progress bar color', 'tentered' ),
					'param_name' => 'pbar_style',
					'value' => array( esc_html__( 'Primary Color', 'tentered' ) => 'primary', esc_html__( 'Orange', 'tentered' ) => 'warning', esc_html__( 'Green', 'tentered' ) => 'success', esc_html__( 'Red', 'tentered' ) => 'danger', esc_html__( 'Blue', 'tentered' ) => 'info') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => 'primary'
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Progress bar style', 'tentered' ),
					'param_name' => 'pbar_striped',
					'value' => array( esc_html__( 'Striped', 'tentered' ) => 'progress-striped', esc_html__( 'Non striped', 'tentered' ) => 'no-progress-striped') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => '32px'
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	
	/* Round Progress Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Round Progress", "tentered" ),
			"base" => "tentered_rprogress",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'rprogress_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Percentage (DO NOT ADD %)', 'tentered' ),
					'param_name' => 'rprogress_perc',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Round color', 'tentered' ),
					'param_name' => 'rprogress_color',
					'weight'     => 1
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Thickness', 'tentered' ),
					'param_name' => 'rprogress_thickness',
					'value' => array( esc_html__( '.1', 'tentered' ) => '.1', esc_html__( '.2', 'tentered' ) => '.2', esc_html__( '.3', 'tentered' ) => '.3', esc_html__( '.4', 'tentered' ) => '.4', esc_html__( '.5', 'tentered' ) => '.5') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => '.2'
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		) 
	);
	
	
	/* Number Counter Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Number Counter", "tentered" ),
			"base" => "tentered_counter",
			"category" => esc_html__( "Tentered", "tentered"),
			"class" => "",
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => __( 'Icon library', 'tentered' ),
					'value' => array(
						__( 'Font Awesome', 'tentered' ) => 'fontawesome',
						__( 'Open Iconic', 'tentered' ) => 'openiconic',
						__( 'Typicons', 'tentered' ) => 'typicons',
						__( 'Entypo', 'tentered' ) => 'entypo',
						__( 'Linecons', 'tentered' ) => 'linecons',
						__( 'Mono Social', 'tentered' ) => 'monosocial',
						__( 'Material', 'tentered' ) => 'material',
					),
					'admin_label' => true,
					'param_name' => 'type',
					'description' => __( 'Select icon library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'fontawesome',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'openiconic',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'openiconic',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'typicons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'typicons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'entypo',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'entypo',
					),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'linecons',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'linecons',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_monosocial',
					'value' => 'vc-mono vc-mono-fivehundredpx',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'monosocial',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'monosocial',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'tentered' ),
					'param_name' => 'icon_material',
					'value' => 'vc-material vc-material-cake',
					// default value to backend editor admin_label
					'settings' => array(
						'emptyIcon' => true,
						// default true, display an "EMPTY" icon?
						'type' => 'material',
						'iconsPerPage' => 4000,
						// default 100, how many icons per/page to display
					),
					'dependency' => array(
						'element' => 'type',
						'value' => 'material',
					),
					'description' => __( 'Select icon from library.', 'tentered' ),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Color', 'tentered' ),
					'param_name' => 'counter_icon_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color'
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Icon - Color Custom', 'tentered' ),
					'param_name' => 'counter_icon_color_custom',
					'dependency' => array('element' => 'counter_icon_color', 'value' => 'custom')
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Icon - Font size', 'tentered' ),
					'param_name' => 'counter_icon_font',
					'value' => '55px',
					'description' => esc_html__( 'Enter icon size in px', 'tentered' )
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Hide Icon Background?', 'tentered' ),
					'param_name' => 'counter_icon_bg_hide',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'std' => 0,
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'counter_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Title - Color', 'tentered' ),
					'param_name' => 'counter_title_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color'
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Title - Color Custom', 'tentered' ),
					'param_name' => 'counter_title_color_custom',
					'dependency' => array('element' => 'counter_title_color', 'value' => 'custom')
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title - Font size', 'tentered' ),
					'param_name' => 'counter_title_font',
					'value' => '15px',
					'weight' => 1,
					'description' => esc_html__( 'Enter icon size in px', 'tentered' )
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Number to count', 'tentered' ),
					'param_name' => 'counter_number',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Text next to number', 'tentered' ),
					'param_name' => 'counter_number_text',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Number - Color', 'tentered' ),
					'param_name' => 'counter_number_color',
					'value'      => array(
						esc_html__( 'Custom', 'tentered' ) => 'custom',
						esc_html__( 'Theme primary color', 'tentered' ) => 'accent-color'
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Number - Color Custom', 'tentered' ),
					'param_name' => 'counter_number_color_custom',
					'dependency' => array('element' => 'counter_number_color', 'value' => 'custom')
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Number - Font size', 'tentered' ),
					'param_name' => 'counter_number_font',
					'value' => '30px',
					'weight' => 1,
					'description' => esc_html__( 'Enter icon size in px', 'tentered' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Align', 'tentered' ),
					'param_name' => 'counter_align',
					'value'      => array(
						esc_html__( 'Center', 'tentered' ) => 'text-align-center',
						esc_html__( 'Left', 'tentered' ) => 'text-align-left',
						esc_html__( 'Right', 'tentered' ) => 'text-align-right'
					)
				),
			)
		) 
	);
	
	/* Pricing Table Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Pricing Table", "tentered" ),
			"base" => "tentered_pricing",
			'as_parent' => array( 'only' => 'tentered_pricing_item' ),
			'show_settings_on_create' => true,
			"category" => esc_html__( "Tentered", "tentered"),
			"params" => array(
				array(
					'type' 					=> 'dropdown',
					'heading' 				=> esc_html__( 'Columns', 'tentered' ),
					'param_name' 			=> 'pricing_columns',
					'value' 					=> array( esc_html__( '1', 'tentered' ) => 'one-cols', esc_html__( '2', 'tentered' ) => 'two-cols', esc_html__( '3', 'tentered' ) => 'three-cols', esc_html__( '4', 'tentered' ) => 'four-cols', esc_html__( '5', 'tentered' ) => 'five-cols', esc_html__( '6', 'tentered' ) => 'six-cols') ,
					'param_holder_class' 	=> 'vc_colored-dropdown',
					'std' 					=> 'three-cols'
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				)
			),
			'js_view'                 => 'VcColumnView'
		) 
	);
	/* Pricing Table Column Shortcode
		=====================================================*/
		vc_map( array(
			'name'     => esc_html__( 'Pricing Column', 'tentered' ),
			'base'     => 'tentered_pricing_item',
			'as_child' => array( 'only' => 'tentered_pricing' ),
			'category' => esc_html__( 'Tentered', 'tentered' ),
			'params'   => array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'pricing_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Popular Plan?', 'tentered' ),
					'param_name' => 'pricing_popular',
					'value' => array( esc_html__( 'Yes', 'tentered' ) => true ),
					'description' => esc_html__( 'Check to highlight this plan among others. You should check this only for a plan to keep your pricing table in good looks.', 'tentered' ),
					'std' => 0,
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Popular reason', 'tentered' ),
					'param_name' => 'pricing_popular_reason',
					'description' => esc_html__( 'Enter couple of words to show why this plan is popular. Example: Big savings.', 'tentered' ),
					'value'      => '',
					'weight'     => 1,
					'dependency' => array(
						'element' => 'pricing_popular',
						'value' => '1',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Price', 'tentered' ),
					'param_name' => 'pricing_price',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Currency', 'tentered' ),
					'param_name' => 'pricing_currency',
					'value'      => '$',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Price Term', 'tentered' ),
					'description' => esc_html__( 'Enter term for the price of the plan. Example: Per Month.', 'tentered' ),
					'param_name' => 'pricing_term',
					'value'      => esc_html__( 'Per Month', 'tentered' ),
					'weight'     => 1
				),
				array(
					'type' => 'param_group',
					'heading' => esc_html__( 'Features', 'tentered' ),
					'group'      => esc_html__( 'Features', 'tentered' ),
					'param_name' => 'pricing_features',
					'value' => urlencode( json_encode( array(
						array(
							'title' => esc_html__( 'This is included', 'tentered' ),
						),
						array(
							'title' => esc_html__( 'And this too', 'tentered' ),
						),
					) ) ),
					'params' => array(
						array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Feature', 'tentered' ),
							'param_name' => 'title',
							'description' => esc_html__( 'Enter features of the pricing plan.', 'tentered' ),
							'admin_label' => true,
						),
					),
					'callbacks' => array(
						'after_add' => 'vcChartParamAfterAddCallback',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Button Label', 'tentered' ),
					'param_name' => 'pricing_button',
					'value'      => esc_html__( 'Sign Up Now!', 'tentered' ),
					'group'      => esc_html__( 'Button', 'tentered' ),
					'weight'     => 1
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Button Color', 'tentered' ),
					'group'      => esc_html__( 'Button', 'tentered' ),
					'param_name' => 'pricing_button_color',
					'value' => array( esc_html__( 'Primary Color', 'tentered' ) => 'primary', esc_html__( 'Orange', 'tentered' ) => 'warning', esc_html__( 'Green', 'tentered' ) => 'success', esc_html__( 'Red', 'tentered' ) => 'danger', esc_html__( 'Blue', 'tentered' ) => 'info') ,
					'param_holder_class' => 'vc_colored-dropdown',
					'std' => 'primary'
				),
				array(
					'type'       => 'vc_link',
					'heading'    => esc_html__( 'Link', 'tentered' ),
					'group'      => esc_html__( 'Button', 'tentered' ),
					'param_name' => 'pricing_button_link',
					'description' => esc_html__( 'Enter/Select URL for the button.', 'tentered' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				),
			)
		)
	);
		
		
	/* Timeline Shortcode
		=====================================================*/
		vc_map( array(
			"name" => esc_html__( "Timeline", "tentered" ),
			"base" => "tentered_timeline",
			'as_parent' => array( 'only' => 'tentered_timeline_item' ),
			'show_settings_on_create' => false,
			"category" => esc_html__( "Tentered", "tentered"),
			"params" => array(
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'tentered' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'tentered' )
				)
			),
			'js_view'                 => 'VcColumnView'
		) 
	);
	/* Timeline Item Shortcode
		=====================================================*/
		vc_map( array(
			'name'     => esc_html__( 'Timeline Item', 'tentered' ),
			'base'     => 'tentered_timeline_item',
			'as_child' => array( 'only' => 'tentered_timeline' ),
			'category' => esc_html__( 'Tentered', 'tentered' ),
			'params'   => array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Year/Month/Date', 'tentered' ),
					'param_name' => 'timeline_date',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'tentered' ),
					'param_name' => 'timeline_title',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Content', 'tentered' ),
					'param_name' => 'timeline_content',
					'value'      => '',
					'weight'     => 1
				),
			)
		)
	);
	
	
	
	}
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Tentered_Pricing extends WPBakeryShortCodesContainer {
	}
	class WPBakeryShortCode_Tentered_Timeline extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Tentered_Pricing_Item extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Timeline_Item extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Project extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Services extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Posts extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Testimonials extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Team extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Ibox extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Fblock extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Pbar extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Counter extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_Tentered_Rprogress extends WPBakeryShortCode {
	}
}