<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
/*
 *
 * 	tentered Theme Functions
 * 	------------------------------------------------
 * 	tentered Framework v1.0
 * 	Copyright tentered  2016 - http://www.imithemes.com/
 *	
 */
/* MAINTENANCE MODE
  ================================================== */
if (!function_exists('tentered_maintenance_mode')) {
    function tentered_maintenance_mode() {
        $options = get_option('tentered_options');
        $custom_logo = $custom_logo_output = $maintenance_mode = "";
        if ((isset($options['custom_admin_login_logo']))&&(isset($options['custom_admin_login_logo']['url']))) {
            $custom_logo = $options['custom_admin_login_logo']['url'];
        }
        $custom_logo_output = '<img src="' . $custom_logo . '" alt="maintenance" style="margin: 0 auto; display: block;" />';
        if (isset($options['enable_maintenance'])) {
            $maintenance_mode = $options['enable_maintenance'];
        } else {
            $maintenance_mode = false;
        }
        if ($maintenance_mode) {
            if (!current_user_can('edit_themes') || !is_user_logged_in()) {
                wp_die($custom_logo_output . '<p style="text-align:center">' . esc_html__('We are currently in maintenance mode, please check back shortly.', 'tentered') . '</p>', esc_html__('Maintenance Mode', 'tentered'));
            }
        }
    }
    add_action('get_header', 'tentered_maintenance_mode');
}
/* CUSTOM LOGIN LOGO
  ================================================== */
if (!function_exists('tentered_custom_login_logo')) {
    function tentered_custom_login_logo() {
        $options = get_option('tentered_options');
        $custom_logo = array('url'=>'');
        if (isset($options['custom_admin_login_logo'])) {
            $custom_logo = $options['custom_admin_login_logo'];
        }
		echo '<style type="text/css">
			    .login h1 a { background-image:url(' . $custom_logo['url'] . ') !important; background-size: auto !important; width: auto !important; height: 95px !important; }
			</style>';
    }
    add_action('login_head', 'tentered_custom_login_logo');
}
/* CUSTOM CSS OUTPUT
  ================================================== */
if (!function_exists('tentered_custom_styles')) {
    function tentered_custom_styles() {
        $options = get_option('tentered_options');
// OPEN STYLE TAG
        echo '<style type="text/css">' . "\n";
        // Custom CSS
        $custom_css = (isset($options['custom_css']))?$options['custom_css']:'';
        if (isset($options['theme_color_type'][0])&&$options['theme_color_type'][0] == 1) {
            $primaryColor = $options['primary_theme_color'];
            echo '#menu-toggle:hover,#sidebar-col .widgettitle,.accent-color,.basic-link,.blog-posts .post .blog-post-details a:hover,.btn-link,.btn-primary .badge,.dd-menu>li a:hover,.dd-menu>li.current-menu-item>a,.dd-menu>li.current-menu-parent>a,.dnav1 .next:hover,.dnav1 .prev:hover,.fblock-style2 .fblock-icon,.header-style2 .is-sticky .dd-menu>li>a:hover,.header-style4 .dd-menu>li:hover>a,.header-style4 .dd-menu>li>a:hover,.icon-box-inline span,.icon-box.ibox-border .ibox-icon i,.icon-box.ibox-border .ibox-icon img,.icon-box.ibox-plain .ibox-icon i,.icon-box.ibox-plain .ibox-icon img,.list-group-item a:hover,.megamenu-sub-title i,.nav-np .next:hover,.nav-np .prev:hover,.nav-pills>.active>a>.badge,.pagination>li>a:focus,.pagination>li>a:hover,.pagination>li>span:focus,.pagination>li>span:hover,.portfolio-item:hover .action-icons a,.post .post-title a:hover,.post-actions .comment-count a:hover,.pricing-column .features a:hover,.pricing-column h3,.search-icon a:hover,.services-list li i.fa,.single-product .woocommerce-Price-amount,.site-footer .footer_widget a:hover,.team-list-item h3 a:hover,.team-position,.testimonial .fa-quote-left,.text-primary,.widget a:hover,.widget li .meta-data a:hover,.widget.recent_posts ul li h5 a:hover,.widget_archive ul li a:hover,.widget_categories ul li a:hover,.widget_links ul li a:hover,.widget_links ul li.active a,.widget_meta ul li a:hover,.widget_recent_comments ul li a:hover,.widget_recent_entries ul li a:hover,.woocommerce ul.products li.product .price,.woocommerce ul.products li.product a:hover h3,a,a.external:before,a.list-group-item.active>.badge,a:hover,address strong,p.drop-caps:first-letter,ul.angles li:before,ul.carets li:before,ul.chevrons li::before,ul.icon>li>i,ul.inline li i.fa,ul.inline li:before{
				color:'.esc_attr($primaryColor).';
			}
			.accent-color,.features:hover a{
				color:'.esc_attr($primaryColor).'!important;
			}
			.accordion-heading .accordion-toggle.active,.blog-image:hover .blog-overlay,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,.carousel-indicators .active,.dd-menu>li>ul>li>a:hover,.dd-menu>li>ul>li>ul>li>a:hover,.dd-menu>li>ul>li>ul>li>ul>li>a:hover,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.fblock-image-overlay,.fblock-style2:hover .fblock-icon,.features .features-icon,.flex-control-nav a.flex-active,.flex-control-nav a:hover,.header-style3 .dd-menu>li ul,.header-style3 .dd-menu>li.current-menu-item>a,.header-style3 .dd-menu>li:hover>a,.header-style3 .dd-menu>li>a:hover,.header-style3 .dd-menu>li>ul>li>ul>li>a:hover,.header-style3 .dd-menu>li>ul>li>ul>li>ul>li>a:hover,.ibox-border.ibox-effect.ibox-dark .ibox-icon i:after,.ibox-effect.ibox-dark .ibox-icon i:hover,.ibox-effect.ibox-dark:hover .ibox-icon i,.icon-box .ibox-icon i,.icon-box .ibox-icon img,.icon-box.ibox-dark.ibox-outline:hover .ibox-icon i,.icon-box.icon-box-style1:hover .ico,.label-primary,.media-box .media-box-wrapper,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.overlay-accent,.owl-theme .owl-controls.clickable .owl-page:hover span,.owl-theme .owl-page.active span,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.panel-primary>.panel-heading,.parallax-overlay,.portfolio-item:hover .project-overlay:before,.pricing-column.highlight h3,.progress-bar-primary,.services-overlay:before,.single-team-media .social-icons,.social-icons-colored li.envelope a:hover,.social-icons-inverted li.envelope a,.social-share-bar .share-buttons-tc li a,.tagcloud a:hover,.team-item:hover .team-overlay-bg,a.list-group-item.active,a.list-group-item.active:focus,a.list-group-item.active:hover,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,p.drop-caps.secondary:first-letter{
			  background-color:'.esc_attr($primaryColor).';
			}
			.accent-bg,.accent-overlay:before,.donate-button,.woocommerce #content input.button.alt:active,.woocommerce #content input.button.alt:hover,.woocommerce #respond input#submit.alt:active,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:active,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:active,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:active,.woocommerce input.button.alt:hover,.woocommerce ul.products li.product .button,.woocommerce-page #content input.button.alt:active,.woocommerce-page #content input.button.alt:hover,.woocommerce-page #respond input#submit.alt:active,.woocommerce-page #respond input#submit.alt:hover,.woocommerce-page a.button.alt:active,.woocommerce-page a.button.alt:hover,.woocommerce-page button.button.alt:active,.woocommerce-page button.button.alt:hover,.woocommerce-page input.button.alt:active,.woocommerce-page input.button.alt:hover,.wpcf7-form .wpcf7-submit{
			  background-color: '.esc_attr($primaryColor).'!important;
			}
			.woocommerce #content input.button.alt,.woocommerce #respond input#submit.alt,.woocommerce .widget_layered_nav ul li.chosen a,.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce-page #content input.button.alt,.woocommerce-page #respond input#submit.alt,.woocommerce-page .widget_layered_nav ul li.chosen a,.woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle,.woocommerce-page a.button.alt,.woocommerce-page button.button.alt,.woocommerce-page input.button.alt,.wpcf7-form .wpcf7-submit,p.demo_store{
			  background: '.esc_attr($primaryColor).';
			}
			.btn-primary.active,.btn-primary:active,.btn-primary:focus,.btn-primary:hover,.open .dropdown-toggle.btn-primary{
			  background: '.esc_attr($primaryColor).';
			  opacity:.9
			}
			.btn-primary.btn-transparent,.fblock-style2 .fblock-icon,.icon-box-inline span,.icon-box.ibox-border .ibox-icon,.icon-box.ibox-dark.ibox-outline:hover .ibox-icon,.icon-box.ibox-outline .ibox-icon,.icon-box.icon-box-style1 .ico,.nav .open>a,.nav .open>a:focus,.nav .open>a:hover,.nav-tabs.nav-justified>.active>a,.nav-tabs.nav-justified>.active>a:focus,.nav-tabs.nav-justified>.active>a:hover,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.panel-primary,.panel-primary>.panel-heading,.services-list li:hover section,.tagcloud a:hover,.timeline .column .title .label:before,a.list-group-item.active,a.list-group-item.active:focus,a.list-group-item.active:hover,a.thumbnail.active,a.thumbnail:focus,a.thumbnail:hover{
				border-color:'.esc_attr($primaryColor).';
			}
			.header-style4 .dd-menu>li.active>a,.header-style4 .dd-menu>li:hover>a,.header-style4 .dd-menu>li>a:hover,.panel-primary>.panel-heading+.panel-collapse .panel-body,.woocommerce .woocommerce-info,.woocommerce .woocommerce-message,.woocommerce-page .woocommerce-info,.woocommerce-page .woocommerce-message{
				border-top-color:'.esc_attr($primaryColor).';
			}
			.dd-menu>li ul:before,.dd-menu>li>a:before,.panel-primary>.panel-footer+.panel-collapse .panel-body{
				border-bottom-color:'.esc_attr($primaryColor).';
			}
			#sidebar-col .widget_nav_menu ul li a:hover,#sidebar-col .widget_nav_menu ul li.current-menu-item a,.dd-menu>ul>li>ul li:hover,blockquote{
				border-left-color:'.esc_attr($primaryColor).';
			}
			.dd-menu>li ul li ul:before{
				border-right-color: '.esc_attr($primaryColor).';
			}
			.ibox-border.ibox-effect.ibox-dark .ibox-icon i:hover,.ibox-border.ibox-effect.ibox-dark:hover .ibox-icon i{
				box-shadow:0 0 0 1px '.esc_attr($primaryColor).';
			}
			.ibox-effect.ibox-dark .ibox-icon i:after{
				box-shadow:0 0 0 2px '.esc_attr($primaryColor).';
			}
			@media only screen and (max-width:992px){.header-style3 .dd-menu>li a:hover{
					color:'.esc_attr($primaryColor).';
				}
			}';
}
		
		$site_width = (isset($options['site_width']))?$options['site_width']:'1170';
		$site_width_spaced=!empty($site_width)?$site_width+30:1200;
		$site_width_diff=$site_width_spaced/2;
		$SiteMinHeight = (isset($options['content_min_height']))?$options['content_min_height']:'400';
		$pagetitlecolor = (isset($options['inner_page_header_title_typography']['color']))?$options['inner_page_header_title_typography']['color']:'';
		$footer_wide_width = (isset($options['full_width_footer']))?$options['full_width_footer']:'';
		$ddRadius = (isset($options['dd_border_radius']))?$options['dd_border_radius']:'';
		$mmtopposition = (isset($options['mobile_menu_drop_top_position']))?$options['mobile_menu_drop_top_position']:'73';
		$mmbackground = (isset($options['mobile_menu_background']['background-color']))?$options['mobile_menu_background']['background-color']:'';
		$mmenubackground = (isset($options['mm_background']['background-color']))?$options['mm_background']['background-color']:'';
		$ddbg = (isset($options['dd_background']['background-color']))?$options['dd_background']['background-color']:'';
		$logoheight = (isset($options['logo_upload']))?$options['logo_upload']['height']:17;
		$logotopspacet = (isset($options['logo_spacing']['margin-top']) && !empty($options['logo_spacing']['margin-top']))?$options['logo_spacing']['margin-top']:30;
		$logotopspaceb = (isset($options['logo_spacing']['margin-bottom']) && !empty($options['logo_spacing']['margin-bottom']))?$options['logo_spacing']['margin-bottom']:30;
		$logotopspacet_new = str_replace('px','',$logotopspacet);
		$logotopspaceb_new = str_replace('px','',$logotopspaceb);
		$logoheight_new = str_replace('px','',$logoheight);
		$mlineheight = ($logotopspacet_new + $logotopspaceb_new + $logoheight_new);
		echo '
			.header-style2 .dd-menu > li ul:before{border-bottom-color:'.esc_attr($ddbg).';}
			.header-style2 .dd-menu > li ul li ul:before{border-right-color:'.esc_attr($ddbg).';}
			.header-style2 .dd-menu > li.megamenu ul:before{border-bottom-color:'.esc_attr($mmenubackground).';}
			@media (min-width: 1200px) {.container{width:'.$site_width.'px;}}
			body.boxed .body, body.boxed .vc_row-no-padding{max-width:'.$site_width_spaced.'px!important;}
			@media (min-width: 1200px) {body.boxed .site-header{width:'.$site_width_spaced.'px;margin-left:-'.$site_width_diff.'px;}}
			.dd-menu > li > a, .search-module-trigger, .cart-module-trigger, .mmenu-toggle{line-height:'.$mlineheight.'px;}
		';
		if ($SiteMinHeight != '')
		{
		}
		if (isset($options['sidebar_position'])&&$options['sidebar_position'] == 2) {
			echo ' #content-col, #sidebar-col{float:right!important;}';
		}
		if (isset($options['content_wide_width'])&&$options['content_wide_width'] == 1)
		{
			echo '.content .container{width:100%;}';
		}
		if (isset($options['header_wide_width'])&&$options['header_wide_width'] == 1)
		{
			echo '.site-header .container, .topbar .container, .fw-menu-wrapper .container{width:100%;}';
		}
		if ($SiteMinHeight != '')
		{
			echo '.content{min-height:'.esc_attr($SiteMinHeight).'px}';
		}
		if (isset($options['inner_page_header_title'])&&$options['inner_page_header_title'] == 0)
		{
			echo '.page-banner-text h1, .page-banner-text p{visibility:hidden!important;}';
		}
		if (isset($options['show_topbar'])&&$options['show_topbar'] == 0)
		{
			echo '.topbar{display:none;}';
		}
		if (isset($options['inner_page_header_display'])&&$options['inner_page_header_display'] == 1)
		{
			echo '.hero-area{display:none!important;}';
		}
		if ($footer_wide_width == 1) {
			echo '.site-footer > .container{width:100%;}';
		}
		if (isset($options['footer_bottom_enable'])&&$options['footer_bottom_enable'] == 0)
		{
			echo '.site-footer-bottom{display:none;}';
		}
		if (isset($options['nav_directions_arrows'])&&$options['nav_directions_arrows'] == 0)
		{
			echo '.dd-menu > li.menu-item-has-children a:after, .dd-menu > li.menu-item-has-children a:before{display:none;}';
		}
		if (isset($options['dd_dropshadow'])&&$options['dd_dropshadow'] == 0)
		{
			echo '.dd-menu > li ul{-webkit-box-shadow:none; -moz-box-shadow:none; box-shadow:none;}';
		}
		if ($ddRadius != '')
		{
			echo '.dd-menu > li ul{border-radius:'.esc_attr($ddRadius).'px;}.dd-menu > li > ul li ul{border-radius:'.esc_attr($ddRadius).'px;}.dd-menu > li > ul > li:first-child > a {border-radius:'.esc_attr($ddRadius).'px '.esc_attr($ddRadius).'px 0 0;} .dd-menu > li > ul > li:last-child > a {border-radius:0 0 '.esc_attr($ddRadius).'px '.esc_attr($ddRadius).'px;}.dd-menu > li > ul > li > ul > li:first-child > a {border-radius:'.esc_attr($ddRadius).'px '.esc_attr($ddRadius).'px 0 0;} .dd-menu > li > ul > li > ul > li:last-child > a {border-radius:0 0 '.esc_attr($ddRadius).'px '.esc_attr($ddRadius).'px;}';
		}
		if ($mlineheight != '')
		{
			echo '.search-module-opened, .cart-module-opened{top:'.esc_attr($mlineheight).'px;}';
		}
		if ($mmtopposition != '')
		{
			echo '.mobile-menu{top:'.esc_attr($mmtopposition).'px;}';
		}
		if ($mmbackground != '')
		{
			echo '@media only screen and (max-width: 992px) {.mobile-menu{background:'.esc_attr($mmbackground).';}}';
		}
		
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['regular'])&&$options['mobile_menu_color']['regular'] != '') {
			echo '@media only screen and (max-width: 992px) {.mobile-menu .dd-menu > li > a, .mobile-menu .dd-menu > li > ul > li > a, .mobile-menu .dd-menu > li > ul > li > ul > li > a, .is-sticky .mobile-menu .dd-menu > li > a, .sticky-menu-active .mobile-menu .dd-menu > li > a{color:'.$options['mobile_menu_color']['regular'].';}}';
		}
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['hover'])&&$options['mobile_menu_color']['hover'] != '') {
			echo '@media only screen and (max-width: 992px) {.mobile-menu .dd-menu > li > a:hover, .mobile-menu .dd-menu > li > ul > li > a:hover, .mobile-menu .dd-menu > li > ul > li > ul > li > a:hover, .is-sticky .mobile-menu .dd-menu > li > a:hover, .sticky-menu-active .mobile-menu .dd-menu > li > a:hover{color:'.$options['mobile_menu_color']['hover'].';}}';
		}
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['active'])&&$options['mobile_menu_color']['active'] != '') {
			echo '@media only screen and (max-width: 992px) {.mobile-menu .dd-menu > li > a:active, .mobile-menu .dd-menu > li > ul > li > a:active, .mobile-menu .dd-menu > li > ul > li > ul > li > a:active .is-sticky .mobile-menu .dd-menu > li > a:active, .sticky-menu-active .mobile-menu .dd-menu > li > a:active{color:'.$options['mobile_menu_color']['active'].';}}';
		}
		if (isset($options['mobile_menu_border']['border-bottom'])&&$options['mobile_menu_border']['border-bottom'] != '') {
			echo '@media only screen and (max-width: 992px) {.mobile-menu .dd-menu > li > a, .mobile-menu .dd-menu > li > ul > li > a, .mobile-menu .dd-menu > li > ul > li > ul > li > a{border-bottom-width:'.$options['mobile_menu_border']['border-bottom'].';border-bottom-style:'.$options['mobile_menu_border']['border-style'].';border-bottom-color:'.$options['mobile_menu_border']['border-color'].';}}';
		}
		
		
        // USER STYLES
        if ($custom_css) {
            echo "\n" . '/*========== User Custom CSS Styles ==========*/' . "\n";
            echo ''.$custom_css;
        }
        // CLOSE STYLE TAG
        echo "</style>" . "\n";
    }
    add_action('wp_head', 'tentered_custom_styles');
}
/* CUSTOM JS OUTPUT
  ================================================== */
if (!function_exists('tentered_custom_script')) {
    function tentered_custom_script() {
        $options = get_option('tentered_options');
        $custom_js = (isset($options['custom_js']))?$options['custom_js']:'';
        if ($custom_js) {
            echo'<script type ="text/javascript">';
            echo ''.$custom_js;
            echo '</script>';
        }  
    }
    add_action('wp_footer', 'tentered_custom_script');
}
//Fetch Youtube Video ID
if(!function_exists('tentered_linkifyYouTubeURLs'))
{
function tentered_linkifyYouTubeURLs($text) {
    $text = preg_replace('~
        # Match non-linked youtube URL in the wild. (Rev:20130823)
        https?://         # Required scheme. Either http or https.
        (?:[0-9A-Z-]+\.)? # Optional subdomain.
        (?:               # Group host alternatives.
          youtu\.be/      # Either youtu.be,
        | youtube         # or youtube.com or
          (?:-nocookie)?  # youtube-nocookie.com
          \.com           # followed by
          \S*             # Allow anything up to VIDEO_ID,
          [^\w\s-]       # but char before ID is non-ID char.
        )                 # End host alternatives.
        ([\w-]{11})      # $1: VIDEO_ID is exactly 11 chars.
        (?=[^\w-]|$)     # Assert next char is non-ID or EOS.
        (?!               # Assert URL is not pre-linked.
          [?=&+%\w.-]*    # Allow URL (query) remainder.
          (?:             # Group pre-linked alternatives.
            [\'"][^<>]*>  # Either inside a start tag,
          | </a>          # or inside <a> element text contents.
          )               # End recognized pre-linked alts.
        )                 # End negative lookahead assertion.
        [?=&+%\w.-]*        # Consume any URL (query) remainder.
        ~ix', 
        '$1',
        $text);
    return $text;
}
}
/* VIDEO EMBED FUNCTIONS
  ================================================== */
if (!function_exists('tentered_video_embed')) {
    function tentered_video_embed($url, $width = 500, $height = 300) {
        if (strpos($url, 'youtube') || strpos($url, 'youtu.be')) {
            return tentered_video_youtube($url, $width, $height);
        } else {
            return tentered_video_vimeo($url, $width, $height);
        }
    }
}
/* Video Youtube
  ================================================== */
if (!function_exists('tentered_video_youtube')) {
    function tentered_video_youtube($url, $width = 560, $height = 315) {
		if($url!='') {
        $video_id = tentered_linkifyYouTubeURLs($url);
			return '<iframe itemprop="video" src="//www.youtube.com/embed/' . $video_id . '?wmode=transparent&autoplay=0" width="' . $width . '" height="' . $height . '" ></iframe>';
		}
   }
}
/* Video Vimeo
  ================================================== */
if (!function_exists('tentered_video_vimeo')) {
   function tentered_video_vimeo($url, $width = 500, $height = 281) {
	   if($url!='') {
        preg_match('/https?:\/\/vimeo.com\/(\d+)$/', $url, $video_id);
        return '<iframe src="//player.vimeo.com/video/' . $video_id[1] . '?title=0&amp;byline=0&amp;autoplay=0&amp;portrait=0" width="' . $width . '" height="' . $height . '" allowfullscreen></iframe>'; }
    }
}
/* Soundcloud Audio
====================================================== */
//Get the SoundCloud URL
if (!function_exists('tentered_audio_soundcloud')) {
   function tentered_audio_soundcloud($url, $width = "100%", $height = 450) {
		$getValues=wp_remote_get('https://soundcloud.com/oembed?format=js&url='.$url.'&iframe=true');
	    $rbody = wp_remote_retrieve_body($getValues);
		$decodeiFrame=substr($rbody, 1, -2);
		$jsonObj = json_decode($decodeiFrame);
		return str_replace('height="400"', 'height="240"', $jsonObj->html);
   }
}
/* REGISTER SIDEBARS
  ================================================== */
if (!function_exists('tentered_widgets_init')) {
    add_action( 'widgets_init', 'tentered_widgets_init' );
    function tentered_widgets_init() {
        if (function_exists('register_sidebar')) {
			$options = get_option('tentered_options');
			$footer_class = (isset($options["footer_layout"]))?$options["footer_layout"]:'4';
			register_sidebar(array(
                'name' => esc_html__('Blog Sidebar', 'tentered'),
                'id' => 'blog-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Page Sidebar', 'tentered'),
                'id' => 'page-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Post Sidebar', 'tentered'),
                'id' => 'post-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Services Sidebar', 'tentered'),
                'id' => 'services-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Projects Sidebar', 'tentered'),
                'id' => 'projects-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Shop Sidebar', 'tentered'),
                'id' => 'shop-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Footer Widgets', 'tentered'),
                'id' => 'footer-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div class="col-md-'.$footer_class.' col-sm-6 widget footer_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h4 class="widgettitle">',
                'after_title' => '</h4>'
            ));
        }
    }
}
/* -------------------------------------------------------------------------------------
  Filter the Widget Title.
  ----------------------------------------------------------------------------------- */
if (!function_exists('tentered_widget_titles')) {
    add_filter('dynamic_sidebar_params', 'tentered_widget_titles', 20);
    function tentered_widget_titles(array $params) {
        // $params will ordinarily be an array of 2 elements, we're only interested in the first element
        $widget = & $params[0];
        $id = $params[0]['id'];
        if ($id == 'footer-sidebar') {
            $widget['before_title'] = '<h4 class="widgettitle">';
            $widget['after_title'] = '</h4>';
        } else {
            $widget['before_title'] = '<h3 class="widgettitle">';
            $widget['after_title'] = '</h3>';
        }
        return $params;
    }
}
//Get all Sidebars
if (!function_exists('tentered_get_all_sidebars')) {
    function tentered_get_all_sidebars() {
        $all_sidebars = array();
        global $wp_registered_sidebars;
        $all_sidebars = array('' => '');
        foreach ($wp_registered_sidebars as $sidebar) {
            $all_sidebars[$sidebar['id']] = $sidebar['name'];
        }
        return $all_sidebars;
    }
}
//Meta Box for Sidebar on all Posts/Page
if (!function_exists('tentered_register_meta_box')) {
    add_action('admin_init', 'tentered_register_meta_box');
    function tentered_register_meta_box() {
        // Check if plugin is activated or included in theme
        if (!class_exists('RW_Meta_Box'))
            return;
        $prefix = 'tentered_';
        $meta_box = array(
            'id' => 'template-sidebar1',
            'title' => esc_html__("Select Sidebar", 'tentered'),
            'pages' => array('post', 'page', 'project', 'team', 'service'),
            'context' => 'normal',
            'fields' => array(
                array(
                    'name' => 'Select Sidebar from list',
                    'id' => $prefix . 'select_sidebar_from_list',
                    'desc' => esc_html__("Select Sidebar from list, if using page builder then please add sidebar from element only.", 'tentered'),
                    'type' => 'select',
                    'options' => tentered_get_all_sidebars(),
                ),
                array(
                    'name' => 'Show no sidebar',
                    'id' => $prefix . 'strict_no_sidebar',
                    'desc' => esc_html__("This will dishonour page sidebar chosen at Theme Options as well.", 'tentered'),
                    'type' => 'checkbox',
					'default' => 0
                ),
                array(
                    'name' => 'Select Sidebar Position',
                    'id' => $prefix . 'select_sidebar_position',
                    'desc' => esc_html__("Select Sidebar Postion", 'tentered'),
                    'type' => 'radio',
                    'options' => array(
						'2' => 'Left',
						'1' => 'Right'
					),
					'default' => '1'
                ),
				array(
					'name' => esc_html__('Columns Layout', 'tentered'),
					'id' => $prefix . 'sidebar_columns_layout',
					'desc' => esc_html__("Select Sidebar Width", 'tentered'),
					'type' => 'select',
					'options' => array(
						'3' => esc_html__('One Fourth', 'tentered'),
						'4' => esc_html__('One Third','tentered'),
						'6' => esc_html__('Half','tentered'),
							),
					'default' => 3,
			),
            )
        );
        new RW_Meta_Box($meta_box);
    }
}
//Get all Menus
if (!function_exists('tentered_get_all_menus')) {
    function tentered_get_all_menus() {
		$all_menus = array();
    	$all_menu = wp_get_nav_menus();
		foreach ( $all_menu as $menu ) {
			$all_menus[$menu->term_id] = $menu->name;
		}
		return $all_menus;
    }
}
//Meta Box for Menu on One Page Template
if (!function_exists('tentered_register_menu_meta_box')) {
    add_action('admin_init', 'tentered_register_menu_meta_box');
    function tentered_register_menu_meta_box() {
        // Check if plugin is activated or included in theme
        if (!class_exists('RW_Meta_Box'))
            return;
        $prefix = 'tentered_';
        $meta_box = array(
            'id' => 'template-one-page',
            'title' => esc_html__("One Page Menu", 'tentered'),
            'pages' => array('page'),
			'show'   => array(
				'template' => array( 'template-onepage.php' ),
			),
            'context' => 'normal',
            'fields' => array(
                array(
                    'name' => 'Select Menu from list',
                    'id' => $prefix . 'select_menu_from_list',
                    'desc' => esc_html__("Select the menu from the list to use as this One Page menu. Your primary menu will be replaced by this selected menu on this page only and will be used as one page scroller. The pages added to the selected menu will be used as content of the one page website.", 'tentered'),
                    'type' => 'select',
                    'options' => tentered_get_all_menus(),
                ),
            )
        );
        new RW_Meta_Box($meta_box);
    }
}
/** -------------------------------------------------------------------------------------
 * Gallery Flexslider
 * @param ID of current Post.
 * @return Div with flexslider parameter.
  ----------------------------------------------------------------------------------- */
if (!function_exists('tentered_gallery_flexslider')) {
    function tentered_gallery_flexslider($id) {
		$speed = (get_post_meta(get_the_ID(), 'tentered_gallery_slider_speed', true)!='')?get_post_meta(get_the_ID(), 'tentered_gallery_slider_speed', true):5000;
        $pagination = get_post_meta(get_the_ID(), 'tentered_gallery_slider_pagination', true);
        $auto_slide = get_post_meta(get_the_ID(), 'tentered_gallery_slider_auto_slide', true);
        $direction = get_post_meta(get_the_ID(), 'tentered_gallery_slider_direction_arrows', true);
        $effect = get_post_meta(get_the_ID(), 'tentered_gallery_slider_effects', true);
        $pagination = !empty($pagination) ? $pagination : 'yes';
        $auto_slide = !empty($auto_slide) ? $auto_slide : 'yes';
        $direction = !empty($direction) ? $direction : 'yes';
        $effect = !empty($effect) ? $effect : 'slide';
        return '<div class="flexslider galleryflex" data-autoplay="' . $auto_slide . '" data-pagination="' . $pagination . '" data-arrows="' . $direction . '" data-style="' . $effect . '" data-pause="yes" data-speed='.$speed.'>';
    }
}
 /**
 * TENTERED SIDEBAR POSITION
 */
if(!function_exists('tentered_sidebar_position_module'))
{
	function tentered_sidebar_position_module()
	{
		$sidebar_position = get_post_meta(get_the_ID(),'tentered_select_sidebar_position',true);
		if(is_home())
		{
			$id = get_option('page_for_posts');
			$sidebar_position = get_post_meta($id,'tentered_select_sidebar_position',true);
		}
		if(class_exists('buddypress') && is_buddypress()){
			$component = bp_current_component();
			$bp_pages = get_option( 'bp-pages' );
			$id = $bp_pages[$component];
			$sidebar_position = get_post_meta($id,'tentered_select_sidebar_position',true);
		}
		if($sidebar_position == 2)
		{
			echo ' <style type="text/css">#content-col, #sidebar-col{float:right!important;}</style>';	
		}
		elseif($sidebar_position == 1)
		{
			echo ' <style type="text/css">#content-col, #sidebar-col{float:left!important;}</style>';	
		}
	}
}
 /**
 * TENTERED SHARE BUTTONS
 */
if(!function_exists('tentered_share_buttons')){
function tentered_share_buttons(){
$posttitle = get_the_title();
$postpermalink = get_permalink();
$postexcerpt = wp_trim_words(get_the_excerpt());
global $tentered_options;
$facebook_share_alt = $tentered_options['facebook_share_alt'];
$twitter_share_alt = $tentered_options['twitter_share_alt'];
$google_share_alt = $tentered_options['google_share_alt'];
$tumblr_share_alt = $tentered_options['tumblr_share_alt'];
$pinterest_share_alt = $tentered_options['pinterest_share_alt'];
$reddit_share_alt = $tentered_options['reddit_share_alt'];
$linkedin_share_alt = $tentered_options['linkedin_share_alt'];
$email_share_alt = $tentered_options['email_share_alt'];
$vk_share_alt = $tentered_options['vk_share_alt'];
$whatsapp_share_alt = $tentered_options['whatsapp_share_alt'];
			
            echo '<div class="social-share-bar">';
			if($tentered_options['sharing_style'] == '0'){
				if($tentered_options['sharing_color'] == '0'){
            		echo '<ul class="social-icons-colored share-buttons-bc">';
				}elseif($tentered_options['sharing_color'] == '1'){
            		echo '<ul class="social-icons-colored share-buttons-tc">';
				}elseif($tentered_options['sharing_color'] == '2'){
            		echo '<ul class="social-icons-colored share-buttons-gs">';
				}
			} elseif($tentered_options['sharing_style'] == '1'){
				if($tentered_options['sharing_color'] == '0'){
            		echo '<ul class="social-icons-colored share-buttons-bc share-buttons-squared">';
				}elseif($tentered_options['sharing_color'] == '1'){
            		echo '<ul class="social-icons-colored share-buttons-tc share-buttons-squared">';
				}elseif($tentered_options['sharing_color'] == '2'){
            		echo '<ul class="social-icons-colored share-buttons-gs share-buttons-squared">';
				}
			};
					if($tentered_options['share_before_icon'] == 1){
						echo '<li class="share-title"><i class="fa fa-share-alt"></i></li>';
					}
					if($tentered_options['share_before_text'] != ''){
						echo '<li class="share-title">'.esc_attr($tentered_options['share_before_text']).'</li>';
					}
                	echo '<li class="share-title"></li>';
					if($tentered_options['share_icon']['1'] == '1'){
                   		echo '<li class="facebook-share"><a href="https://www.facebook.com/sharer/sharer.php?u=' . esc_url($postpermalink) . '&amp;t=' . esc_attr($posttitle) . '" target="_blank" title="' . esc_attr($facebook_share_alt) . '"><i class="fa fa-facebook"></i></a></li>';
					}
					if($tentered_options['share_icon']['2'] == '1'){
                     	echo '<li class="twitter-share"><a href="https://twitter.com/intent/tweet?source=' . esc_url($postpermalink) . '&amp;text=' . esc_attr($posttitle) . ':' . esc_html($postpermalink) . '" target="_blank" title="' . esc_attr($twitter_share_alt) . '"><i class="fa fa-twitter"></i></a></li>';
					}
					if($tentered_options['share_icon']['3'] == '1'){
                    echo '<li class="google-share"><a href="https://plus.google.com/share?url=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($google_share_alt) . '"><i class="fa fa-google-plus"></i></a></li>';
					}
					if($tentered_options['share_icon']['4'] == '1'){
                    	echo '<li class="tumblr-share"><a href="http://www.tumblr.com/share?v=3&amp;u=' . esc_url($postpermalink) . '&amp;t=' . esc_attr($posttitle) . '&amp;s=" target="_blank" title="' . esc_attr($tumblr_share_alt) . '"><i class="fa fa-tumblr"></i></a></li>';
					}
					if($tentered_options['share_icon']['5'] == '1'){
                    	echo '<li class="pinterest-share"><a href="http://pinterest.com/pin/create/button/?url=' . esc_url($postpermalink) . '&amp;description=' . esc_html($postexcerpt) . '" target="_blank" title="' . esc_attr($pinterest_share_alt) . '"><i class="fa fa-pinterest"></i></a></li>';
					}
					if($tentered_options['share_icon']['6'] == '1'){
                    	echo '<li class="reddit-share"><a href="http://www.reddit.com/submit?url=' . esc_url($postpermalink) . '&amp;title=' . esc_attr($posttitle) . '" target="_blank" title="' . esc_attr($linkedin_share_alt) . '"><i class="fa fa-reddit"></i></a></li>';
					}
					if($tentered_options['share_icon']['7'] == '1'){
                    	echo '<li class="linkedin-share"><a href="http://www.linkedin.com/shareArticle?mini=true&url=' . esc_url($postpermalink) . '&amp;title=' . esc_attr($posttitle) . '&amp;summary=' . esc_html($postexcerpt) . '&amp;source=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($linkedin_share_alt) . '"><i class="fa fa-linkedin"></i></a></li>';
					}
					if($tentered_options['share_icon']['8'] == '1'){
                    	echo '<li class="email-share"><a href="mailto:?subject=' . esc_attr($posttitle) . '&amp;body=' . esc_html($postexcerpt) . ':' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($email_share_alt) . '"><i class="fa fa-envelope"></i></a></li>';
					}
					if(isset($tentered_options['share_icon']['9'])&&$tentered_options['share_icon']['9'] == 1){
                    	echo '<li class="vk-share"><a href="http://vk.com/share.php?url=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($vk_share_alt) . '"><i class="fa fa-vk"></i></a></li>';
					}
					if(isset($tentered_options['share_icon']['10'])&&$tentered_options['share_icon']['10'] == 1){
                    	echo '<li class="whatsapp-share"><a href="whatsapp://send?text=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($whatsapp_share_alt) . '" data-action="share/whatsapp/share"><i class="fa fa-whatsapp"></i></a></li>';
					}
                echo '</ul>
            </div>';
	}
}
/*======================
Change Excerpt Length*/
if (!function_exists('tentered_custom_excerpt_length')) {
function tentered_custom_excerpt_length( $length ) {
	return 520;
}
add_filter( 'excerpt_length', 'tentered_custom_excerpt_length', 999 );
}
//Attachment Meta Box
if(!function_exists('tentered_attachment_url')){
function tentered_attachment_url( $fields, $post ) {
$meta = get_post_meta($post->ID, 'meta_link', true);
$fields['meta_link'] = array(
'label' => esc_html__('Image URL','tentered'),
'input' => 'text',
'value' => $meta,
'show_in_edit' => true,
);
return $fields;
}
add_filter( 'attachment_fields_to_edit', 'tentered_attachment_url', 10, 2 );
}
/**
* Update custom field on save
*/
if(!function_exists('tentered_update_attachment_url')){
function tentered_update_attachment_url($attachment){
global $post;
update_post_meta($post->ID, 'meta_link', $attachment['attachments'][$post->ID]['meta_link']);
return $attachment;
}
add_filter( 'attachment_fields_to_save', 'tentered_update_attachment_url', 4);
}
/**
* Update custom field via ajax
*/
if(!function_exists('tentered_save_attachment_url')){
function tentered_save_attachment_url() {
$post_id = $_POST['id'];
$meta = $_POST['attachments'][$post_id ]['meta_link'];
update_post_meta($post_id , 'meta_link', $meta);
clean_post_cache($post_id);
}
add_action('wp_ajax_save-attachment-compat', 'tentered_save_attachment_url', 0, 1);
}
//Attachment Meta Box
if(!function_exists('tentered_attachment_postid')){
function tentered_attachment_postid( $fields, $post ) {
$meta = get_post_meta($post->ID, 'meta_postid', true);
$fields['meta_postid'] = array(
'label' => esc_html__('Post ID','tentered'),
'input' => 'text',
'value' => $meta,
'show_in_edit' => true,
);
return $fields;
}
add_filter( 'attachment_fields_to_edit', 'tentered_attachment_postid', 10, 2 );
}
/**
* Update custom field on save
*/
if(!function_exists('tentered_update_attachment_postid')){
function tentered_update_attachment_postid($attachment){
global $post;
update_post_meta($post->ID, 'meta_postid', $attachment['attachments'][$post->ID]['meta_postid']);
return $attachment;
}
add_filter( 'attachment_fields_to_save', 'tentered_update_attachment_postid', 4);
}
/**
* Update custom field via ajax
*/
if(!function_exists('tentered_save_attachment_postid')){
function tentered_save_attachment_postid() {
$post_id = $_POST['id'];
$meta = $_POST['attachments'][$post_id ]['meta_postid'];
update_post_meta($post_id , 'meta_postid', $meta);
clean_post_cache($post_id);
}
add_action('wp_ajax_save-attachment-compat', 'tentered_save_attachment_postid', 0, 1);
}
//Get Attachment details
if (!function_exists('tentered_wp_get_attachment')) {
function tentered_wp_get_attachment( $attachment_id ) {
	$attachment = get_post( $attachment_id );
	if(!empty($attachment)) {
	return array(
		'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
		'caption' => $attachment->post_excerpt,
		'description' => $attachment->post_content,
		'href' => get_permalink( $attachment->ID ),
		'src' => $attachment->guid,
		'title' => $attachment->post_title,
		'url' => $attachment->meta_link,
		'postid' => $attachment->meta_postid
	); }
} }
if(!function_exists('tentered_get_post_content'))
{
	function tentered_get_post_content($update_id, $filter='', $limit='25')
	{
		$post_id = get_post($update_id);
		$content = $post_id->post_content;
		if($filter=='1')
		{
			$excerpt = apply_filters('the_content', $content);
		}
		else
		{
			$excerpt = wp_trim_words($content, $limit);
		}
		return $excerpt;
	}
}
/* Add Class to Next/Previous Posts Link
========================================================= */
add_filter('next_posts_link_attributes', 'tentered_older_posts_link');
add_filter('previous_posts_link_attributes', 'tentered_newer_posts_link');

function tentered_older_posts_link() {
    return 'class="pull-left"';
}
function tentered_newer_posts_link() {
    return 'class="pull-right"';
}
add_filter('next_post_link', 'tentered_post_link_attributes_next');
add_filter('previous_post_link', 'tentered_post_link_attributes_prev');
 
function tentered_post_link_attributes_prev($output) {
    $code = 'class="pull-left"';
    return str_replace('<a href=', '<a '.$code.' href=', $output);
}
function tentered_post_link_attributes_next($output) {
    $code = 'class="pull-right"';
    return str_replace('<a href=', '<a '.$code.' href=', $output);
}
//Get All Post Types
if(!function_exists('tentered_get_all_types')){
add_action( 'wp_loaded', 'tentered_get_all_types');
function tentered_get_all_types(){
   $args = array(
   'public'   => true,
   );
$output = 'names'; // names or objects, note names is the default
return $post_types = get_post_types($args, $output); 
}
}
function tentered_post_excerpt_by_id( $post_id ) {
    global $post;
    $post = get_post( $post_id );
    setup_postdata( $post );
    $the_excerpt = get_the_excerpt();
    wp_reset_postdata();
    return $the_excerpt;
}
//Add New Custom Menu Option
if ( !class_exists('TENTERED_Custom_Nav')) {
class TENTERED_Custom_Nav {
public function tentered_add_nav_menu_meta_boxes() {
   
add_meta_box(
'mega_nav_link',
esc_html__('Mega Menu','tentered'),
array( $this, 'nav_menu_link'),
'nav-menus',
'side',
'low'
);
}
public function nav_menu_link() {
    global $_nav_menu_placeholder, $nav_menu_selected_id;
	$_nav_menu_placeholder = 0 > $_nav_menu_placeholder ? $_nav_menu_placeholder - 1 : -1;
    
?>
<div id="posttype-wl-login" class="posttypediv">
<div id="tabs-panel-wishlist-login" class="tabs-panel tabs-panel-active">
<ul id ="wishlist-login-checklist" class="categorychecklist form-no-clear">
<li>
<label class="menu-item-title">
<input type="checkbox" class="menu-item-object-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="<?php echo esc_attr($_nav_menu_placeholder); ?>"> <?php esc_html_e('Create Column','tentered'); ?>
</label>
    <input type="hidden" class="menu-item-db-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-db-id]" value="0">
    <input type="hidden" class="menu-item-object" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object]" value="page">
<input type="hidden" class="menu-item-parent-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-parent-id]" value="0">
   <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="">
<input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php esc_html_e('Column','tentered'); ?>">
<input type="hidden" class="menu-item-classes" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-classes]" value="custom_mega_menu">
</li>
</ul>
</div>
<p class="button-controls">
<span class="add-to-menu">
<input type="submit" class="button-secondary submit-add-to-menu right" value="<?php esc_html_e('Add to Menu','tentered'); ?>" name="add-post-type-menu-item" id="submit-posttype-wl-login">
<span class="spinner"></span>
</span>
</p>
</div>
<?php }
}
}
$custom_nav = new TENTERED_Custom_Nav;
add_action('admin_init', array($custom_nav, 'tentered_add_nav_menu_meta_boxes'));
/* -------------------------------------------------------------------------------------
  RevSlider ShortCode
  ----------------------------------------------------------------------------------- */
if(!function_exists('tentered_RevSliderShortCode')){
function tentered_RevSliderShortCode(){
     $slidernames = array();
    if(class_exists('RevSlider')){
     $sld = new RevSlider();
                $sliders = $sld->getArrSliders();
        if(!empty($sliders)){
           
        foreach($sliders as $slider){
          $title=$slider->getParam('title','false');
           $shortcode=$slider->getParam('shortcode','false');
            $slidernames[esc_attr($shortcode)]=$title;
        }}
           
}
return $slidernames;
}}

 /**
 * TENTERED SEARCH BUTTON
 */
if(!function_exists('tentered_search_button_header')){
function tentered_search_button_header(){
global $options;
			
            echo '<div class="search-module">
                	<a href="#" class="search-module-trigger"><i class="fa fa-search"></i></a>
                    <div class="search-module-opened">';
                    	 get_search_form();
          	echo '</div></div>';
	}
}
 /**
 * TENTERED CART BUTTON
 */

if(!function_exists('tentered_cart_button_header')){
	function tentered_cart_button_header(){
		if(class_exists('Woocommerce')):
			$wcurrency = get_woocommerce_currency_symbol();
			 ?>
			<div class="cart-module header-equaler"><div><div>
				<a href="#" class="cart-module-trigger" id="cart-module-trigger"><i class="fa fa-shopping-cart"></i><span class="cart-tquant">

						<span class="cart-contents">
						</span>
					</span></a>
				<div class="cart-module-opened">
					<div class="cart-module-items">

						<div class="header-quickcart"></div>

					</div>
				</div>
			</div></div></div>
		<?php endif;
	}
}

/* Removing Redux framework pages */
if(!function_exists('tentered_remove_redux_menu'))
{
	add_action( 'admin_menu', 'tentered_remove_redux_menu',12 );
   	function tentered_remove_redux_menu() {
   		remove_submenu_page('tools.php','redux-about');
    }
}

$default_attribs = array('data-displayinput' => array(), 'data-readonly' => array(), 'value' => array(), 'data-fgcolor' => array(), 'data-thickness' => array(), 'data-linecap' => array(), 'data-option-value' => array(), 'data-style' => array(), 'data-pause' => array(), 'data-speed' => array(), 'data-option-key' => array(), 'data-sort-id' => array(),'href' => array(),'rel' => array(),'data-appear-progress-animation' => array(),'data-appear-animation-delay' => array(), 'target' => array('_blank','_self','_top'), 'data-items-mobile' => array(), 'data-items-tablet' => array(), 'data-items-desktop-small' => array(), 'data-items-desktop' => array(), 'data-single-item' => array(), 'data-arrows' => array(), 'data-pagination' => array(), 'data-autoplay' => array(), 'data-columns' => array(), 'width' => array(), 'data-srcset' => array(), 'height' => array(), 'src' => array(), 'id' => array(), 'class' => array(), 'title' => array(), 'style' => array(), 'alt' => array(), 'data' => array(), 'data-mce-id' => array(), 'data-mce-style' => array(), 'data-mce-bogus' => array());

$tentered_allowed_tags = array(
	'div'           => $default_attribs,
	'span'          => $default_attribs,
	'p'             => $default_attribs,
	'a'             => $default_attribs,
	'u'             => $default_attribs,
	'i'             => $default_attribs,
	'q'             => $default_attribs,
	'b'             => $default_attribs,
	'ul'            => $default_attribs,
	'ol'            => $default_attribs,
	'li'            => $default_attribs,
	'br'            => $default_attribs,
	'hr'            => $default_attribs,
	'strong'        => $default_attribs,
	'blockquote'    => $default_attribs,
	'del'           => $default_attribs,
	'strike'        => $default_attribs,
	'em'            => $default_attribs,
	'code'          => $default_attribs,
	'h1'            => $default_attribs,
	'h2'            => $default_attribs,
	'h3'            => $default_attribs,
	'h4'            => $default_attribs,
	'h5'            => $default_attribs,
	'h6'            => $default_attribs,
	'cite'          => $default_attribs,
	'img'           => $default_attribs,
	'section'       => $default_attribs,
	'iframe'        => $default_attribs,
	'input'         => $default_attribs,
	'label'         => $default_attribs,
	'canvas'        => $default_attribs,
);
?>