<?php
if (!defined('ABSPATH'))
exit; // Exit if accessed directly 
/*
* Here you include files which is required by theme
*/
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/tentered-theme-functions.php' );
/* META BOX FRAMEWORK
================================================== */
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/meta-boxes.php' );

/* VISUAL COMPOSER INCLUDE
================================================== */
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/visual_composer.php' );

/* MEGA MENU
================================================== */  
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/tentered-megamenu/tentered-megamenu.php' );

/* PLUGIN INCLUDES
================================================== */
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/tgm/plugin-includes.php' );

/* LOAD STYLESHEETS
================================================== */
if (!function_exists('tentered_enqueue_styles')) {
function tentered_enqueue_styles() {
global $tentered_options;
$theme_info = wp_get_theme();
$theme_color_scheme = (isset($tentered_options['theme_color_scheme']))?$tentered_options['theme_color_scheme']:'color1.css';
			wp_enqueue_style('bootstrap', TENTERED_THEME_PATH . '/css/bootstrap.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('bootstrap-theme', TENTERED_THEME_PATH . '/css/bootstrap-theme.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('line-icons', TENTERED_THEME_PATH . '/css/line-icons.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('fontawesome', TENTERED_THEME_PATH . '/css/font-awesome.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('animations', TENTERED_THEME_PATH . '/css/animations.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('tentered-main', get_stylesheet_uri(), array(), $theme_info->get( 'Version' ), 'all');
        	wp_enqueue_style('magnific', TENTERED_THEME_PATH . '/vendor/magnific/magnific-popup.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('owl-carousel', TENTERED_THEME_PATH . '/vendor/owl-carousel/css/owl.carousel.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('owl-carousel-theme', TENTERED_THEME_PATH . '/vendor/owl-carousel/css/owl.theme.css', array(), $theme_info->get( 'Version' ), 'all');
			if (isset($tentered_options['theme_color_type'])&&$tentered_options['theme_color_type'][0] == 0) {
				wp_enqueue_style('tentered-colors', TENTERED_THEME_PATH . '/colors/' . $theme_color_scheme, array(), $theme_info->get( 'Version' ), 'all');
			} else {
				wp_enqueue_style('tentered-colors', TENTERED_THEME_PATH . '/colors/color1.css', array(), $theme_info->get( 'Version' ), 'all');
			}
			//**End Enqueue STYLESHEETPATH**//
		}
		add_action('wp_enqueue_scripts', 'tentered_enqueue_styles', 999);
}
if (!function_exists('tentered_enqueue_scripts')) {
    function tentered_enqueue_scripts() {
        $tentered_options = get_option('tentered_options');
		$theme_info = wp_get_theme();
        //**register script**//
		wp_enqueue_script('modernizr', TENTERED_THEME_PATH . '/js/modernizr.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('magnific', TENTERED_THEME_PATH . '/vendor/magnific/jquery.magnific-popup.min.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('waypoints', TENTERED_THEME_PATH . '/js/waypoints.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('tentered-ui-plugins', TENTERED_THEME_PATH . '/js/ui-plugins.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('tentered-helper-plugins', TENTERED_THEME_PATH . '/js/helper-plugins.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('owl-carousel', TENTERED_THEME_PATH . '/vendor/owl-carousel/js/owl.carousel.min.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('flexslider', TENTERED_THEME_PATH . '/vendor/flexslider/js/jquery.flexslider.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('bootstrap', TENTERED_THEME_PATH . '/js/bootstrap.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('tentered-init', TENTERED_THEME_PATH . '/js/init.js', array('jquery'), $theme_info->get( 'Version' ), true);
		$sticky_enabler = (isset($tentered_options['enable_sticky_header']))?$tentered_options['enable_sticky_header']:1;
		$site_width = (isset($tentered_options['site_width']))?$tentered_options['site_width']:1170;
		wp_localize_script('tentered-init', 'imi_local', array('homeurl' => get_template_directory_uri(), 'enableSticky' => $sticky_enabler, 'siteWidth' => $site_width));
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
    }
    add_action('wp_enqueue_scripts', 'tentered_enqueue_scripts');
}
/* LOAD BACKEND SCRIPTS
  ================================================== */
function tentered_admin_scripts() 
{
 	wp_register_script('tentered-admin-functions', TENTERED_THEME_PATH . '/js/admin_scripts.js', 'jquery', NULL, TRUE);
	global $pagenow;
	if(($pagenow=='user-edit.php')||($pagenow=='profile.php'))
	{
		wp_enqueue_media();
	}
  wp_enqueue_script('tentered-admin-functions');
	if(isset($_REQUEST['taxonomy'])){
      wp_enqueue_script('tentered-upload', TENTERED_THEME_PATH . '/js/imic-upload.js', 'jquery', NULL, TRUE);
      wp_enqueue_media();
  }
}
add_action('admin_init', 'tentered_admin_scripts');
/* LOAD BACKEND STYLE
  ================================================== */
function tentered_admin_styles() {
    add_editor_style(TENTERED_THEME_PATH . '/css/editor-style.css');
}
add_action('admin_head', 'tentered_admin_styles');
?>