<?php 
get_header();
global $tentered_options, $tentered_allowed_tags;
tentered_sidebar_position_module();
$pageSidebarGet = get_post_meta(get_the_ID(),'tentered_select_sidebar_from_list', true);
$pageSidebarStrictNo = get_post_meta(get_the_ID(),'tentered_strict_no_sidebar', true);
$pageSidebarOpt = (isset($tentered_options['project_sidebar']))?$tentered_options['project_sidebar']:'';
if($pageSidebarGet != ''){
	$pageSidebar = $pageSidebarGet;
}elseif($pageSidebarOpt != ''){
	$pageSidebar = $pageSidebarOpt;
}else{
	$pageSidebar = '';
}
if($pageSidebarStrictNo == 1){
	$pageSidebar = '';
}
$sidebar_column = get_post_meta(get_the_ID(),'tentered_sidebar_columns_layout',true);
if(!empty($pageSidebar)&&is_active_sidebar($pageSidebar)) {
$sidebar_column = ($sidebar_column=='')?4:$sidebar_column;
$left_col = 12-$sidebar_column;
$class = $left_col;  
}else{
$class = 12;  
}
$page_header = get_post_meta(get_the_ID(),'tentered_pages_Choose_slider_display',true);
if($page_header==4) {
	get_template_part( 'pages', 'flex' );
}
elseif($page_header==5) {
	get_template_part( 'pages', 'revolution' );
} else{
	get_template_part( 'pages', 'banner' );
}
?>
<div class="main" role="main">
  <div id="content" class="content full">
    <div class="container">
      <div class="row">
        <div class="col-md-<?php echo esc_attr($class); ?>" id="content-col">
        
          <?php if(have_posts()) : ?>
			  <?php while(have_posts()) : the_post();
				  $post_id = get_the_ID();
				  $category = wp_get_object_terms( get_the_ID(), 'project-category', array('fields'=>'ids')); 
				  if(!empty($category))
				  {
					  $terms = get_term( $category[0], 'project-category' );  
					  $category = $terms->slug;
				  }
			   ?>
                  <div <?php post_class('post-list-item post format-standard'); ?>>
                  <div class="post-content">
                  	<?php the_content(); ?>
				  </div>
                  <div class="spacer-20"></div>
                  <?php if (has_tag()) { ?>
                  <div class="tagcloud"> 
                      <?php the_tags('', ''); ?>
                  </div>
                  <?php } ?>
                  </div>
              <?php endwhile; endif;?>
            <?php if ($tentered_options['switch_sharing'] == 1 && $tentered_options['share_post_types']['4'] == '1') { ?>
                <?php tentered_share_buttons(); ?>
            <?php } ?>
            <div class="np-links">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6 text-align-left">
                        <div class="pn-link prev-post-link"><?php echo previous_post_link('%link', '<span>'.esc_html__('Previous','tentered').'</span> %title'); ?></div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6 text-align-right">
                        <div class="pn-link next-post-link"><?php echo next_post_link('%link', '<span>'.esc_html__('Next','tentered').'</span>  %title'); ?></div>
                    </div>
                </div>
            </div>
          
            <!-- Post Comments -->
            <?php if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif; ?>
        </div>
        <?php if(is_active_sidebar($pageSidebar)) { ?>
            <!-- Sidebar -->
            <div class="col-md-<?php echo esc_attr($sidebar_column); ?>" id="sidebar-col">
                <?php dynamic_sidebar($pageSidebar); ?>
            </div>
            <?php } ?>
        </div>
    </div>
  </div>
    <?php // Related Posts
		query_posts(array('post_type'=>'project','post_status'=>'publish','project-category'=>$category,'posts_per_page'=>4,'post__not_in'=>array($post_id))); ?>
    <?php if(have_posts()) { ?>
    <div class="lgray-color padding-tb60 related-posts-footer">
    	<div class="container">
        	<h4 class="margin-40"><?php _e('RELATED PROJECTS', 'tentered'); ?></h4>
            <div class="row">
                <ul class="grid-holder isotope gallery-items" data-sort-id="gallery">
                    <?php while(have_posts()) : the_post(); ?>
                        <li class="col-md-3 col-sm-6 grid-item portfolio-item project-grid-item format-standard">
                            <div class="grid-item-inner">
                            	<div class="portfolio-image">
									<?php if(has_post_thumbnail())
                                    {
                                        the_post_thumbnail('tentered-600x400');
                                        $post_full_thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');
                                    }
                                    ?>
                                </div>
                                <div class="project-overlay">
                                    <div class="project-info"><div>
                                        <div class="action-icons">
                                            <a title="View Project" href="<?php the_permalink(); ?>"><i class="fa fa-link fa-2x"></i></a>
                                            <a class="magnific-image" href="<?php echo esc_url($post_full_thumbnail); ?>"><i class="fa fa-plus fa-2x"></i></a>
                                        </div>
                                        <a href="<?php the_permalink(); ?>" class="project-name"><?php the_title(); ?></a>
                                        <div class="project-categories">
                                        <?php $post = get_post();
                                            $categories = get_the_terms( $post->ID, 'project-category' );
                                            foreach( $categories as $category ) {
                                                echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a>';
                                            }
                                        ?>
                                        </div>
                                    </div></div>
                                </div>
                            </div>
                        </li>
                    <?php endwhile; ?>
                </ul>
            </div>
       	</div>
    </div>
    <?php } ?>
</div>
<!-- End Body Content -->
<?php get_footer(); ?>