<!DOCTYPE html>
<!--// OPEN HTML //-->
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php $options = get_option('tentered_options'); ?>
    <!-- Mobile Specific Metas
    ================================================== -->
	<?php $switch_responsive = (isset($options['switch-responsive']))?$options['switch-responsive']:'';
	$switch_zoom_pinch = (isset($options['switch-zoom-pinch']))?$options['switch-zoom-pinch']:'';
	if ($switch_responsive == 1){ ?>
        <?php if ($switch_zoom_pinch == 1){ ?>
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php } else { ?>
                <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">
        <?php } ?>
    <?php } ?>
	 <?php 
	 $space_beforeheader = (isset($options['space-before-head']))?$options['space-before-head']:'';
	 $SpaceBeforeHead = $space_beforeheader;
        echo esc_html($SpaceBeforeHead);
     ?>
    <?php //  WORDPRESS HEAD HOOK 
     wp_head(); ?>
</head>
<!--// CLOSE HEAD //-->
<body <?php body_class(); ?>>
<?php
   // Page Style Options
    $id = '';
	if(is_home()) { $id = get_option('page_for_posts'); }
	else { $id = get_the_ID(); }
	if(is_tax() || is_category() || is_tag() || is_archive()){
		echo '';
	} else {
	$content_top_padding = get_post_meta($id,'tentered_content_padding_top',true);
	$content_bottom_padding = get_post_meta($id,'tentered_content_padding_bottom',true);
	$content_width = get_post_meta($id,'tentered_content_width',true);
	$page_header_show = get_post_meta($id,'tentered_page_header_show',true);
	$page_social_show = get_post_meta($id,'tentered_page_social_share',true);
	$page_title_show = get_post_meta($id,'tentered_pages_title_show',true);
	$page_breadcrumb_show = get_post_meta($id,'tentered_pages_breadcrumb_show',true);
	$page_topbar_show = get_post_meta($id,'tentered_page_topbar_show',true);
	$header_image_overlay = get_post_meta($id,'tentered_header_image_overlay',true);
	$header_image_overlay_opacity = get_post_meta($id,'tentered_header_image_overlay_opacity',true);
	$pages_banner_text_color = get_post_meta($id,'tentered_pages_banner_text_color',true);
	$pages_title_alignment = get_post_meta($id,'tentered_pages_title_alignment',true);
	$page_body_bg_color = get_post_meta($id,'tentered_pages_body_bg_color',true);
	$page_body_bg_image = get_post_meta($id,'tentered_pages_body_bg_image',true);
	$page_body_bg_image_src = wp_get_attachment_image_src( $page_body_bg_image, 'full', '', array() );
	$page_body_bg_size = get_post_meta($id,'tentered_pages_body_bg_wide',true);
	if($page_body_bg_size==0){
		$page_body_bg_size_result = 'auto';
		$page_body_bg_size_attachment = 'scroll';
	}else{
		$page_body_bg_size_result = 'cover';
		$page_body_bg_size_attachment = 'fixed';
	}
	$page_body_bg_repeat = get_post_meta($id,'tentered_pages_body_bg_repeat',true);
	$page_content_bg_color = get_post_meta($id,'tentered_pages_content_bg_color',true);
	$page_content_bg_image = get_post_meta($id,'tentered_pages_content_bg_image',true);
	$page_content_bg_image_src = wp_get_attachment_image_src( $page_content_bg_image, 'full', '', array() );
	$page_content_bg_size = get_post_meta($id,'tentered_pages_content_bg_wide',true);
	if($page_content_bg_size==0){
		$page_content_bg_size_result = 'auto';
		$page_content_bg_size_attachment = 'scroll';
	}else{
		$page_content_bg_size_result = 'cover';
		$page_content_bg_size_attachment = 'fixed';
	}
	$page_content_bg_repeat = get_post_meta($id,'tentered_pages_content_bg_repeat',true);
	echo '<style type="text/css">';
		if($page_header_show == 0 && $page_header_show != ''){
			echo'.hero-area{display:none;}';	
		}else{
			echo'.hero-area{display:block;}';		
		}
		if($page_social_show == 0){
			echo'.social-share-bar{display:none;}';	
		}else{
			echo'.social-share-bar{display:block;}';		
		}
		if($page_title_show == 0 && $page_title_show != ''){
			echo'.page-banner h1, .page-banner-text{display:none;}';	
		}else{
			echo'.page-banner h1, .page-banner-text{display:block;}';		
		}
		if($page_breadcrumb_show == 0 && $page_breadcrumb_show != ''){
			echo'.page-banner .breadcrumb{display:none;}';	
		}else{
			echo'.page-banner h1 .breadcrumb{display:block;}';		
		}
		if($page_topbar_show == 0 && $page_topbar_show != ''){
			echo'.topbar{display:none;}';	
		}else{
			echo'.page-banner h1 .breadcrumb{display:block;}';		
		}
		if($header_image_overlay != ''){
			echo '.page-banner-image::before{background:'.$header_image_overlay.';}';
		}
		if($header_image_overlay_opacity != ''){
			echo '.page-banner-image::before{opacity:'.$header_image_overlay_opacity.';}';
		} else {
			echo '.page-banner-image::before{opacity:.4;}';	
		}
		if($pages_banner_text_color != ''){
			echo'.page-banner p, .page-banner h1, .page-banner-text, .page-banner-image .page-banner-text h1, .page-banner-image .page-banner-text p, .page-banner .breadcrumb, .page-banner .breadcrumb a{color:'.$pages_banner_text_color.';}';	
		}
		if($pages_title_alignment != ''){
			echo'.page-banner .page-banner-text h1, .page-banner .page-banner-text p, .page-banner-image .page-banner-text h1, .page-banner-image .page-banner-text p, .page-banner .breadcrumb{text-align:'.$pages_title_alignment.';}';	
		}
		echo '.content{';
			if($content_top_padding != ''){ echo 'padding-top:'.esc_attr($content_top_padding).'px;'; }
			if($content_bottom_padding != ''){ echo 'padding-bottom:'.esc_attr($content_bottom_padding).'px;'; }
		echo '}';
		if($content_width != ''){
		echo '
		.content .container{
			width:'.esc_attr($content_width).';
		}';
		}
		echo 'body.boxed{';
			if($page_body_bg_color != ''){ echo 'background-color:'.esc_attr($page_body_bg_color).';';}
			if($page_body_bg_image != ''){ echo 'background-image:url('.esc_attr($page_body_bg_image_src[0]).')!important;';}
			if($page_body_bg_image != ''){ echo 'background-size:'.esc_attr($page_body_bg_size_result).'!important;';}
			if($page_body_bg_image != ''){ echo 'background-repeat:'.esc_attr($page_body_bg_repeat).'!important;';}
			if($page_body_bg_image != ''){ echo 'background-attachment:'.esc_attr($page_body_bg_size_attachment).'!important;';}
		echo '}
		.content{';
			if($page_content_bg_color != ''){ echo 'background-color:'.esc_attr($page_content_bg_color).';';}
			if($page_content_bg_image != ''){ echo 'background-image:url('.esc_attr($page_content_bg_image_src[0]).');';}
			if($page_content_bg_image != ''){ echo 'background-size:'.esc_attr($page_content_bg_size_result).';';}
			if($page_content_bg_image != ''){ echo 'background-repeat:'.esc_attr($page_content_bg_repeat).';';}
			if($page_content_bg_image != ''){ echo 'background-attachment:'.esc_attr($page_content_bg_size_attachment).';';}
		echo '}';
	echo '</style>';
	}
?>
<div class="body"> 
<?php
$menu_locations = get_nav_menu_locations();
$show_topbar = (isset($options['show_topbar']))?$options['show_topbar']:0;
?>
<?php if($show_topbar == 1 ) { ?>
	<header class="topbar">
    	<div class="container">
            <div class="row">
              <div class="col-md-6 col-sm-6">
                <nav class="secondary-menu topbar-social">
                  <ul class="pull-left">
                    <?php
                      $socialSites = $options['header_social_links'];
                      foreach ($socialSites as $key => $value) {
                          $string = substr($key, 3);
                          if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
                              echo '<li class="'.esc_attr($string).'"><a href="mailto:' . esc_attr($value) . '"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
                          }
                          if (filter_var($value, FILTER_VALIDATE_URL)) {
                              echo '<li class="'.esc_attr($string).'"><a href="' . esc_url($value) . '" target="_blank"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
                          }
                          elseif($key == 'fa-skype' && $value != '' && $value != 'Enter Skype ID') {
                              echo '<li class="'.esc_attr($string).'"><a href="skype:' . esc_attr($value) . '?call"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
                          }
                      }
                  ?>
                  </ul>
                </nav>
              </div>
              <div class="col-md-6 col-sm-6">
                <nav class="secondary-menu">
                  <?php if (!empty($menu_locations['topbar-menu'])) { ?>
                      <?php wp_nav_menu(array('theme_location' => 'topbar-menu', 'container' => '','items_wrap' => '<ul id="%1$s" class="topbar-menu pull-right">%3$s</ul>')); ?>
                  <?php } ?>
                </nav>
              </div>
            </div>
          </div>
        </header>
      <?php } ?>
      <?php
	  	if(is_home()){
			$id = get_option('page_for_posts');
		} else {
			$id = get_the_ID();
		}
	  	$page_header_layout = get_post_meta($id,'tentered_page_header_style', true);
		if($page_header_layout != ''){
			$header_style = $page_header_layout;
		} else {
			$header_style = (isset($options['header_layout']))?$options['header_layout']:'1';
		}
		echo get_template_part('header-style', $header_style);
	  ?>