<?php
/* -----------------------------------------------------------------------------------
  Here we have all the custom functions for the theme
  Please be extremely cautious editing this file,
  When things go wrong, they tend to go wrong in a big way.
  You have been warned!
  ----------------------------------------------------------------------------------- */
/*
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link http://codex.wordpress.org/Theme_Development
 * @link http://codex.wordpress.org/Child_Themes
  ----------------------------------------------------------------------------------- */
define('TENTERED_THEME_PATH', get_template_directory_uri());
define('TENTERED_FILEPATH', get_template_directory());
/* -------------------------------------------------------------------------------------
  Load Translation Text Domain
  ----------------------------------------------------------------------------------- */
add_action('after_setup_theme', 'tentered_theme_setup');
function tentered_theme_setup() {
    load_theme_textdomain('tentered', TENTERED_FILEPATH . '/language');
}
/* -------------------------------------------------------------------------------------
  Menu option
  ----------------------------------------------------------------------------------- */
function tentered_register_menu() {
    	register_nav_menu('primary-menu', esc_html__('Primary Menu', 'tentered'));
		register_nav_menu('footer-menu', esc_html__('Footer Menu', 'tentered'));
		register_nav_menu('topbar-menu', esc_html__('Topbar Menu', 'tentered'));
}
add_action('init', 'tentered_register_menu');
/* -------------------------------------------------------------------------------------
  Set Max Content Width (use in conjuction with ".entry-content img" css)
  ----------------------------------------------------------------------------------- */
if (!isset($content_width))
    $content_width = 680;
/* -------------------------------------------------------------------------------------
  Configure WP2.9+ Thumbnails & gets the current post type in the WordPress Admin
  ----------------------------------------------------------------------------------- */
add_action( 'after_setup_theme', 'tentered_theme_support_setup' );
if ( !function_exists( 'tentered_theme_support_setup' ) ) {
	function tentered_theme_support_setup() {
		add_theme_support('post-formats', array(
			'video', 'image', 'gallery', 'audio'
		));
		add_theme_support('post-thumbnails');
		add_theme_support( 'title-tag' );
		add_theme_support('automatic-feed-links');
		set_post_thumbnail_size(958, 9999);
		//Mandatory
		add_image_size('tentered-600x400','600','400',true);
		add_image_size('tentered-400x600','400','600',true);
		add_image_size('tentered-200x200','200','200',true);
		add_image_size('tentered-450x400','450','400',true);
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
}
/* -------------------------------------------------------------------------------------
  Custom Gravatar Support
  ----------------------------------------------------------------------------------- */
if (!function_exists('tentered_custom_gravatar')) {
    function tentered_custom_gravatar($avatar_defaults) {
        $tentered_avatar = get_template_directory_uri() . '/images/img_avatar.png';
        $avatar_defaults[$tentered_avatar] = 'Custom Gravatar (/images/img_avatar.png)';
        return $avatar_defaults;
    }
    add_filter('avatar_defaults', 'tentered_custom_gravatar');
}
/* -------------------------------------------------------------------------------------
  Load Theme Options
  ----------------------------------------------------------------------------------- */
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/tentered-includes.php' );
require_once( trailingslashit( get_template_directory() ). '/tentered-framework/barebones-config.php' );

/* -------------------------------------------------------------------------------------
  Excerpt More and  length
  ----------------------------------------------------------------------------------- */

if (!function_exists('tentered_excerpt')) {
    function tentered_excerpt($limit = 50, $closing =' ') {
		if ( get_the_content()!="" || get_the_excerpt()!="" ) {
        return '<p>' . wp_trim_words(get_the_excerpt(), $limit).$closing.'</p>';
		} else {
        return '';
		}
    }
}
/* -------------------------------------------------------------------------------------
  For Pagination
  ----------------------------------------------------------------------------------- */
if (!function_exists('tentered_pagination')) {
    function tentered_pagination() {
		$pages = get_the_posts_pagination( array(
		'prev_text'	=> '<i class="fa fa-chevron-left"></i>',
		'next_text'	=> '<i class="fa fa-chevron-right"></i>',
		'type'      => 'list',
    ));
   	echo '<div class="pagination-wrap">'; 
	echo $pages;
    echo '</div>';
    }
}
/* 	Comment Styling
  /*----------------------------------------------------------------------------------- */
if (!function_exists('tentered_comment')) {
    function tentered_comment($comment, $args, $depth) {
        $isByAuthor = false;
        if ($comment->comment_author_email == get_the_author_meta('email')) {
            $isByAuthor = true;
        }
        $GLOBALS['comment'] = $comment;
        ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
            <div class="post-comment-block">
                <div id="comment-<?php comment_ID(); ?>">
                    <?php echo get_avatar($comment, $size = '80','', '',  array('class'=>'img-thumbnail')); ?>
                    <div class="post-comment-content">
						<?php
						 echo preg_replace('/comment-reply-link/', 'comment-reply-link pull-right btn btn-primary btn-xs', get_comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => 'REPLY'))), 1);
					   echo '<h5 class="comment-author"><span class="comment-type">'.get_comment_type('', 'trackback', 'pingback').' </span><a href="'.get_comment_author_url().'">' . get_comment_author() .'</a><span class="comment-author">'.esc_html__(' says','tentered').'</span></h5>';
						?>            
						<span class="meta-data">
							<?php
							echo get_comment_date();
							esc_html_e(' at ', 'tentered');
							echo get_comment_time();
							?>
						</span>
						<?php if ($comment->comment_approved == '0') : ?>
							<em class="moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'tentered') ?></em>
							<br />
						<?php endif; ?>
						<div class="comment-text post-content">
							<?php comment_text() ?>
						</div>
                	</div>
            	</div>
			</div>
        <?php
        }
    }
// Custom One Pager Menu
class Tentered_Walker extends Walker_Nav_Menu
{
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
        global $wp_query;
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $class_names = $value = '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class_names = ' class="' . esc_attr( $class_names ) . '"';

        $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
        $attributes .= ' data-id="'. esc_attr( $item->object_id        ) .'"';
        $attributes .= ' data-slug="'. esc_attr(  basename(get_permalink($item->object_id )) ) .'"';
        $attributes .= ' data-home-url=""';



        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
        $item_output .= '</a>'; /* This is where I changed things. */
        $item_output .= $args->after;

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }
}
//Add custom class on body tag
function tentered_add_body_class( $classes ) {
	$options = get_option('tentered_options');
    /** Theme layout design * */
	if(is_home()){
		$id = get_option('page_for_posts');
	} else {
		$id = get_the_ID();
	}
	$page_layout = get_post_meta($id,'tentered_page_layout', true);
	if($page_layout != ''){
		$bodyClass = $page_layout;
	} else {
		$bodyClass = (isset($options['site_layout'])&&$options['site_layout'] == 'boxed') ? ' boxed' : '';
	}
	$page_header_layout = get_post_meta($id,'tentered_page_header_style', true);
	if($page_header_layout != ''){
		$header_style = $page_header_layout;
	} else {
		$header_style = (isset($options['header_layout']))?$options['header_layout']:'1';
	}
    $classes[] = $bodyClass;
	$classes[] = 'header-style'.$header_style;
    return $classes;
}
add_filter( 'body_class', 'tentered_add_body_class', 10, 3 );

//Add inline style for theme styling
function tentered_styles_method() {
    wp_enqueue_style(
        'custom-style',
        get_template_directory_uri() . '/css/custom.css'
		, array()
    );
	$options = get_option('tentered_options');
	$style ='';
    /** Boxed layout custom css * */
   	if(isset($options['site_layout'])&&$options['site_layout'] == 'boxed'){
        if (!empty($options['upload-repeatable-bg-image']['id'])) {
        $style = 'body{background-image:url(' . $options['upload-repeatable-bg-image']['url'] . '); background-repeat:repeat; background-size:auto;}';
    } else if (!empty($options['full-screen-bg-image']['id'])) {
        $style = 'body{background-image:url(' . $options['full-screen-bg-image']['url'] . '); background-repeat: no-repeat; background-size:cover;}';
    }
       else if(!empty($options['repeatable-bg-image'])) {
        $style = 'body{background-image:url(' . get_template_directory_uri() . '/images/patterns/' . $options['repeatable-bg-image'] . '); background-repeat:repeat; background-size:auto;}';
    }
    }
	
   	wp_add_inline_style( 'custom-style', $style );
}
add_action( 'wp_enqueue_scripts', 'tentered_styles_method' );


// Permalink Structure Options
$options = get_option('tentered_options');
// Project
$project_post_slug = (isset($options['project_post_slug']))?$options['project_post_slug']:'';
if($project_post_slug == ''){
	$project_post_slug = esc_html__('project','tentered');
}
$project_post_title = (isset($options['project_post_title']))?$options['project_post_title']:'';
if($project_post_title == ''){
	$project_post_title = esc_html__('Portfolio','tentered');
}
$project_post_all = (isset($options['project_post_all']))?$options['project_post_all']:'';
if($project_post_all == ''){
	$project_post_all = esc_html__('Projects','tentered');
}
$project_post_categories = (isset($options['project_post_categories']))?$options['project_post_categories']:'';
if($project_post_categories == ''){
	$project_post_categories = esc_html__('Project Categories','tentered');
}
$project_category_slug = (isset($options['project_category_slug']))?$options['project_category_slug']:'';
if($project_category_slug == ''){
	$project_category_slug = esc_html__('project-category','tentered');
}
$disable_project_archive = (isset($options['disable_project_archive']))?$options['disable_project_archive']:0;
$project_archive = $disable_project_archive ? false : true;
// Service
$service_post_slug = (isset($options['service_post_slug']))?$options['service_post_slug']:'';
if($service_post_slug == ''){
	$service_post_slug = esc_html__('service','tentered');
}
$service_post_title = (isset($options['service_post_title']))?$options['service_post_title']:'';
if($service_post_title == ''){
	$service_post_title = esc_html__('Services','tentered');
}
$service_post_all = (isset($options['service_post_all']))?$options['service_post_all']:'';
if($service_post_all == ''){
	$service_post_all = esc_html__('Services','tentered');
}
$service_post_categories = (isset($options['service_post_categories']))?$options['service_post_categories']:'';
if($service_post_categories == ''){
	$service_post_categories = esc_html__('Service Categories','tentered');
}
$service_category_slug = (isset($options['service_category_slug']))?$options['service_category_slug']:'';
if($service_category_slug == ''){
	$service_category_slug = esc_html__('service-category','tentered');
}
$disable_service_archive = (isset($options['disable_service_archive']))?$options['disable_service_archive']:0;
$service_archive = $disable_service_archive ? false : true;
// Team
$team_post_slug = (isset($options['team_post_slug']))?$options['team_post_slug']:'';
if($team_post_slug == ''){
	$team_post_slug = esc_html__('team','tentered');
}
$team_post_title = (isset($options['team_post_title']))?$options['team_post_title']:'';
if($team_post_title == ''){
	$team_post_title = esc_html__('Team','tentered');
}
$team_post_all = (isset($options['team_post_all']))?$options['team_post_all']:'';
if($team_post_all == ''){
	$team_post_all = esc_html__('Team','tentered');
}
$team_post_categories = (isset($options['team_post_categories']))?$options['team_post_categories']:'';
if($team_post_categories == ''){
	$team_post_categories = esc_html__('Team Categories','tentered');
}
$team_category_slug = (isset($options['team_category_slug']))?$options['team_category_slug']:'';
if($team_category_slug == ''){
	$team_category_slug = esc_html__('team-category','tentered');
}
$disable_team_archive = (isset($options['disable_team_archive']))?$options['disable_team_archive']:0;
$team_archive = $disable_team_archive ? false : true;
// Testimonials
$testimonial_post_slug = (isset($options['testimonial_post_slug']))?$options['testimonial_post_slug']:'';
if($testimonial_post_slug == ''){
	$testimonial_post_slug = esc_html__('testimonial','tentered');
}
$testimonial_post_title = (isset($options['testimonial_post_title']))?$options['testimonial_post_title']:'';
if($testimonial_post_title == ''){
	$testimonial_post_title = esc_html__('Testimonials','tentered');
}
$testimonial_post_all = (isset($options['testimonial_post_all']))?$options['testimonial_post_all']:'';
if($testimonial_post_all == ''){
	$testimonial_post_all = esc_html__('Testimonials','tentered');
}
$testimonial_post_categories = (isset($options['testimonial_post_categories']))?$options['testimonial_post_categories']:'';
if($testimonial_post_categories == ''){
	$testimonial_post_categories = esc_html__('Testimonial Categories','tentered');
}
$testimonial_category_slug = (isset($options['testimonial_category_slug']))?$options['testimonial_category_slug']:'';
if($testimonial_category_slug == ''){
	$testimonial_category_slug = esc_html__('testimonial-category','tentered');
}
$disable_testimonial_archive = (isset($options['disable_testimonial_archive']))?$options['disable_testimonial_archive']:0;
$testimonial_archive = $disable_testimonial_archive ? false : true;

// Tentered Custom CSS Injection for One Page Website Page Template
add_action('wp_head', 'tentered_custom_css_injection');

function tentered_custom_css_injection() {
	if ( ! is_single() ) {
		$id = get_the_ID(); // here you should change id to ID, of your post/page in loop
		if ( $id ) {
			$shortcodes_custom_css = get_post_meta( $id, '_wpb_shortcodes_custom_css', true );
			if ( ! empty( $shortcodes_custom_css ) ) {
				echo '<style type="text/css" data-type="vc_shortcodes-custom-css-'.$id.'">';
				echo $shortcodes_custom_css;
				echo '</style>';
			}
		}
	}
}

// Ajaxify header cart module
add_filter( 'woocommerce_add_to_cart_fragments', function($fragments) {
    ob_start();
    ?>
    <span class="cart-contents">
        <?php echo WC()->cart->get_cart_contents_count(); ?>
    </span>
    <?php $fragments['span.cart-contents'] = ob_get_clean();
    return $fragments;
} );

add_filter( 'woocommerce_add_to_cart_fragments', function($fragments) {
    ob_start();
    ?>
    <div class="header-quickcart">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['div.header-quickcart'] = ob_get_clean();
    return $fragments;
} );
?>