<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
/*
 *
 * 	solicitor Framework Theme Functions
 * 	------------------------------------------------
 * 	solicitor Framework v1.0
 * 	Copyright solicitor  2017 - http://www.imithemes.com/
 *	
 */
/* MAINTENANCE MODE
  ================================================== */
if (!function_exists('solicitor_maintenance_mode')) {
    function solicitor_maintenance_mode() {
        $options = get_option('solicitor_options');
        $custom_logo = $custom_logo_output = $maintenance_mode = "";
        if (isset($options['custom_admin_login_logo'])) {
            $custom_logo = $options['custom_admin_login_logo'];
        }
				else
				{
					$custom_logo = array('url'=>'');
				}
        $custom_logo_output = '<img src="' . $custom_logo['url'] . '" alt="maintenance" style="height: 62px!important;margin: 0 auto; display: block;" />';
        if (isset($options['enable_maintenance'])) {
            $maintenance_mode = $options['enable_maintenance'];
        } else {
            $maintenance_mode = false;
        }
        if ($maintenance_mode) {
            if (!current_user_can('edit_themes') || !is_user_logged_in()) {
                wp_die($custom_logo_output . '<p style="text-align:center">' . esc_html__('We are currently in maintenance mode, please check back shortly.', 'solicitor') . '</p>', esc_html__('Maintenance Mode', 'solicitor'));
            }
        }
    }
    add_action('get_header', 'solicitor_maintenance_mode');
}

/* CUSTOM LOGIN LOGO
  ================================================== */
if (!function_exists('solicitor_custom_login_logo')) {
    function solicitor_custom_login_logo() {
        $options = get_option('solicitor_options');
        $custom_logo = array('url'=>'');
        if (isset($options['custom_admin_login_logo'])) {
            $custom_logo = $options['custom_admin_login_logo'];
        }
		echo '<style type="text/css">
			.login h1 a { background-image:url(' . $custom_logo['url'] . ') !important; background-size: auto !important; width: auto !important; height: 95px !important; }
		</style>';
    }
    add_action('login_head', 'solicitor_custom_login_logo');
}
function solicitor_post_excerpt_by_id( $post_id ) {
    global $post;
    $post = get_post( $post_id );
    setup_postdata( $post );
    $the_excerpt = get_the_excerpt();
    wp_reset_postdata();
    return $the_excerpt;
}

/* CUSTOM CSS OUTPUT
  ================================================== */
if (!function_exists('solicitor_custom_styles')) {
    function solicitor_custom_styles() {
        $options = get_option('solicitor_options');
        
        // OPEN STYLE TAG
        echo '<style type="text/css">' . "\n";
        // Custom CSS
        $custom_css = (isset($options['custom_css']))?$options['custom_css']:'';
				$theme_color_type = (isset($options['theme_color_type']))?$options['theme_color_type']:array('');
        if ($theme_color_type[0] == 1) {
            $primaryColor = $options['primary_theme_color'];
            echo '#info-content:before,#service-blocks .accordion-body a:hover,.accent-color,.arrow-upwards,.basic-link,.blog-grid-item .meta-data,.blog-list-item .meta-data,.blog-list-item .meta-data a,.blog-list-item h4 a:hover,.btn-link,.btn-primary .badge,.btn-primary.btn-ghost,.dd-menu>li>a:hover,.featured-block-info .subtitle,.flex-caption-text a.ico:hover,.grid-item h4 a:hover,.header-style3 #info-content>li i,.icon-block,.icon-box-inline span,.icon-box.ibox-border .ibox-icon i,.icon-box.ibox-border .ibox-icon img,.icon-box.ibox-border .ibox-icon span,.icon-box.ibox-plain .ibox-icon i,.icon-box.ibox-plain .ibox-icon img,.icon-box.ibox-plain .ibox-icon span,.list-group-item a:hover,.nav-np .next:hover,.nav-np .prev:hover,.nav-pills>.active>a>.badge,.next-prev-post a:hover h5,.pages-sub-menu li.active .fa-angle-right,.pagination>li>a:focus,.pagination>li>a:hover,.pagination>li>span:focus,.pagination>li>span:hover,.post .post-title a:hover,.post-actions .comment-count a:hover,.pricing-column .features a:hover,.pricing-column h3,.single-post .blog-grid-item .meta-data a,.social-icons a:hover,.sort-source li.active a,.text-primary,.widget li .meta-data a:hover,a,a.list-group-item.active>.badge,a:hover,address strong,blockquote:before,ol.breadcrumb a,p.drop-caps:first-child:first-letter,ul.angles>li>i,ul.carets>li>i,ul.checks>li>i,ul.chevrons>li>i,ul.icons>li>i{
				color:'.esc_attr($primaryColor).';
			}
			#back-to-top:hover,#info-content,#info-toggle,#menu-toggle:hover,.accent-bg,.accordion-heading .accordion-toggle.active,.bootstrap-select.btn-group .dropdown-menu li.selected a,.btn-primary,.btn-primary.disabled,.btn-primary.disabled.active,.btn-primary.disabled:active,.btn-primary.disabled:focus,.btn-primary.disabled:hover,.btn-primary[disabled],.btn-primary[disabled].active,.btn-primary[disabled]:active,.btn-primary[disabled]:focus,.btn-primary[disabled]:hover,.carousel-indicators .active,.dd-menu>li ul,.dropdown-menu>.active>a,.dropdown-menu>.active>a:focus,.dropdown-menu>.active>a:hover,.event-grid-time,.featured-block-info .subtitle:before,.flex-control-nav a.flex-active,.flex-control-nav a:hover,.ibox-border.ibox-effect.ibox-dark .ibox-icon i:after,.ibox-border.ibox-effect.ibox-dark .ibox-icon span:after,.ibox-effect.ibox-dark .ibox-icon i:hover,.ibox-effect.ibox-dark .ibox-icon span:hover,.ibox-effect.ibox-dark:hover .ibox-icon i,.ibox-effect.ibox-dark:hover .ibox-icon span,.icon-box .ibox-icon i,.icon-box .ibox-icon img,.icon-box .ibox-icon span,.icon-box.ibox-dark.ibox-outline:hover .ibox-icon i,.icon-box.ibox-dark.ibox-outline:hover .ibox-icon span,.icon-box.icon-box-style1:hover .ico,.label-primary,.media-box .media-box-wrapper,.nav-pills>li.active>a,.nav-pills>li.active>a:focus,.nav-pills>li.active>a:hover,.notice-bar .btn:before,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.panel-primary>.panel-heading,.parallax-light .subhead:before,.parallax-overlay:before,.pricing-column.highlight h3,.progress-bar-primary,.social-share-bar.share-buttons-tc li a,.subhead.accent-color:before,.tagcloud a:hover,.timeline>li>.timeline-badge,.woocommerce #content input.button.alt:active,.woocommerce #content input.button.alt:hover,.woocommerce #respond input#submit.alt:active,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:active,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:active,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:active,.woocommerce input.button.alt:hover,.woocommerce-page #content input.button.alt:active,.woocommerce-page #content input.button.alt:hover,.woocommerce-page #respond input#submit.alt:active,.woocommerce-page #respond input#submit.alt:hover,.woocommerce-page a.button.alt:active,.woocommerce-page a.button.alt:hover,.woocommerce-page button.button.alt:active,.woocommerce-page button.button.alt:hover,.woocommerce-page input.button.alt:active,.woocommerce-page input.button.alt:hover,.wpcf7-form .wpcf7-submit,a.list-group-item.active,a.list-group-item.active:focus,a.list-group-item.active:hover,blockquote:after,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary.active,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary:hover,p.drop-caps.secondary:first-child:first-letter{
  				background-color: '.esc_attr($primaryColor).';
			}
			@media only screen and (max-width:992px){.header-style3 #info-content{
				background-color: '.esc_attr($primaryColor).';
			}}
			.btn-primary.btn-ghost:hover{background-color:#616997!important;border-color:#616997!important}.btn-primary.active,.btn-primary:active,.btn-primary:focus,.btn-primary:hover,.open .dropdown-toggle.btn-primary{
				background:'.esc_attr($primaryColor).';
				opacity:.9
			}
			.woocommerce #content input.button.alt,.woocommerce #respond input#submit.alt,.woocommerce .widget_layered_nav ul li.chosen a,.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce span.onsale,.woocommerce-page #content input.button.alt,.woocommerce-page #respond input#submit.alt,.woocommerce-page .widget_layered_nav ul li.chosen a,.woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle,.woocommerce-page a.button.alt,.woocommerce-page button.button.alt,.woocommerce-page input.button.alt,.woocommerce-page span.onsale,.wpcf7-form .wpcf7-submit,p.demo_store{
  				background: '.esc_attr($primaryColor).';
			}
			.btn-primary.btn-ghost,.btn-primary.btn-transparent,.icon-box-inline span,.icon-box.ibox-border .ibox-icon,.icon-box.ibox-dark.ibox-outline:hover .ibox-icon,.icon-box.ibox-outline .ibox-icon,.icon-box.icon-box-style1 .ico,.nav .open>a,.nav .open>a:focus,.nav .open>a:hover,.notice-bar .flexslider,.owl-theme .owl-controls.clickable .owl-page:hover span,.owl-theme .owl-page.active span,.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover,.panel-primary,.panel-primary>.panel-heading,.tagcloud a:hover,a.list-group-item.active,a.list-group-item.active:focus,a.list-group-item.active:hover,a.thumbnail.active,a.thumbnail:focus,a.thumbnail:hover{
				border-color:'.esc_attr($primaryColor).';
			}
			.content .widget_nav_menu ul li a:hover,.content .widget_nav_menu ul li.current-menu-item a,.panel-primary>.panel-heading+.panel-collapse .panel-body,.woocommerce .woocommerce-info,.woocommerce .woocommerce-message,.woocommerce-page .woocommerce-info,.woocommerce-page .woocommerce-message{
				border-top-color:'.esc_attr($primaryColor).';
			}
			.alert-primary,.widgettitle{
				border-left-color:'.esc_attr($primaryColor).';
			}
			.blog-grid-item .meta-data a,.blog-list-item .meta-data a,.nav-tabs>li.active>a,.nav-tabs>li.active>a:focus,.nav-tabs>li.active>a:hover,.panel-primary>.panel-footer+.panel-collapse .panel-body,.template-submenu li.current_page_item a{
				border-bottom-color:'.esc_attr($primaryColor).';
			}
			.ibox-border.ibox-effect.ibox-dark .ibox-icon i:hover,.ibox-border.ibox-effect.ibox-dark .ibox-icon span:hover,.ibox-border.ibox-effect.ibox-dark:hover .ibox-icon i,.ibox-border.ibox-effect.ibox-dark:hover .ibox-icon span{
				box-shadow:0 0 0 1px '.esc_attr($primaryColor).';
			}
			.ibox-effect.ibox-dark .ibox-icon i:after,.ibox-effect.ibox-dark .ibox-icon span:after{
				box-shadow:0 0 0 2px '.esc_attr($primaryColor).';
			}';
		}
		$site_width = (isset($options['site_width']))?$options['site_width']:'1170';
		$site_width_spaced=!empty($site_width)?$site_width+30:1200;
		$site_width_half=$site_width_spaced/2;
		$SiteMinHeight = (isset($options['content_min_height']))?$options['content_min_height']:'400';
		$footer_wide_width = (isset($options['full_width_footer']))?$options['full_width_footer']:'';
		$directions_arrows = (isset($options['directions_arrows']))?$options['directions_arrows']:'';
		$Mobilenavalign = (isset($options['mobile_dd_text_align']))?$options['mobile_dd_text_align']:'';
		
		
		echo '@media (min-width:1200px){.container{width:'.$site_width.'px;}}
		body.boxed .body{max-width:'.$site_width_spaced.'px}
		body.boxed .notice-bar .container{max-width:'.$site_width.'px}
		@media (min-width: 1200px) {body.boxed .site-header{width:'.$site_width_spaced.'px; margin-left:-'.$site_width_half.'px;}}
		';
		
		if ($SiteMinHeight !== '')
		{
			echo '.content{min-height:'.esc_attr($SiteMinHeight).'px}';
		}
		if (isset($options['content_wide_width'])&&$options['content_wide_width'] == 1)
		{
			echo '.content .container{width:100%;}';
		}
		if (isset($options['inner_page_header_display'])&&$options['inner_page_header_display'] == 0)
		{
			echo '.hero-area{display:none!important;}';
		}
		if (isset($options['inner_page_header_title'])&&$options['inner_page_header_title'] == 0)
		{
			echo '.page-header h1, .page-header .breadcrumb{display:none!important;}';
		}
		if (isset($options['inner_page_header_min_height'])&&$options['inner_page_header_min_height'] != '')
		{
			echo '.page-header, .page-header-text > div{height:'.$options['inner_page_header_min_height'].'px;}';
		}
		if (isset($options['header_wide_width'])&&$options['header_wide_width'] == 1)
		{
			echo '.header-wrapper .container{width:100%;}';
		}
		if (isset($options['nav_directions_arrows'])&&$options['nav_directions_arrows'] == 0)
		{
			echo '.dd-menu > li > a > i, .dd-menu > li > ul > li > a > i{display:none;}';
		}
		if ($Mobilenavalign != '')
		{
			echo '
@media only screen and (max-width: 992px) {.main-navigation > ul > li > a, .main-navigation > ul > li > ul li > a, .main-navigation .megamenu-container .megamenu-sub-title{text-align:'.esc_attr($Mobilenavalign).'!important;}}';
		}
		if (isset($options['mobile_menu_drop_top_position'])&&$options['mobile_menu_drop_top_position'] != '')
		{
			echo '
@media only screen and (max-width: 992px) {.main-navigation{top:'.esc_attr($options['mobile_menu_drop_top_position']).'px!important;}}';
		}
		if (isset($options['mobile_menu_background']['background-color'])&&$options['mobile_menu_background']['background-color'] != '')
		{
			echo '
@media only screen and (max-width: 992px) {.main-navigation, .header-style3 .main-navigation{background:'.esc_attr($options['mobile_menu_background']['background-color']).';}}';
		}
		if ($footer_wide_width == 1) {
			echo '.site-footer > .container, .site-footer-bottom > .container{width:100%;}';
		}
		if (isset($options['footer_bottom_enable'])&&$options['footer_bottom_enable'] == 0)
		{
			echo '.footer-row3{display:none;}';
		}
		if (isset($options['sidebar_position'])&&$options['sidebar_position'] == 2)
		{
			echo ' #content-col, #sidebar-col{float:right;}';
		}
		
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['regular'])&&$options['mobile_menu_color']['regular'] != '') {
			echo '@media only screen and (max-width: 992px) {.dd-menu > li > a, .dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a{color:'.$options['mobile_menu_color']['regular'].';}}';
		}
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['hover'])&&$options['mobile_menu_color']['hover'] != '') {
			echo '@media only screen and (max-width: 992px) {.dd-menu > li > a:hover, .dd-menu > li > ul > li > a:hover, .dd-menu > li > ul > li > ul > li > a:hover{color:'.$options['mobile_menu_color']['hover'].';}}';
		}
		if (isset($options['mobile_menu_color'])&&isset($options['mobile_menu_color']['active'])&&$options['mobile_menu_color']['active'] != '') {
			echo '@media only screen and (max-width: 992px) {.dd-menu > li > a:active, .dd-menu > li > ul > li > a:active, .dd-menu > li > ul > li > ul > li > a:active{color:'.$options['mobile_menu_color']['active'].';}}';
		}
		if (isset($options['mobile_menu_border']['border-bottom'])&&$options['mobile_menu_border']['border-bottom'] != '') {
			echo '@media only screen and (max-width: 992px) {.dd-menu > li > a, .dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a{border-bottom-width:'.$options['mobile_menu_border']['border-bottom'].';border-bottom-style:'.$options['mobile_menu_border']['border-style'].';border-bottom-color:'.$options['mobile_menu_border']['border-color'].';}}';
		}
        // USER STYLES
        if ($custom_css) {
            echo "\n" . '/*========== User Custom CSS Styles ==========*/' . "\n";
            echo ''.$custom_css;
        }
        // CLOSE STYLE TAG
        echo "</style>" . "\n";
    }
    add_action('wp_head', 'solicitor_custom_styles');
}
// STAFF SOCIAL ICONS
if (!function_exists('solicitor_social_staff_icon')) {
function solicitor_social_staff_icon() {
        $output = '';
        $staff_icons = get_post_meta(get_the_ID(), 'solicitor_social_icon_list', false);
        if (!empty($staff_icons[0])) {
            $output.='<ul class="social-icons">';
            if (!empty($staff_icons[0])) {
                foreach ($staff_icons[0] as $list => $values) {
                    if (!empty($values[1])) {
                        $className = preg_replace('/\s+/', '-', strtolower($values[0]));
                        $className = 'fa fa-' . $className;
                        $output.='<li class="'.$values[0].'"><a href="' . $values[1] . '" target ="_blank"><i class="' . $className . '"></i></a></li>';
                    }
                }
            }
            $output.='</ul>';
        }
        return $output;
    }
}
//Event Recurring Date/Time
function solicitor_afterSavePost()
{
	if(isset($_GET['post']))
	 { 
	 $postId = $_GET['post'];
	$post_type = get_post_type($postId);
	if($post_type=='event')
	{
		
		$event_start_date = get_post_meta($postId, 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta($postId, 'solicitor_event_end_dt', true);
		$event_start_date_unix = strtotime($event_start_date);
		$event_end_date_unix = strtotime($event_end_date);
		$event_frequency_type = get_post_meta($postId, 'solicitor_event_frequency_type', true);
		$fixed_date_frequency = get_post_meta($postId, 'solicitor_event_frequency', true);
		$event_weekday_frequency_week = get_post_meta($postId, 'solicitor_event_day_month', true);
		$event_weekday_frequency_day = get_post_meta($postId, 'solicitor_event_week_day', true);
		$event_recur_count = get_post_meta($postId, 'solicitor_event_frequency_count', true);
		$event_multiple_type = get_post_meta($postId, 'solicitor_event_multiple_type', true);
		$event_multiple_dates = get_post_meta($postId, 'solicitor_event_multiple_dates', true);
		if($event_frequency_type==1)
		{
			if($event_recur_count>0)
			{
				$days = $fixed_date_frequency*$event_recur_count;
				$update_date = strtotime("+".$days." days", strtotime($event_start_date));
				update_post_meta($postId,'solicitor_event_frequency_end',date('Y-m-d', $update_date));
			}
			else
			{
				
			}
		}
		elseif($event_frequency_type==2)
		{
				$update_date = strtotime("+".$event_recur_count." month", strtotime($event_start_date));
				update_post_meta($postId,'solicitor_event_frequency_end',date('Y-m-d', $update_date));
		}
		elseif($event_multiple_type==1)
		{
			$mostRecent= 0;
			foreach($event_multiple_dates as $date)
			{ 
				$curDate = strtotime($date);
				if ($curDate > $mostRecent) {
					 $mostRecent = $curDate;
				}
			}
			update_post_meta($postId,'solicitor_event_frequency_end',date('Y-m-d', $mostRecent));
		}
		else
		{
			update_post_meta($postId,'solicitor_event_frequency_end',date('Y-m-d', $event_end_date_unix));
		}
		
	} 
	}
}
solicitor_afterSavePost();
if (!function_exists('solicitor_dateDiff')) {
function solicitor_dateDiff($start, $end) {
  $start_ts = strtotime($start);
  $end_ts = strtotime($end);
  $diff = $end_ts - $start_ts;
  return round($diff / 86400);
}
}
if(!function_exists('solicitor_recur_events'))
{
	function solicitor_recur_events($status="future", $term=array())
	{
		$solicitor_options = get_option('solicitor_options');
		$show_event = (isset($solicitor_options['countdown_timer']))?$solicitor_options['countdown_timer']:'0';
		$offset = get_option('timezone_string');
		if($offset=='') 
		{ 
			$offset = "Australia/Melbourne"; 
		}
		date_default_timezone_set($offset);
		
		$today = date('Y-m-d');
				if(!empty($term))
				{ 
				$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'event-category' =>$term, 'meta_key' => 'solicitor_event_start_dt', 'meta_query' => array(array('key' => 'solicitor_event_frequency_end', 'value' => $today, 'compare' => '>=')), 'orderby' => 'meta_value', 'order' => 'ASC', 'posts_per_page' => -1)); 
				}
				else
				{
					$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'meta_key' => 'solicitor_event_start_dt', 'meta_query' => array(array('key' => 'solicitor_event_frequency_end', 'value' => $today, 'compare' => '>=')), 'orderby' => 'meta_value', 'order' => 'ASC', 'posts_per_page' => -1)); 
				}
		$count = 1;
		$all_events = array();
		if($event_list->have_posts()):while($event_list->have_posts()):$event_list->the_post();
		//Get all meta values of event
		$event_start_date = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta(get_the_ID(), 'solicitor_event_end_dt', true);
		$event_start_date_unix = strtotime($event_start_date);
		$event_end_date_unix = strtotime($event_end_date);
		$event_frequency_type = get_post_meta(get_the_ID(), 'solicitor_event_frequency_type', true);
		$fixed_date_frequency = get_post_meta(get_the_ID(), 'solicitor_event_frequency', true);
		$event_weekday_frequency_week = get_post_meta(get_the_ID(), 'solicitor_event_day_month', true);
		$event_weekday_frequency_day = get_post_meta(get_the_ID(), 'solicitor_event_week_day', true);
		$event_recur_count = get_post_meta(get_the_ID(), 'solicitor_event_frequency_count', true);
		$event_multiple_type = get_post_meta(get_the_ID(), 'solicitor_event_multiple_type', true);
		$event_multiple_dates = get_post_meta(get_the_ID(), 'solicitor_event_multiple_dates', true);
		$event_multiple_dates = (!empty($event_multiple_dates))?$event_multiple_dates:array();
		$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
		if($days_total<=0)
		{
			if($event_start_date_unix>date('U'))
			{
				$all_events[$event_start_date_unix] = get_the_ID();
			}
		}
		//Run condition basis on event recur type
		//If recur type is fixed date
		if($event_frequency_type==1&&$days_total<1)
		{
			if($event_recur_count>0)
			{
				if($show_event==0)
				{
					$this_event_start_date = $event_start_date;
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
					$this_event_start_date = date('Y-m-d G:i', $get_updated_date);
				}
				for($i=0; $i<$event_recur_count; $i++)
				{
					$event_new_date = strtotime("+".$fixed_date_frequency." days", strtotime($this_event_start_date));
					if(!in_array(date('Y-m-d', $event_new_date), $event_multiple_dates)&&$event_new_date>=date('U'))
					{
					if (array_key_exists($event_new_date, $all_events))
					{
						if($event_new_date>date('U'))
						{
							$all_events[$event_new_date+1] = get_the_ID();
						}
					}
					else
					{
						if($event_new_date>date('U'))
						{
							$all_events[$event_new_date] = get_the_ID();
						}
					}
					}
					$this_event_start_date = date('Y-m-d G:i', $event_new_date);
				}
			}
		}
		//If recur type is week day
		elseif($event_frequency_type==2&&$days_total<1)
		{
			if($show_event==0)
				{
					$get_updated_date = strtotime($event_start_date);
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
				}
			for($i=1; $i<=$event_recur_count; $i++)
			{
				$eventDate = strtotime( date('Y-m-01', $get_updated_date) );
				$event_start_date = strtotime("+".$i." month", $eventDate);
				$next_month = date('F',$event_start_date);
				$next_event_year = date('Y',$event_start_date);
				$start_date_time = date('G:i', $get_updated_date);
				$all_events_add = date('Y-m-d '.$start_date_time, strtotime($event_weekday_frequency_week.' '.$event_weekday_frequency_day.' of '.$next_month.' '.$next_event_year));
				if(!in_array(date('Y-m-d', strtotime($all_events_add)), $event_multiple_dates))
				{ 
					if(strtotime($all_events_add)>date('U'))
					{
						$all_events[strtotime($all_events_add)] = get_the_ID();
					}
				}
			}
		}
		//If start date and end date do not match
		else
		{
			$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
			$start = 0;
			if($show_event==0)
			{
				$date_time = $event_start_date_unix;
				$increment_date = $date_time;
			}
			else
			{
				$event_start_date_m = date('Y-m-d', $event_start_date_unix);
				$date_end_time_m = date('G:i', $event_end_date_unix);
				$date_time = strtotime($event_start_date_m.' '.$date_end_time_m);
				$increment_date = $date_time;
			}
			while($start<=$days_total)
			{ 
				if($date_time>date('U'))
				{
					$all_events[$date_time] = get_the_ID();
					break;
				}
				$start++;
				$date_time = strtotime("+".$start." days", $increment_date);
			}
		}
		if($event_multiple_type==1&&$days_total<=1)
		{
			if(!empty($event_multiple_dates))
			{
				$start_date_time = date('G:i', $event_start_date_unix);
				foreach($event_multiple_dates as $date)
				{
					if(strtotime($date.' '.$start_date_time)>date('U'))
					{
						$all_events[strtotime($date.' '.$start_date_time)] = get_the_ID();
					}
				}
			}
		}
		endwhile; endif; wp_reset_postdata();
		return $all_events;
	}
}
if(!function_exists('solicitor_recur_events_future'))
{
	function solicitor_recur_events_future($status="future", $term=array())
	{
		$solicitor_options = get_option('solicitor_options');
		$show_event = (isset($solicitor_options['countdown_timer']))?$solicitor_options['countdown_timer']:'0';
		$offset = get_option('timezone_string');
		if($offset=='') 
		{ 
			$offset = "Australia/Melbourne"; 
		}
		date_default_timezone_set($offset);
		
		$today = date('Y-m-01');
				if(!empty($term))
				{ 
				$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'tax_query'=>array(array('taxonomy'=>'event-category', 'field'=>'term_id', 'terms'=>$term,'operator'=>'IN',)), 'meta_key' => 'solicitor_event_start_dt', 'meta_query' => array(array('key' => 'solicitor_event_frequency_end', 'value' => $today, 'compare' => '>=')), 'orderby' => 'meta_value', 'order' => 'ASC', 'posts_per_page' => -1)); 
				}
				else
				{
					$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'meta_key' => 'solicitor_event_start_dt', 'meta_query' => array(array('key' => 'solicitor_event_frequency_end', 'value' => $today, 'compare' => '>=')), 'orderby' => 'meta_value', 'order' => 'ASC', 'posts_per_page' => -1)); 
				}
		$count = 1;
		$all_events = array();
		if($event_list->have_posts()):while($event_list->have_posts()):$event_list->the_post();
		//Get all meta values of event
		$event_start_date = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta(get_the_ID(), 'solicitor_event_end_dt', true);
		$event_start_date_unix = strtotime($event_start_date);
		$event_end_date_unix = strtotime($event_end_date);
		$event_frequency_type = get_post_meta(get_the_ID(), 'solicitor_event_frequency_type', true);
		$fixed_date_frequency = get_post_meta(get_the_ID(), 'solicitor_event_frequency', true);
		$event_weekday_frequency_week = get_post_meta(get_the_ID(), 'solicitor_event_day_month', true);
		$event_weekday_frequency_day = get_post_meta(get_the_ID(), 'solicitor_event_week_day', true);
		$event_recur_count = get_post_meta(get_the_ID(), 'solicitor_event_frequency_count', true);
		$event_multiple_type = get_post_meta(get_the_ID(), 'solicitor_event_multiple_type', true);
		$event_multiple_dates = get_post_meta(get_the_ID(), 'solicitor_event_multiple_dates', true);
		$event_multiple_dates = (!empty($event_multiple_dates))?$event_multiple_dates:array();
		$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
		$this_month_start = date('Y-m-01');
		$this_month_start = strtotime($this_month_start);
		if($days_total<=0)
		{
			if($event_start_date_unix>date('U'))
			{
				//$all_events[$event_start_date_unix] = get_the_ID();
			}
		}
		//Run condition basis on event recur type
		//If recur type is fixed date
		if($event_frequency_type==1&&$days_total<1)
		{
			if($event_recur_count>0)
			{
				if($show_event==0)
				{
					$this_event_start_date = $event_start_date;
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
					$this_event_start_date = date('Y-m-d G:i', $get_updated_date);
				} 
				for($i=0; $i<$event_recur_count; $i++)
				{ 
					$event_new_date = strtotime("+".$fixed_date_frequency." days", strtotime($this_event_start_date));
					if(!in_array(date('Y-m-d', $event_new_date), $event_multiple_dates)&&$event_new_date>=$this_month_start)
					{ 
					if (array_key_exists($event_new_date, $all_events))
					{
						if($event_new_date>$this_month_start)
						{
							$all_events[$event_new_date+1] = get_the_ID();
						}
					}
					else
					{ 
						if($event_new_date>$this_month_start)
						{ 
							$all_events[$event_new_date] = get_the_ID();
						}
					}
					}
					$this_event_start_date = date('Y-m-d G:i', $event_new_date);
				}
			}
		 }
		//If recur type is week day
		elseif($event_frequency_type==2&&$days_total<1)
		{
			if($show_event==0)
				{
					$get_updated_date = strtotime($event_start_date);
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
				}
			for($i=1; $i<=$event_recur_count; $i++)
			{
				$eventDate = strtotime( date('Y-m-01', $get_updated_date) );
				$event_start_date = strtotime("+".$i." month", $eventDate);
				$next_month = date('F',$event_start_date);
				$next_event_year = date('Y',$event_start_date);
				$start_date_time = date('G:i', $get_updated_date);
				$all_events_add = date('Y-m-d '.$start_date_time, strtotime($event_weekday_frequency_week.' '.$event_weekday_frequency_day.' of '.$next_month.' '.$next_event_year));
				if(!in_array(date('Y-m-d', strtotime($all_events_add)), $event_multiple_dates))
				{ 
					if(strtotime($all_events_add)>$this_month_start)
					{
						$all_events[strtotime($all_events_add)] = get_the_ID();
					}
				}
			}
		}
		//If start date and end date do not match
		else
		{
			$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
			$start = 0;
			if($show_event==0)
			{
				$date_time = $event_start_date_unix;
				$increment_date = $date_time;
			}
			else
			{
				$event_start_date_m = date('Y-m-d', $event_start_date_unix);
				$date_end_time_m = date('G:i', $event_end_date_unix);
				$date_time = strtotime($event_start_date_m.' '.$date_end_time_m);
				$increment_date = $date_time;
			}
			while($start<=$days_total)
			{ 
				if (array_key_exists($date_time, $all_events))
				{
					if($date_time>$this_month_start)
					{
						$all_events[$date_time+1] = get_the_ID();
						break;
					}
				}
				else
				{ 
					if($date_time>$this_month_start)
					{
						$all_events[$date_time] = get_the_ID();
						break;
					}
				}
				$start++;
				$date_time = strtotime("+".$start." days", $increment_date);
			}
		}
		if($event_multiple_type==1&&$days_total<=1)
		{
			if(!empty($event_multiple_dates))
			{
				$start_date_time = date('G:i', $event_start_date_unix);
				foreach($event_multiple_dates as $date)
				{
					if(strtotime($date.' '.$start_date_time)>$this_month_start)
					{
						$all_events[strtotime($date.' '.$start_date_time)] = get_the_ID();
					}
				}
			}
		}
		endwhile; endif; wp_reset_postdata(); 
		return $all_events;
	}
}
if(!function_exists('solicitor_recur_events_past'))
{
	function solicitor_recur_events_past($term=array())
	{
		$solicitor_options = get_option('solicitor_options');
		$show_event = (isset($solicitor_options['countdown_timer']))?$solicitor_options['countdown_timer']:'0';
		$offset = get_option('timezone_string');
		if($offset=='') 
		{ 
			$offset = "Australia/Melbourne"; 
		}
		date_default_timezone_set($offset);
		
		$today = date('Y-m-d');
				if(!empty($term))
				{ 
				$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'tax_query'=>array(array('taxonomy'=>'event-terms', 'field'=>'term_id', 'terms'=>$term,'operator'=>'IN',)), 'posts_per_page' => -1)); 
				}
				else
				{
					$event_list = new WP_Query(array('post_type' => 'event','post_status' => 'publish', 'posts_per_page' => -1)); 
				}
		$count = 1;
		$all_events = array();
		if($event_list->have_posts()):while($event_list->have_posts()):$event_list->the_post();
		//Get all meta values of event
		$event_start_date = get_post_meta(get_the_ID(), 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta(get_the_ID(), 'solicitor_event_end_dt', true);
		$event_start_date_unix = strtotime($event_start_date);
		$event_end_date_unix = strtotime($event_end_date);
		$event_frequency_type = get_post_meta(get_the_ID(), 'solicitor_event_frequency_type', true);
		$fixed_date_frequency = get_post_meta(get_the_ID(), 'solicitor_event_frequency', true);
		$event_weekday_frequency_week = get_post_meta(get_the_ID(), 'solicitor_event_day_month', true);
		$event_weekday_frequency_day = get_post_meta(get_the_ID(), 'solicitor_event_week_day', true);
		$event_recur_count = get_post_meta(get_the_ID(), 'solicitor_event_frequency_count', true);
		$event_multiple_type = get_post_meta(get_the_ID(), 'solicitor_event_multiple_type', true);
		$event_multiple_dates = get_post_meta(get_the_ID(), 'solicitor_event_multiple_dates', true);
		$event_multiple_dates = (!empty($event_multiple_dates))?$event_multiple_dates:array();
		$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
		if($days_total<=0)
		{
			if($event_start_date_unix<date('U'))
			{
				$all_events[$event_start_date_unix] = get_the_ID();
			}
		}
		//Run condition basis on event recur type
		//If recur type is fixed date
		if($event_frequency_type==1&&$days_total<1)
		{
			if($event_recur_count>0)
			{
				if($show_event==0)
				{
					$this_event_start_date = $event_start_date;
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
					$this_event_start_date = date('Y-m-d G:i', $get_updated_date);
				}
				for($i=0; $i<$event_recur_count; $i++)
				{
					$event_new_date = strtotime("+".$fixed_date_frequency." days", strtotime($this_event_start_date));
					if(!in_array(date('Y-m-d', $event_new_date), $event_multiple_dates)&&$event_new_date<=date('U'))
					{
						if($event_new_date<date('U'))
						{
							$all_events[$event_new_date+1] = get_the_ID();
						}	
					}
					$this_event_start_date = date('Y-m-d G:i', $event_new_date);
				}
			}
		}
		//If recur type is week day
		elseif($event_frequency_type==2&&$days_total<1)
		{
			if($show_event==0)
				{
					$get_updated_date = strtotime($event_start_date);
				}
				else
				{
					$event_start_date_m = date('Y-m-d', $event_start_date_unix);
					$date_end_time_m = date('G:i', $event_end_date_unix);
					$get_updated_date = strtotime($event_start_date_m.' '.$date_end_time_m);
				}
			for($i=1; $i<=$event_recur_count; $i++)
			{
				$eventDate = strtotime( date('Y-m-01', $get_updated_date) );
				$event_start_date = strtotime("+".$i." month", $eventDate);
				$next_month = date('F',$event_start_date);
				$next_event_year = date('Y',$event_start_date);
				$start_date_time = date('G:i', $get_updated_date);
				$all_events_add = date('Y-m-d '.$start_date_time, strtotime($event_weekday_frequency_week.' '.$event_weekday_frequency_day.' of '.$next_month.' '.$next_event_year));
				if(!in_array(date('Y-m-d', strtotime($all_events_add)), $event_multiple_dates))
				{
					if(strtotime($all_events_add)<date('U'))
					{
						$all_events[strtotime($all_events_add)] = get_the_ID();
					}
				}
			}
		}
		//If start date and end date do not match
		else
		{
			$days_total = solicitor_dateDiff($event_start_date, $event_end_date);
			$start = 0;
			if($show_event==0)
			{
				$date_time = $event_start_date_unix;
				$increment_date = $date_time;
			}
			else
			{
				$event_start_date_m = date('Y-m-d', $event_start_date_unix);
				$date_end_time_m = date('G:i', $event_end_date_unix);
				$date_time = strtotime($event_start_date_m.' '.$date_end_time_m);
				$increment_date = $date_time;
			}
			while($start<=$days_total)
			{ 
				if($date_time<date('U'))
				{
					$all_events[$date_time] = get_the_ID();
					break;
				}
				$start++;
				$date_time = strtotime("+".$start." days", $increment_date);
			}
		}
		if($event_multiple_type==1&&$days_total<=1)
		{
			if(!empty($event_multiple_dates))
			{
				$start_date_time = date('G:i', $event_start_date_unix);
				foreach($event_multiple_dates as $date)
				{
					if(strtotime($date.' '.$start_date_time)<date('U'))
					{
						$all_events[strtotime($date.' '.$start_date_time)] = get_the_ID();
					}
				}
			}
		}
		endwhile; endif; wp_reset_postdata();
		return $all_events;
	}
}
/** -------------------------------------------------------------------------------------
 * Convert the Format String from php to fullcalender
 * @see http://arshaw.com/fullcalendar/docs/utilities/formatDate/
 * @param $format
----------------------------------------------------------------------------------- */
if(!function_exists('SolicitorConvertDate')){
	 function SolicitorConvertDate($format) {
	 	$format_rules = array('a'=>'t',
			 'A'=>'T',
			 'B'=>'',
			 'c'=>'u',
			 'd'=>'dd',
			 'D'=>'ddd',
			 'F'=>'MMMM',
			 'g'=>'h',
			 'G'=>'H',
			 'h'=>'hh',
			 'H'=>'HH',
			 'i'=>'mm',
			 'I'=>'',
			 'j'=>'d',
			 'l'=>'dddd',
			 'L'=>'',
			 'm'=>'MM',
			 'M'=>'MMM',
			 'n'=>'M',
			 'O'=>'',
			 'r'=>'',
			 's'=>'ss',
			 'S'=>'S',
			 't'=>'',
			 'T'=>'',
			 'U'=>'',
			 'w'=>'',
			 'W'=>'',
			 'y'=>'yy',
			 'Y'=>'yyyy',
			 'z'=>'',
			 'Z'=>'');
	 	  $ret = '';
	 	for ($i=0; $i<strlen($format); $i++) {
	 		if (isset($format_rules[$format[$i]])) {
	 			$ret .= $format_rules[$format[$i]];
	 		} else {
	 			$ret .= $format[$i];
	 		}
	 	}
	 	return $ret;
}}
if (!function_exists('solicitor_social_staff_icon')) {
function solicitor_social_staff_icon($id = '') {
        $output = '';
		if($id=='') { $id = get_the_ID(); }
        $staff_icons = get_post_meta($id, 'solicitor_social_icon_list', false);
        if (!empty($staff_icons[0]) || get_post_meta($id, 'solicitor_staff_member_email', true) != '') {
            $output.='<ul class="social-icons-rounded social-icons-colored">';
            if (!empty($staff_icons[0])) {
                foreach ($staff_icons[0] as $list => $values) {
                    if (!empty($values[1])) {
                        $className = preg_replace('/\s+/', '-', strtolower($values[0]));
                        $className = 'fa fa-' . $className;
                        $output.='<li class="'.$values[0].'"><a href="' . $values[1] . '" target ="_blank"><i class="' . $className . '"></i></a></li>';
                    }
                }
            }
            if (get_post_meta($id, 'solicitor_staff_member_email', true) != '') {
                $output.='<li class="email"><a href="mailto:' . get_post_meta($id, 'solicitor_staff_member_email', true) . '"><i class="fa fa-envelope"></i></a></li>';
            }
            $output.='</ul>';
        }
        return $output;
    }
}
if(!function_exists('solicitor_event_arg')){
 function solicitor_event_arg($date_converted,$id){
        $custom_event_url=esc_url(add_query_arg('event_date',$date_converted,get_permalink($id)));
    return $custom_event_url;
  }
}
//Get All Post Types
if(!function_exists('solicitor_get_all_types')){
add_action( 'wp_loaded', 'solicitor_get_all_types');
function solicitor_get_all_types(){
   $args = array(
   'public'   => true,
   );
$output = 'names'; // names or objects, note names is the default
return $post_types = get_post_types($args, $output); 
}
}
if(!function_exists('solicitor_get_event_time_format'))
{
	function solicitor_get_event_time_format($id, $key, $layout="list")
	{
		$print_time = '';
		$solicitor_options = get_option('solicitor_options');
		$date_format = (isset($solicitor_options['event_tm_opt']))?$solicitor_options['event_tm_opt']:0;
		$event_start_date = get_post_meta($id, 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta($id, 'solicitor_event_end_dt', true);
		$event_all_day = get_post_meta($id, 'solicitor_event_all_day', true);
		$days_difference = solicitor_dateDiff($event_start_date, $event_end_date);
		$event_start_date = strtotime($event_start_date);
		$event_end_date = strtotime($event_end_date);
		$event_day = ($layout=="grid")?date_i18n('l', $key).', ':'';
		if($event_all_day!='1')
		{
			switch ($date_format) 
			{
				case 0:
				$print_time .= $event_day.date_i18n(get_option('time_format'), $event_start_date);
				break;
				case 1:
				if($event_end_date!='')
				{
					$print_time .= $event_day.date_i18n(get_option('time_format'), $event_end_date);
				}
				else
				{
					$print_time .= $event_day.date_i18n(get_option('time_format'), $event_start_date);
				}
				break;
				case 2:
				if($event_end_date!='')
				{
					$print_time .= $event_day.date_i18n(get_option('time_format'), $event_start_date);
					$print_time .= ' - '.date_i18n(get_option('time_format'), $event_end_date);
				}
				else
				{
					$print_time .= $event_day.date_i18n(get_option('time_format'), $event_start_date);
				}
				break;
			}
		}
		return $print_time;
	}
}
if(!function_exists('solicitor_get_event_datetime_format'))
{
	function solicitor_get_event_date_format($id, $key)
	{
		$print_date = '';
		$solicitor_options = get_option('solicitor_options');
		$date_format = (isset($solicitor_options['event_dt_opt']))?$solicitor_options['event_dt_opt']:0;
		$event_start_date = get_post_meta($id, 'solicitor_event_start_dt', true);
		$event_end_date = get_post_meta($id, 'solicitor_event_end_dt', true);
		$days_difference = solicitor_dateDiff($event_start_date, $event_end_date);
		$event_start_date = strtotime($event_start_date);
		$event_end_date = strtotime($event_end_date);
		switch ($date_format) 
		{
			case 0:
			$print_date .= date_i18n(get_option('date_format'), $key);
			break;
			case 1:
			if($days_difference>0)
			{
				$print_date .= date_i18n(get_option('date_format'), $event_end_date);
			}
			else
			{
				$print_date .= date_i18n(get_option('date_format'), $key);
			}
			break;
			case 2:
			if($days_difference>0)
			{
				$print_date .= date_i18n(get_option('date_format'), $event_start_date);
				$print_date .= ' - '.date_i18n(get_option('date_format'), $event_end_date);
			}
			else
			{
				$print_date .= date_i18n(get_option('date_format'), $key);
			}
			break;
		}
		return $print_date;
	}
}
if(!function_exists('solicitorAddQueryVarsFilter')){
function solicitorAddQueryVarsFilter( $vars ){
  $vars[] = "event_date";
  $vars[] = "event_cat";
  $vars[] = "pg";
  $vars[] = "speakers";
  $vars[] = "reg";
	$vars[] = "registrant";
  return $vars;
}
add_filter('query_vars','solicitorAddQueryVarsFilter');
}

if (!function_exists('solicitor_contact_event_manager')) {
function solicitor_contact_event_manager(){
	$event_id = $_POST['itemnumber'];
	$post_type = get_post_type($event_id);
	$event_date = $_POST['event_date'];
	$exhibition_time = (isset($_POST['exhibition_time']))?$_POST['exhibition_time']:'';
	$cost = (isset($_POST['costs'])&&$_POST['costs']!=0)?$_POST['costs']:esc_html__('Free', 'solicitor');
	$name = $_POST['name'];
	$lname = $_POST['lastname'];
	$email = $_POST['email'];
	$phone = $_POST['phone'];
	$address = $_POST['address'];
	$notes = $_POST['notes'];
	$ticket_details = (isset($_POST['ticket_details']))?$_POST['ticket_details']:array();
	$event_title = get_the_title($event_id);
	$registration_number = get_post_meta($event_id, 'solicitor_event_registration_number', true);
	$registration_number = ($registration_number=='')?0:$registration_number+1;
	$reg_post_type = ($post_type=='event')?'event_registrants':'exhibition_reg';
	$registrant = array(
	  'post_title'    => $name.' '.$lname,
	  'post_status'   => 'publish',
	  'post_author'   => 1,
	  'post_type' => $reg_post_type
	);
	
	// Insert the registrant into the database
	$registrant_id = wp_insert_post( $registrant );
	if($post_type=='event')
	{
		wp_set_object_terms($registrant_id, get_the_title($event_id), 'registrant-event');
	}
	$tickets_type_event = get_post_meta($event_id, 'tickets_type', true);
	if(!empty($ticket_details))
	{
		$ticket_info = array();
		foreach($ticket_details as $key=>$value)
		{
			$ticket_info[$key]=$value;
			if(!empty($tickets_type_event))
			{
				$tickets_type_event = get_post_meta($event_id, 'tickets_type', true);
				$tickets_type = array();
				foreach($tickets_type_event as $tickets)
				{
					if($tickets[0]!=$key)
					{
						$tickets_type[]  = array($tickets[0], $tickets[1], $tickets[2], $tickets[3]);
					}
					else
					{
						$available = $tickets[1];
						$booked_tickets = $tickets[2];
						$new_booked_updated = $booked_tickets+$value;
						$new_available_updated = $available-$value;
						$tickets_type[]  = array($tickets[0], $tickets[1], $new_booked_updated, $tickets[3]);
					}
				}
				delete_post_meta( $event_id, 'tickets_type' );
				update_post_meta($event_id, 'tickets_type', $tickets_type);
			}
		}
		update_post_meta($registrant_id, 'solicitor_registrant_ticket_type', $ticket_info);
	}
	update_post_meta($registrant_id, 'solicitor_registrant_email', esc_attr($email));
	update_post_meta($registrant_id, 'solicitor_registrant_phone', esc_attr($phone));
	update_post_meta($registrant_id, 'solicitor_registrant_address', esc_attr($address));
	update_post_meta($registrant_id, 'solicitor_registrant_additional_notes', esc_attr($notes));
	update_post_meta($registrant_id, 'solicitor_registrant_event_date', $event_date);
	update_post_meta($registrant_id, 'solicitor_registrant_registration_number', esc_attr($event_id.'-'.$registration_number));
	update_post_meta($event_id, 'solicitor_event_registration_number', $registration_number);
	$event_manager_email = get_post_meta($event_id,'solicitor_event_manager',true);
	$manager_email = esc_attr($event_manager_email);
	$manager_email = ($manager_email!='')?$manager_email:get_option('admin_email');
	if($post_type=="event")
	{
		$e_subject = esc_html__('Registration for Event','solicitor');
	}
	$result['regid'] = esc_attr($event_id.'-'.$registration_number);
  $result['reguser'] = esc_attr($name).'<br/>'. esc_attr($lname);
	$result['cost'] = esc_attr($cost);
	$result['registrant'] = esc_attr($registrant_id);
	$result = json_encode($result);
	echo esc_attr($result);
	$e_body = esc_html__("You have been contacted by", "solicitor").' '.$name.', '.esc_html__("for", "solicitor").' '.$event_title . PHP_EOL . PHP_EOL;
	$body = esc_html__("Your message has been delivered to Manager for", "solicitor").' '. $event_title . PHP_EOL . PHP_EOL;
$e_content = '';
$e_content .= esc_html__("Registration Number:", "solicitor").' '. $event_id.'-'.$registration_number . PHP_EOL . PHP_EOL;
$e_content .= esc_html__("Date:", "solicitor").' '. $event_date . PHP_EOL . PHP_EOL;
if($post_type!="event")
{
	$e_content .= esc_html__("Time:", "solicitor").' '. $exhibition_time . PHP_EOL . PHP_EOL;
}
$e_content .= esc_html__("Name:", "solicitor").' '. esc_attr($name). esc_attr($lname). PHP_EOL . PHP_EOL;
$e_content .= esc_html__("Email:", "solicitor").' '. esc_attr($email) . PHP_EOL . PHP_EOL;
$e_content .= esc_html__("Phone:", "solicitor").' '. esc_attr($phone) . PHP_EOL . PHP_EOL;
$e_content .= esc_html__("Notes:", "solicitor").' '. esc_attr($notes) . PHP_EOL . PHP_EOL;
$e_content .= esc_html__("Address:", "solicitor").' '. esc_attr($address) . PHP_EOL . PHP_EOL;
$e_reply = esc_html__("You can contact ", "solicitor")." ".esc_attr($name)." ".esc_html__("via email", "solicitor").', '.esc_attr($email);
$reply = esc_html__("You can contact manager via email", "solicitor").', '. $manager_email;
$msg = wordwrap( $e_body . $e_content . $e_reply, 70 );
$user_msg = wordwrap( $body . $e_content . $reply, 70 );
$headers = "From: $email" . PHP_EOL;
$headers .= "Reply-To: $email" . PHP_EOL;
$headers .= "MIME-Version: 1.0" . PHP_EOL;
$headers .= "Content-type: text/plain; charset=utf-8" . PHP_EOL;
$headers .= "Content-Transfer-Encoding: quoted-printable" . PHP_EOL;
$user_headers = "From: $manager_email" . PHP_EOL;
$user_headers .= "Reply-To: $email" . PHP_EOL;
$user_headers .= "MIME-Version: 1.0" . PHP_EOL;
$user_headers .= "Content-type: text/plain; charset=utf-8" . PHP_EOL;
$user_headers .= "Content-Transfer-Encoding: quoted-printable" . PHP_EOL;
if(mail($manager_email, $e_subject, $msg, $headers)&&mail($email, $e_subject, $user_msg, $user_headers)) {
} else {
	echo '<div class="alert alert-error">ERROR!</div>';
}
	die();
}
add_action('wp_ajax_nopriv_solicitor_contact_event_manager', 'solicitor_contact_event_manager');
add_action('wp_ajax_solicitor_contact_event_manager', 'solicitor_contact_event_manager');
}
/* -------------------------------------------------------------------------------------
Month Translate in Default.
  ----------------------------------------------------------------------------------- */
    if(!function_exists('solicitor_month_translate')){
function solicitor_month_translate( $str ) {
  
	$options = get_option('solicitor_options');
       $months = (isset($options["calendar_month_name"]))?$options["calendar_month_name"]:'';
    $months = explode(',',$months);
  if(count($months)<=1){
  $months = array("January","February","March","April","May","June","July","August","September","October","November","December");
}
$sb = array();
foreach($months as $month) { $sb[] = $month; } 
    $engMonth = array("January","February","March","April","May","June","July","August","September","October","November","December");
    $trMonth = $sb;
    $converted = str_replace($engMonth, $trMonth, $str);
    return $converted;
    }
    /* -------------------------------------------------------------------------------------
  Filter the  Month name of Post.
  ----------------------------------------------------------------------------------- */
add_filter( 'get_the_time', 'solicitor_month_translate' );
add_filter( 'the_date', 'solicitor_month_translate' );
add_filter( 'get_the_date', 'solicitor_month_translate' );
add_filter( 'comments_number', 'solicitor_month_translate' );
add_filter( 'get_comment_date', 'solicitor_month_translate' );
add_filter( 'get_comment_time', 'solicitor_month_translate' );
add_filter( 'date_i18n', 'solicitor_month_translate' );
}
/* -------------------------------------------------------------------------------------
  Short Month Translate in Default.
  ----------------------------------------------------------------------------------- */
if(!function_exists('solicitor_short_month_translate')){
function solicitor_short_month_translate( $str ) {
    
       $options = get_option('solicitor_options');
       $months = (isset($options["calendar_month_name_short"]))?$options["calendar_month_name_short"]:'';
    $months = explode(',',$months);
  if(count($months)<=1){
  $months = array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
}
$sb = array();
foreach($months as $month) { $sb[] = $month; } 
    $engMonth = array("/\bJan\b/","/\bFeb\b/","/\bMar\b/","/\bApr\b/","/\bMay\b/","/\bJun\b/","/\bJul\b/","/\bAug\b/","/\bSep\b/","/\bOct\b/","/\bNov\b/","/\bDec\b/");
    $trMonth = $sb;
    $converted = preg_replace($engMonth, $trMonth, $str);
    return $converted;
}
/* -------------------------------------------------------------------------------------
  Filter the  Sort Month name of Post.
  ----------------------------------------------------------------------------------- */
add_filter( 'get_the_time', 'solicitor_short_month_translate' );
add_filter( 'the_date', 'solicitor_short_month_translate' );
add_filter( 'get_the_date', 'solicitor_short_month_translate' );
add_filter( 'comments_number', 'solicitor_short_month_translate' );
add_filter( 'get_comment_date', 'solicitor_short_month_translate' );
add_filter( 'get_comment_time', 'solicitor_short_month_translate' );
add_filter( 'date_i18n', 'solicitor_short_month_translate' );
}
 if(!function_exists('solicitor_day_translate')){
function solicitor_day_translate( $str ) {
	$options = get_option('solicitor_options');
       $days = (isset($options["calendar_day_name"]))?$options["calendar_day_name"]:'';;
    $days = explode(',',$days);
  if(count($days)<=1){
  $days = array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
}
$sb = array();
foreach($days as $month) { $sb[] = $month; } 
    $engDay = array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
    $trDay = $sb;
    $converted = str_replace($engDay, $trDay, $str);
    return $converted;
    }
    /* -------------------------------------------------------------------------------------
  Filter the  Day name of Post.
  ----------------------------------------------------------------------------------- */
add_filter('date_i18n', 'solicitor_day_translate');
}
/* CUSTOM JS OUTPUT
  ================================================== */
if (!function_exists('solicitor_custom_script')) {
    function solicitor_custom_script() {
        $options = get_option('solicitor_options');
        $custom_js = (isset($options['custom_js']))?$options['custom_js']:'';
        if ($custom_js) {
            echo'<script type ="text/javascript">';
            echo ''.$custom_js;
            echo '</script>';
        }
    }
    add_action('wp_footer', 'solicitor_custom_script');
}
/* REGISTER SIDEBARS
  ================================================== */
if (!function_exists('solicitor_widgets_init')) {
    add_action( 'widgets_init', 'solicitor_widgets_init' );
		function solicitor_widgets_init() {
        if (function_exists('register_sidebar')) {
			$options = get_option('solicitor_options');
			$footer_class = (isset($options["footer_layout"]))?$options["footer_layout"]:'';
			register_sidebar(array(
                'name' => esc_html__('Post Sidebar', 'solicitor'),
                'id' => 'post-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Page Sidebar', 'solicitor'),
                'id' => 'page-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Services Sidebar', 'solicitor'),
                'id' => 'services-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div id="%1$s" class="widget sidebar-widget custom_menu %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '</h3>'
            ));
			register_sidebar(array(
                'name' => esc_html__('Footer Widgets', 'solicitor'),
                'id' => 'footer-sidebar',
                'description' => '',
                'class' => '',
                'before_widget' => '<div class="col-md-'.$footer_class.' col-sm-'.$footer_class.'"><div class="widget footer_widget %2$s">',
                'after_widget' => '</div></div>',
                'before_title' => '<h4 class="widgettitle">',
                'after_title' => '</h4>'
            ));
        }
    }
}
/* -------------------------------------------------------------------------------------
  Filter the Widget Title.
  ----------------------------------------------------------------------------------- */
if (!function_exists('solicitor_widget_titles')) {
    add_filter('dynamic_sidebar_params', 'solicitor_widget_titles', 20);
    function solicitor_widget_titles(array $params) {
        // $params will ordinarily be an array of 2 elements, we're only interested in the first element
        $widget = & $params[0];
        $id = $params[0]['id'];
        if ($id == 'footer-sidebar') {
            $widget['before_title'] = '<h4 class="widgettitle">';
            $widget['after_title'] = '</h4>';
        } else {
            $widget['before_title'] = '<h3 class="widgettitle">';
            $widget['after_title'] = '</h3>';
        }
        return $params;
    }
}
//Get all Sidebars
if (!function_exists('solicitor_get_all_sidebars')) {
    function solicitor_get_all_sidebars() {
        $all_sidebars = array();
        global $wp_registered_sidebars;
        $all_sidebars = array('' => '');
        foreach ($wp_registered_sidebars as $sidebar) {
            $all_sidebars[$sidebar['id']] = $sidebar['name'];
        }
        return $all_sidebars;
    }
}
//Meta Box for Sidebar on all Posts/Page
if (!function_exists('solicitor_register_meta_box')) {
    add_action('admin_init', 'solicitor_register_meta_box');
    function solicitor_register_meta_box() {
        // Check if plugin is activated or included in theme
        if (!class_exists('RW_Meta_Box'))
            return;
        $prefix = 'solicitor_';
        $meta_box = array(
            'id' => 'template-sidebar1',
            'title' => esc_html__("Select Sidebar", 'solicitor'),
            'pages' => array('post', 'page', 'service','team','event','product'),
            'context' => 'normal',
            'fields' => array(
                array(
                    'name' => 'Select Sidebar from list',
                    'id' => $prefix . 'select_sidebar_from_list',
                    'desc' => esc_html__("Select Sidebar from list.", 'solicitor'),
                    'type' => 'select',
                    'options' => solicitor_get_all_sidebars(),
                ),
                array(
                    'name' => 'Show no sidebar',
                    'id' => $prefix . 'strict_no_sidebar',
                    'desc' => esc_html__("This will dishonour page sidebar chosen at Theme Options as well.", 'solicitor'),
                    'type' => 'checkbox',
					'default' => 0
                ),
                array(
                    'name' => 'Select Sidebar Position',
                    'id' => $prefix . 'select_sidebar_position',
                    'desc' => esc_html__("Select Sidebar Postion", 'solicitor'),
                    'type' => 'radio',
                    'options' => array(
						'2' => 'Left',
						'1' => 'Right'
					),
					'default' => '1'
                ),
				array(
					'name' => esc_html__('Columns Layout', 'solicitor'),
					'id' => $prefix . 'sidebar_columns_layout',
					'desc' => esc_html__("Select Columns Layout .", 'solicitor'),
					'type' => 'select',
					'options' => array(
						'3' => esc_html__('One Fourth', 'solicitor'),
						'4' => esc_html__('One Third','solicitor'),
						'6' => esc_html__('Half','solicitor'),
							),
					'std' => 3,
			),
            )
        );
        new RW_Meta_Box($meta_box);
    }
}
 /**
 * SOLICITOR SIDEBAR POSITION
 */
if(!function_exists('solicitor_sidebar_position_module'))
{
	function solicitor_sidebar_position_module()
	{
		$sidebar_position = get_post_meta(get_the_ID(),'solicitor_select_sidebar_position',true);
		if(is_home())
		{
			$id = get_option('page_for_posts');
			$sidebar_position = get_post_meta($id,'solicitor_select_sidebar_position',true);
		}
		if($sidebar_position == 2)
		{
			echo ' <style type="text/css">#content-col, #sidebar-col{float:right;}</style>';	
		}
		elseif($sidebar_position == 1)
		{
			echo ' <style type="text/css">#content-col, #sidebar-col{float:left;}</style>';	
		}
	}
}
/*======================
Change Excerpt Length*/
if (!function_exists('solicitor_custom_excerpt_length')) {
function solicitor_custom_excerpt_length( $length ) {
	return 520;
}
add_filter( 'excerpt_length', 'solicitor_custom_excerpt_length', 999 );
}
//Get Attachment details
if (!function_exists('solicitor_wp_get_attachment')) {
function solicitor_wp_get_attachment( $attachment_id ) {
	$attachment = get_post( $attachment_id );
	if(!empty($attachment)) {
	return array(
		'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
		'caption' => $attachment->post_excerpt,
		'description' => $attachment->post_content,
		'href' => get_permalink( $attachment->ID ),
		'src' => $attachment->guid,
		'title' => $attachment->post_title,
		'url' => $attachment->meta_link
	); }
} }
/* Removing Redux framework pages */
if(!function_exists('solicitor_remove_redux_menu'))
{
	add_action( 'admin_menu', 'solicitor_remove_redux_menu',12 );
   	function solicitor_remove_redux_menu() {
   		remove_submenu_page('tools.php','redux-about');
    }
}
if(!function_exists('solicitor_RevSliderShortCode')){
function solicitor_RevSliderShortCode(){
     $slidernames = array();
    if(class_exists('RevSlider')){
     $sld = new RevSlider();
                $sliders = $sld->getArrSliders();
        if(!empty($sliders)){
           
        foreach($sliders as $slider){
          $title=$slider->getParam('title','false');
           $shortcode=$slider->getParam('shortcode','false');
            $slidernames[esc_attr($shortcode)]=$title;
        }}
           
}
return $slidernames;
   }
}
//Attachment Meta Box
if(!function_exists('solicitor_attachment_url')){
function solicitor_attachment_url( $fields, $post ) {
$meta = get_post_meta($post->ID, 'meta_link', true);
$fields['meta_link'] = array(
'label' => esc_html__('Image URL','solicitor'),
'input' => 'text',
'value' => $meta,
'show_in_edit' => true,
);
return $fields;
}
add_filter( 'attachment_fields_to_edit', 'solicitor_attachment_url', 10, 2 );
}
/**
* Update custom field on save
*/
if(!function_exists('solicitor_update_attachment_url')){
function solicitor_update_attachment_url($attachment){
global $post;
update_post_meta($post->ID, 'meta_link', $attachment['attachments'][$post->ID]['meta_link']);
return $attachment;
}
add_filter( 'attachment_fields_to_save', 'solicitor_update_attachment_url', 4);
}
/**
* Update custom field via ajax
*/
if(!function_exists('solicitor_save_attachment_url')){
function solicitor_save_attachment_url() {
$post_id = $_POST['id'];
$meta = $_POST['attachments'][$post_id ]['meta_link'];
update_post_meta($post_id , 'meta_link', $meta);
clean_post_cache($post_id);
}
add_action('wp_ajax_save-attachment-compat', 'solicitor_save_attachment_url', 0, 1);
}
function solicitor_get_author_link($id='')
{
	$author_id = get_the_author_id();
	return get_author_posts_url($author_id);
}
//Get All Post Types
if(!function_exists('solicitor_get_all_types')){
add_action( 'wp_loaded', 'solicitor_get_all_types');
function solicitor_get_all_types(){
   $args = array(
   'public'   => true,
   );
$output = 'names'; // names or objects, note names is the default
return $post_types = get_post_types($args, $output); 
}
}
/* Add Class to Next/Previous Posts Link
========================================================= */
add_filter('next_posts_link_attributes', 'solicitor_older_posts_link');
add_filter('previous_posts_link_attributes', 'solicitor_newer_posts_link');

function solicitor_older_posts_link() {
    return 'class="pull-left"';
}
function solicitor_newer_posts_link() {
    return 'class="pull-right"';
}
add_filter('next_post_link', 'solicitor_post_link_attributes_next');
add_filter('previous_post_link', 'solicitor_post_link_attributes_prev');
 
function solicitor_post_link_attributes_prev($output) {
    $code = 'class="pull-left"';
    return str_replace('<a href=', '<a '.$code.' href=', $output);
}
function solicitor_post_link_attributes_next($output) {
    $code = 'class="pull-right"';
    return str_replace('<a href=', '<a '.$code.' href=', $output);
}
//Add New Custom Menu Option
if ( !class_exists('SOLICITOR_Custom_Nav')) {
class SOLICITOR_Custom_Nav {
public function solicitor_add_nav_menu_meta_boxes() {
   
add_meta_box(
'mega_nav_link',
esc_html__('Mega Menu', 'solicitor'),
array( $this, 'nav_menu_link'),
'nav-menus',
'side',
'low'
);
}
public function nav_menu_link() {
    
     global $_nav_menu_placeholder, $nav_menu_selected_id;
	$_nav_menu_placeholder = 0 > $_nav_menu_placeholder ? $_nav_menu_placeholder - 1 : -1;
    
        ?>
<div id="posttype-wl-login" class="posttypediv">
<div id="tabs-panel-wishlist-login" class="tabs-panel tabs-panel-active">
<ul id ="wishlist-login-checklist" class="categorychecklist form-no-clear">
<li>
<label class="menu-item-title">
<input type="checkbox" class="menu-item-object-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object-id]" value="<?php echo esc_attr($_nav_menu_placeholder); ?>"> <?php esc_html_e('Create Column','solicitor'); ?>
</label>
    <input type="hidden" class="menu-item-db-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-db-id]" value="0">
    <input type="hidden" class="menu-item-object" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-object]" value="page">
<input type="hidden" class="menu-item-parent-id" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-parent-id]" value="0">
   <input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-type]" value="">
<input type="hidden" class="menu-item-title" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-title]" value="<?php esc_html_e('Column', 'solicitor'); ?>">
<input type="hidden" class="menu-item-classes" name="menu-item[<?php echo esc_attr($_nav_menu_placeholder); ?>][menu-item-classes]" value="custom_mega_menu">
</li>
</ul>
</div>
<p class="button-controls">
<span class="add-to-menu">
<input type="submit" class="button-secondary submit-add-to-menu right" value="<?php esc_html_e('Add to Menu', 'solicitor'); ?>" name="add-post-type-menu-item" id="submit-posttype-wl-login">
<span class="spinner"></span>
</span>
</p>
</div>
<?php }
}
}
$custom_nav = new SOLICITOR_Custom_Nav;
add_action('admin_init', array($custom_nav, 'solicitor_add_nav_menu_meta_boxes'));
if(!function_exists('solicitor_service_dropdown'))
{
function solicitor_service_dropdown ( $tag, $unused ) {

    if ( $tag['name'] != 'services' )
        return $tag;

    $args = array (
        'numberposts'   => -1,
        'post_type'     => 'service',
        'orderby'       => 'title',
        'order'         => 'ASC',
    );

    $custom_posts = get_posts($args);

    if ( ! $custom_posts )
        return $tag;

    foreach ( $custom_posts as $custom_post ) {

        $tag['raw_values'][] = $custom_post->post_title;
        $tag['values'][] = $custom_post->post_title;
        $tag['labels'][] = $custom_post->post_title;

    }

    return $tag;

}

add_filter( 'wpcf7_form_tag', 'solicitor_service_dropdown', 10, 2);
}
 /**
 * SOLICITOR SHARE BUTTONS
 */
if(!function_exists('solicitor_share_buttons')){
function solicitor_share_buttons(){
	$posttitle = get_the_title();
	$postpermalink = get_permalink();
	$postexcerpt = wp_trim_words(get_the_excerpt());
	global $solicitor_options;
	$facebook_share_alt = $solicitor_options['facebook_share_alt'];
	$twitter_share_alt = $solicitor_options['twitter_share_alt'];
	$google_share_alt = $solicitor_options['google_share_alt'];
	$tumblr_share_alt = $solicitor_options['tumblr_share_alt'];
	$pinterest_share_alt = $solicitor_options['pinterest_share_alt'];
	$reddit_share_alt = $solicitor_options['reddit_share_alt'];
	$linkedin_share_alt = $solicitor_options['linkedin_share_alt'];
	$email_share_alt = $solicitor_options['email_share_alt'];
	$vk_share_alt = $solicitor_options['vk_share_alt'];
	$whatsapp_share_alt = $solicitor_options['whatsapp_share_alt'];
	
			if($solicitor_options['sharing_style'] == '0'){
				if($solicitor_options['sharing_color'] == '0'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-bc social-icons-inverted">';
				}elseif($solicitor_options['sharing_color'] == '1'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-tc">';
				}elseif($solicitor_options['sharing_color'] == '2'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-gs">';
				}
			} elseif($solicitor_options['sharing_style'] == '1'){
				if($solicitor_options['sharing_color'] == '0'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-bc share-buttons-squared social-icons-inverted">';
				}elseif($solicitor_options['sharing_color'] == '1'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-tc share-buttons-squared">';
				}elseif($solicitor_options['sharing_color'] == '2'){
            		echo '<ul class="social-share-bar social-icons-colored share-buttons-gs share-buttons-squared">';
				}
			};
					if($solicitor_options['share_before_icon'] == 1){
						echo '<li class="meta-data share-title"><i class="fa fa-share-alt"></i></li>';
					}
					if($solicitor_options['share_before_text'] != ''){
						echo '<li class="meta-data share-title">'.esc_attr($solicitor_options['share_before_text']).'</li>';
					}
                	echo '<li class="meta-data"></li>';
					if(isset($solicitor_options['share_icon']['1']) && $solicitor_options['share_icon']['1'] == 1){
                   		echo '<li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=' . esc_url($postpermalink) . '&amp;t=' . esc_attr($posttitle) . '" target="_blank" title="' . esc_attr($facebook_share_alt) . '"><i class="fa fa-facebook"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['2']) && $solicitor_options['share_icon']['2'] == 1){
                     	echo '<li class="twitter"><a href="https://twitter.com/intent/tweet?source=' . esc_url($postpermalink) . '&amp;text=' . esc_attr($posttitle) . ':' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($twitter_share_alt) . '"><i class="fa fa-twitter"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['3']) && $solicitor_options['share_icon']['3'] == 1){
                    echo '<li class="google"><a href="https://plus.google.com/share?url=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($google_share_alt) . '"><i class="fa fa-google-plus"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['4']) && $solicitor_options['share_icon']['4'] == 1){
                    	echo '<li class="tumblr"><a href="http://www.tumblr.com/share?v=3&amp;u=' . esc_url($postpermalink) . '&amp;t=' . esc_attr($posttitle) . '&amp;s=" target="_blank" title="' . esc_attr($tumblr_share_alt) . '"><i class="fa fa-tumblr"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['5']) && $solicitor_options['share_icon']['5'] == 1){
                    	echo '<li class="pinterest"><a href="http://pinterest.com/pin/create/button/?url=' . esc_url($postpermalink) . '&amp;description=' . esc_attr($postexcerpt) . '" target="_blank" title="' . esc_attr($pinterest_share_alt) . '"><i class="fa fa-pinterest"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['6']) && $solicitor_options['share_icon']['6'] == 1){
                    	echo '<li class="reddit"><a href="http://www.reddit.com/submit?url=' . esc_url($postpermalink) . '&amp;title=' . esc_attr($posttitle) . '" target="_blank" title="' . esc_attr($linkedin_share_alt) . '"><i class="fa fa-reddit"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['7']) && $solicitor_options['share_icon']['7'] == 1){
                    	echo '<li class="linkedin"><a href="http://www.linkedin.com/shareArticle?mini=true&url=' . $postpermalink . '&amp;title=' . esc_attr($posttitle) . '&amp;summary=' . esc_attr($postexcerpt) . '&amp;source=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($linkedin_share_alt) . '"><i class="fa fa-linkedin"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['8']) && $solicitor_options['share_icon']['8'] == 1){
                    	echo '<li class="email"><a href="mailto:?subject=' . esc_attr($posttitle) . '&amp;body=' . esc_attr($postexcerpt) . ':' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($email_share_alt) . '"><i class="fa fa-envelope"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['9']) && $solicitor_options['share_icon']['9'] == 1){
                    	echo '<li class="vk"><a href="http://vk.com/share.php?url=' . $postpermalink . '" target="_blank" title="' . esc_attr($vk_share_alt) . '"><i class="fa fa-vk"></i></a></li>';
					}
					if(isset($solicitor_options['share_icon']['10']) && $solicitor_options['share_icon']['10'] == 1){
                    	echo '<li class="whatsapp-share"><a href="whatsapp://send?text=' . esc_url($postpermalink) . '" target="_blank" title="' . esc_attr($whatsapp_share_alt) . '" data-action="share/whatsapp/share"><i class="fa fa-whatsapp"></i></a></li>';
					}
                echo '</ul>';
	}
}


$default_attribs = array('aria-expanded' => array(),'data-parent' => array(),'data-toggle' => array(),'data-displayinput' => array(), 'data-readonly' => array(), 'value' => array(), 'data-fgcolor' => array(), 'data-thickness' => array(), 'data-linecap' => array(), 'data-option-value' => array(), 'data-style' => array(), 'data-pause' => array(), 'data-speed' => array(), 'data-option-key' => array(), 'data-sort-id' => array(),'href' => array(),'rel' => array(),'data-appear-progress-animation' => array(),'data-appear-animation-delay' => array(), 'target' => array('_blank','_self','_top'), 'data-items-mobile' => array(), 'data-items-tablet' => array(), 'data-items-desktop-small' => array(), 'data-items-desktop' => array(), 'data-single-item' => array(), 'data-arrows' => array(), 'data-pagination' => array(), 'data-autoplay' => array(), 'data-columns' => array(), 'width' => array(), 'data-srcset' => array(), 'height' => array(), 'src' => array(), 'id' => array(), 'class' => array(), 'title' => array(), 'style' => array(), 'alt' => array(), 'data' => array(), 'data-mce-id' => array(), 'data-mce-style' => array(), 'data-mce-bogus' => array());

$allowed_tags = array(
	'div'           => $default_attribs,
	'span'          => $default_attribs,
	'p'             => $default_attribs,
	'a'             => $default_attribs,
	'u'             => $default_attribs,
	'i'             => $default_attribs,
	'q'             => $default_attribs,
	'b'             => $default_attribs,
	'ul'            => $default_attribs,
	'ol'            => $default_attribs,
	'li'            => $default_attribs,
	'br'            => $default_attribs,
	'hr'            => $default_attribs,
	'strong'        => $default_attribs,
	'blockquote'    => $default_attribs,
	'del'           => $default_attribs,
	'strike'        => $default_attribs,
	'em'            => $default_attribs,
	'code'          => $default_attribs,
	'h1'            => $default_attribs,
	'h2'            => $default_attribs,
	'h3'            => $default_attribs,
	'h4'            => $default_attribs,
	'h5'            => $default_attribs,
	'h6'            => $default_attribs,
	'cite'          => $default_attribs,
	'img'           => $default_attribs,
	'section'       => $default_attribs,
	'iframe'        => $default_attribs,
	'input'         => $default_attribs,
	'label'         => $default_attribs,
	'canvas'        => $default_attribs,
);
?>