<?php
if (!defined('ABSPATH'))
exit; // Exit if accessed directly 
/*
* Here you include files which is required by theme
*/
require_once(get_template_directory().'/solicitor-framework' . '/solicitor-theme-functions.php');
/* META BOX FRAMEWORK
================================================== */
require_once(get_template_directory().'/solicitor-framework' . '/meta-boxes.php');
require_once(get_template_directory().'/solicitor-framework' . '/term_color_picker.php');
/* MEGA MENU
	================================================== */  
require_once(get_template_directory() . '/solicitor-framework' . '/solicitor-megamenu/solicitor-megamenu.php');
/* EVENT REGISTRATION
====================================================*/
require_once(get_template_directory().'/solicitor-framework' . '/registrant_tickets_field.php');
require_once(get_template_directory().'/solicitor-framework' . '/tickets_clone_fields.php');
/* PLUGIN INCLUDES
================================================== */
require_once(get_template_directory(). '/solicitor-framework/tgm/plugin-includes.php' );
/* LOAD Page Builder Widgets/Prebuilt Pages
================================================== */
require_once(get_template_directory() . '/solicitor-framework/page-builder/page-builder.php');
/* LOAD STYLESHEETS
================================================== */
if (!function_exists('solicitor_enqueue_styles')) {
function solicitor_enqueue_styles() {
$solicitor_options = get_option('solicitor_options');
$theme_color_scheme = (isset($solicitor_options['theme_color_scheme']))?$solicitor_options['theme_color_scheme']:'';
$enable_rtl = (isset($solicitor_options['enable_rtl']))?$solicitor_options['enable_rtl']:'';
$theme_info = wp_get_theme();
			wp_enqueue_style('bootstrap', SOLICITOR_THEME_PATH . '/css/bootstrap.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('bootstrap-theme', SOLICITOR_THEME_PATH . '/css/bootstrap-theme.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('solicitor-main', get_stylesheet_uri(), array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('fontawesome', SOLICITOR_THEME_PATH . '/css/font-awesome.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('animations', SOLICITOR_THEME_PATH . '/css/animations.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('line-icons', SOLICITOR_THEME_PATH . '/css/line-icons.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('magnific-popup', SOLICITOR_THEME_PATH . '/vendor/magnific/magnific-popup.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('owl-carousel', SOLICITOR_THEME_PATH . '/vendor/owl-carousel/css/owl.carousel.css', array(), $theme_info->get( 'Version' ), 'all');	
			wp_enqueue_style('owl-theme', SOLICITOR_THEME_PATH . '/vendor/owl-carousel/css/owl.theme.css', array(), $theme_info->get( 'Version' ), 'all');	
			wp_enqueue_style('fullcalendar', SOLICITOR_THEME_PATH . '/vendor/fullcalendar/fullcalendar.css', array(), $theme_info->get( 'Version' ), 'all');
			wp_enqueue_style('fullcalendar-print', SOLICITOR_THEME_PATH . '/vendor/fullcalendar/fullcalendar.print.css', array(), $theme_info->get( 'Version' ), 'print');
			if (isset($solicitor_options['theme_color_type'])&&$solicitor_options['theme_color_type'][0] == 0) {
				wp_enqueue_style('solicitor-colors', SOLICITOR_THEME_PATH . '/colors/' . $theme_color_scheme, array(), $theme_info->get( 'Version' ), 'all');
			} else {
				wp_enqueue_style('solicitor-colors', SOLICITOR_THEME_PATH . '/colors/color1.css', array(), $theme_info->get( 'Version' ), 'all');
			}
			//**End Enqueue STYLESHEETPATH**//
		}
		add_action('wp_enqueue_scripts', 'solicitor_enqueue_styles', 99);
}
if (!function_exists('solicitor_enqueue_scripts')) {
    function solicitor_enqueue_scripts() {
    $solicitor_options = get_option('solicitor_options');
		$theme_info = wp_get_theme();
        //**register script**//
		wp_enqueue_script('magnific', SOLICITOR_THEME_PATH . '/vendor/magnific/jquery.magnific-popup.min.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('solicitor-ui-plugins', SOLICITOR_THEME_PATH . '/js/ui-plugins.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('solicitor-helper-plugins', SOLICITOR_THEME_PATH . '/js/helper-plugins.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('owl-carousel', SOLICITOR_THEME_PATH . '/vendor/owl-carousel/js/owl.carousel.min.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('bootstrap', SOLICITOR_THEME_PATH . '/js/bootstrap.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('solicitor-init', SOLICITOR_THEME_PATH . '/js/init.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('flexslider', SOLICITOR_THEME_PATH . '/vendor/flexslider/js/jquery.flexslider.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('fullcalendar-moments', SOLICITOR_THEME_PATH . '/vendor/fullcalendar/lib/moment.min.js', array(), $theme_info->get( 'Version' ), false);
		wp_enqueue_script('fullcalendar', SOLICITOR_THEME_PATH . '/vendor/fullcalendar/fullcalendar.min.js', array('jquery'), $theme_info->get( 'Version' ), true);
		wp_enqueue_script('fullcalendar-gcal', SOLICITOR_THEME_PATH . '/vendor/fullcalendar/gcal.js', array(), $theme_info->get( 'Version' ), true);
		
		if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
        wp_enqueue_script('event-ajax', SOLICITOR_THEME_PATH . '/js/event_ajax.js', '', '', true);
        wp_localize_script('event-ajax', 'urlajax', array('ajaxurl' => admin_url('admin-ajax.php')));
        //**End Enqueue script**//
    }
    add_action('wp_enqueue_scripts', 'solicitor_enqueue_scripts');
}
/* LOAD BACKEND SCRIPTS
  ================================================== */
function solicitor_admin_scripts() 
{
 	wp_enqueue_script('solicitor-admin-functions', SOLICITOR_THEME_PATH . '/js/admin_scripts.js', 'jquery', NULL, TRUE);
	global $pagenow;
	if(($pagenow=='user-edit.php')||($pagenow=='profile.php'))
	{
		wp_enqueue_media();
	}
	if(isset($_REQUEST['taxonomy'])){
      wp_enqueue_script('imic-upload', SOLICITOR_THEME_PATH . '/js/imic-upload.js', 'jquery', NULL, TRUE);
      wp_enqueue_media();
  }
}
add_action('admin_init', 'solicitor_admin_scripts');
/* LOAD BACKEND STYLE
  ================================================== */
function solicitor_admin_styles() {
    add_editor_style(SOLICITOR_THEME_PATH . '/css/editor-style.css');
}
add_action('admin_head', 'solicitor_admin_styles');
?>