<?php

/*
Widget Name: imithemes - Video Widget
Description: A widget to show video in popup
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Video_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'video-widget',
			esc_html__('imithemes - Video Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show video in LightBox', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-star-filled',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'video_url' => array(
					'type' => 'link',
					'label' => esc_html__('Video URL', 'solicitor'),
				),
				'item_image' => array(
					'type' => 'media',
					'label' => esc_html__('Video Image', 'solicitor'),
					'library' => 'image',
					'fallback' => true,
				),

				'video_image_size' => array(
					'type' => 'select',
					'label' => esc_html__('Video Image size', 'solicitor'),
					'options' => array(
						'full' => esc_html__('Full', 'solicitor'),
						'large' => esc_html__('Large', 'solicitor'),
						'medium' => esc_html__('Medium', 'solicitor'),
						'thumb' => esc_html__('Thumbnail', 'solicitor'),
					),
				),

			),
			plugin_dir_path(__FILE__)
		);
	}


	function get_style_hash($instance) {
		return substr( md5( serialize( $this->get_less_variables( $instance ) ) ), 0, 12 );
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	
	function get_template_name( $instance ) {
		return 'template';
	}


}

siteorigin_widget_register('video-widget', __FILE__, 'Solicitor_Video_Widget');