<?php

/*
Widget Name: imithemes - Timeline Widget
Description: A widget to show timeline list.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Timeline_List extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'timeline-list-widget',
			esc_html__('imithemes - Timeline List Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show timeline list.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
			'blocks' => array(
					'type' => 'repeater',
					'label' => esc_html__('Timeline', 'solicitor'),
					'item_name' => esc_html__('Block', 'solicitor'),
					'item_label' => array(
						'selector' => "[id*='timeline_list_title']",
						'update_event' => 'change',
						'value_method' => 'val'
					),	
					'fields' => array(	
						'timeline_list_year' => array(
							'type' => 'text',
							'default' => '',
							'label' => esc_html__('Enter year', 'solicitor'),
					),
						'timeline_list_message' => array(
						'type' => 'tinymce',
						'label' => esc_html__( 'Enter content', 'solicitor' ),
						'default' => '',
						'rows' => 4
						),
					))
				),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('timeline-list-widget', __FILE__, 'Solicitor_Timeline_List');