<?php
$widget_title = wp_kses_post($instance['widget_title']);
$carousel_auto = wp_kses_post($instance['listing_layout']['carousel_auto']);
$carousel_nav = (!empty($instance['listing_layout']['carousel_nav']))? 'yes' : 'no' ;
$carousel_pagi = (!empty($instance['listing_layout']['carousel_pagi']))? 'yes' : 'no' ;
$the_categories = wp_kses_post($instance['categories']);
$numberPosts = (!empty($instance['number_of_posts']))? $instance['number_of_posts'] : 4 ;
$grid_column = (!empty($instance['listing_layout']['grid_column']))? $instance['listing_layout']['grid_column'] : 4 ;
$img_size = wp_kses_post($instance['img_size']);
$paged = (get_query_var('paged'))?get_query_var('paged'):1;
?>
<?php
	if ($grid_column == 4){
		$column = 3;
	} elseif ($grid_column == 3){
		$column = 4;
	} elseif ($grid_column == 6){
		$column = 2;
	} elseif ($grid_column == 12){
		$column = 1;
	}  else {
		$column = 3;	
	}

   	// Widget Title
	if($widget_title != ''){
		echo '<h3 class="widgettitle">'.esc_attr($widget_title).'</h3>';
	}
?>
<?php if(!empty($instance['listing_layout']['carousel_mode'])){ ?>
<div class="carousel-wrapper">
  	<div class="row">
    	<ul class="owl-carousel carousel-fw" data-columns="<?php echo esc_attr($column); ?>" data-autoplay="<?php echo esc_attr($carousel_auto); ?>" data-pagination="<?php echo esc_attr($carousel_pagi); ?>" data-arrows="<?php echo esc_attr($carousel_nav); ?>" data-single-item="no" data-items-desktop="<?php echo esc_attr($column); ?>" data-items-desktop-small="2" data-items-tablet="2" data-items-mobile="1" <?php if ( is_rtl() ) { ?>data-rtl="rtl"<?php } else { ?> data-rtl="ltr" <?php } ?>>
<?php } else { ?>
	<div class="row">
		<ul class="team-list isotope-grid">
<?php }
if($the_categories=='' || $the_categories == '0')
{
	$team_args = array ( 'post_type' => 'team', 'posts_per_page' => $numberPosts, 'paged' => $paged );
}
else
{
	$team_args = array ( 'post_type' => 'team', 'tax_query' => array(array('taxonomy' => 'team-category', 'field' => 'term_id', 'terms' => $the_categories, 'operator' => 'IN')), 'posts_per_page' => $numberPosts, 'paged' => $paged );
}
$team_listings = new WP_Query($team_args);
if($team_listings->have_posts()):while($team_listings->have_posts()):$team_listings->the_post();
$team_info = get_post_meta(get_the_ID(), 'solicitor_staff_position', true);
$team_email_info = get_post_meta(get_the_ID(), 'solicitor_email_id', true);
?>
<?php if(!empty($instance['listing_layout']['carousel_mode'])){ ?>
<li class="item team-list-item">
<?php } else { ?>
<li class="team-list-item grid-item col-md-<?php echo esc_attr($grid_column); ?> col-sm-4">
<?php } ?>

        <?php if(!empty($instance['add_permalink'])){ ?><a href="<?php the_permalink(); ?>"><?php } ?><?php the_post_thumbnail('solicitor-177x177'); ?><?php if(!empty($instance['add_permalink'])){ ?></a><?php } ?>
	<h5><?php if(!empty($instance['add_permalink'])){ ?><a href="<?php the_permalink(); ?>"><?php } ?><?php the_title(); ?><?php if(!empty($instance['add_permalink'])){ ?></a><?php } ?></h5>
        <span class="meta-data"><?php echo esc_attr($team_info); ?></span>
        <?php if($team_email_info != ''){ ?><a href="mailto:<?php echo esc_html($team_email_info); ?>" class="basic-link">
	   <?php esc_html_e('Email','solicitor'); ?></a><?php } ?>
	</li>  
<?php
endwhile; endif; wp_reset_postdata(); ?>
	</ul>
</div>
<?php if(!empty($instance['listing_layout']['carousel_mode'])){ ?>              
</div>                  
<?php }
?>