<?php

/*
Widget Name: imithemes - Team Widget
Description: A widget to show team posts.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Team_Widget extends SiteOrigin_Widget {
	function __construct() {
		// Image Size and terms
		$arr = array();
		$arr[] = esc_html__('All', 'solicitor');
		$team_terms = get_terms('team-category');
		if(!is_wp_error($team_terms))
		{
			foreach($team_terms as $term)
			{
				$arr[$term->term_id] = $term->name;
			}
		}
		$img_arr = array();
		$image_sizes = get_intermediate_image_sizes();
		if(!empty($image_sizes)&&!is_wp_error($image_sizes))
		{
			foreach($image_sizes as $size)
			{
				$img_arr[$size] = $size;
			}
		}
		parent::__construct(
			'team-widget',
			esc_html__('imithemes - Team Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show team posts.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'widget_title' => array(
					'label' => esc_html__( 'Widget Title', 'solicitor' ),
					'type' => 'text',
				),
				'categories' => array(
					'type' => 'select',
					'label' => esc_html__( 'Filter by categories', 'solicitor' ),
					'description' => esc_html__( 'To select multiple categories select with Ctrl/Command key pressed.', 'solicitor' ),
					'multiple' => true,
					'default' => '',
					'options' => $arr
				),
				'number_of_posts' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of team members to show per page', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'show_pagination' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Enable pagination', 'solicitor'),
					'state_handler' => array(
						'layout_type[one]' => array('show'),
						'layout_type[two]' => array('hide'),
					),
				),
				'add_permalink' => array(
					'type' => 'checkbox',
					'default' => false,
					'label' => esc_html__('Enable link on title and image for single page', 'solicitor'),
				),
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Layout', 'solicitor' ),
					'hide' => false,
					'description' => esc_html__( 'Choose listing layout.', 'solicitor' ),
					'fields' => array(
						'layout_type'    => array(
							'type'    => 'radio',
							'default' => 'list',
							'label'   => esc_html__( 'Layout style', 'solicitor' ),
							'options' => array(
								'one' => esc_html__( 'Style One', 'solicitor' ),
								'two'      => esc_html__( 'Style Two', 'solicitor' ),
							),
							'state_emitter' => array(
								'callback' => 'select',
								'args' => array( 'layout_type' )
							),
						),
						'grid_column' => array(
							'type' => 'select',
							'state_name' => 'grid',
							'prompt' => esc_html__( 'Choose Grid View Column', 'solicitor' ),
							'options' => array(
								'12' => esc_html__( 'One', 'solicitor' ),
								'6' => esc_html__( 'Two', 'solicitor' ),
								'4' => esc_html__( 'Three', 'solicitor' ),
								'3' => esc_html__( 'Four', 'solicitor' ),
							),
						),
						'carousel_mode' => array(
							'type' => 'checkbox',
							'label' => esc_html__('Show as carousel', 'solicitor'),
						),
						'carousel_pagi' => array(
							'type' => 'checkbox',
							'default' => false,
							'label' => esc_html__('Enable carousel pagination', 'solicitor'),
						),
						'carousel_nav' => array(
							'type' => 'checkbox',
							'default' => true,
							'label' => esc_html__('Enable carousel Next/prev arrows', 'solicitor'),
						),
						'carousel_auto' => array(
							'type' => 'number',
							'default' => '',
							'label' => esc_html__('Enter time interval for Auto Carousel. 1000 = 1 second. Leave blank for no AutoPlay.', 'solicitor'),
						),
					),
				),
				'img_size' => array(
					'type' => 'select',
					'label' => esc_html__( 'Thumbnail Image Size', 'solicitor' ),
					'default' => 'solicitor-600x400',
					'options' => $img_arr,
					'state_handler' => array(
						'layout_type[one]' => array('show'),
						'layout_type[two]' => array('hide'),
					),
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	function get_template_name( $instance ) {
		return $instance['listing_layout']['layout_type'] == 'one' ? 'style-one' : 'style-two';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('team-widget', __FILE__, 'Solicitor_Team_Widget');