<?php

/*
Widget Name: imithemes - Tabs Widget
Description: A widget to add tabs to your pages.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Tabs_Widget extends SiteOrigin_Widget {
	function __construct() {

		parent::__construct(
			'tabs-widget',
			esc_html__('imithemes - Tabs Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to add tabs to your pages.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'tab_id' => array(
					'type' => 'number',
					'label' => esc_html__('Tabs ID', 'solicitor'),
					'description' => esc_html__('Numeric only. Keep it unique if adding multiple tabs in a single page.', 'solicitor'),
					
				),
				'tabs' => array(
					'type' => 'repeater',
					'label' => esc_html__('Tabs', 'solicitor'),
					'item_name' => esc_html__('Tab', 'solicitor'),
					'item_label' => array(
						'selector' => "[id*='tab_nav_title']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(

						'tab_nav_title' => array(
							'type' => 'text',
							'label' => esc_html__('Tab title', 'solicitor'),
						),

						'tab_nav_content' => array(
							'type' => 'tinymce',
							'label' => esc_html__('Tab Content', 'solicitor'),
						),

					),
				),
				'display_type' => array(
					'type' => 'select',
					'state_name' => 'vertical',
					'label' => esc_html__( 'Choose View', 'solicitor' ),
					'prompt' => esc_html__( 'Choose Display Style', 'solicitor' ),
					'options' => array(
						'horizontal' => esc_html__( 'Horizontal', 'solicitor' ),
						'vertical' => esc_html__( 'Vertical', 'solicitor' ),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}
	
	
	function get_template_name( $instance ) {
		return $instance['display_type'] == 'vertical' ? 'vertical-view' : 'horizontal-view';
	}


	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('tabs-widget', __FILE__, 'Solicitor_Tabs_Widget');