<?php
$widget_title = wp_kses_post($instance['widget_title']);
$carousel_auto = wp_kses_post($instance['listing_layout']['carousel_auto']);
$carousel_nav = (!empty($instance['listing_layout']['carousel_nav']))? 'yes' : 'no' ;
$carousel_pagi = (!empty($instance['listing_layout']['carousel_pagi']))? 'yes' : 'no' ;
$the_categories = wp_kses_post($instance['categories']);
$style = wp_kses_post($instance['listing_layout']['style']);
$numberPosts = (!empty($instance['number_of_posts']))? $instance['number_of_posts'] : 4 ;
$grid_column = (!empty($instance['listing_layout']['grid_column']))? $instance['listing_layout']['grid_column'] : 4 ;
$paged = (get_query_var('paged'))?get_query_var('paged'):1;
?>
<?php
	if ($grid_column == 4){
		$column = 3;
	} elseif ($grid_column == 3){
		$column = 4;
	} elseif ($grid_column == 6){
		$column = 2;
	} elseif ($grid_column == 12){
		$column = 1;
	} else {
		$column = 3;	
	}

   	// Widget Title
	if($widget_title != ''){
		echo '<h3 class="widgettitle">'.esc_attr($widget_title).'</h3>';
	}
?>
<div class="<?php echo esc_attr($style); ?>">
<?php if(!empty($instance['listing_layout']['carousel_mode'])){ ?>
<div class="carousel-wrapper">
	<div class="row">
	<ul class="owl-carousel carousel-fw" data-columns="<?php echo esc_attr($column); ?>" data-autoplay="<?php echo esc_attr($carousel_auto); ?>" data-pagination="<?php echo esc_attr($carousel_pagi); ?>" data-arrows="<?php echo esc_attr($carousel_nav); ?>" data-single-item="no" data-items-desktop="<?php echo esc_attr($column); ?>" data-items-desktop-small="2" data-items-tablet="2" data-items-mobile="1" <?php if ( is_rtl() ) { ?>data-rtl="rtl"<?php } else { ?> data-rtl="ltr" <?php } ?>>
   <?php } else { ?>
   <div class="row">
   <ul class="isotope-grid">
<?php }
if($the_categories=='' || $the_categories == '0')
{
	$testimonial_args = array ( 'post_type' => 'testimonial', 'posts_per_page' => $numberPosts, 'paged' => $paged );
}
else
{
	$testimonial_args = array ( 'post_type' => 'testimonial', 'tax_query' => array(array('taxonomy' => 'testimonial-category', 'field' => 'term_id', 'terms' => $the_categories, 'operator' => 'IN')), 'posts_per_page' => $numberPosts, 'paged' => $paged );
}
$testimonial_listings = new WP_Query($testimonial_args);
if($testimonial_listings->have_posts()):while($testimonial_listings->have_posts()):$testimonial_listings->the_post();
$client_info = get_post_meta(get_the_ID(), 'solicitor_testimonial_position', true);
?>
                      
<?php if(!empty($instance['listing_layout']['carousel_mode'])){ ?>
<li class="item">
<?php } else { ?>
<li class="grid-item col-md-<?php echo esc_attr($grid_column); ?> col-sm-4">
<?php } ?>
		<div class="testimonial-block">
			<blockquote>
				<?php the_content(); ?>
			</blockquote>
			<?php if(has_post_thumbnail()) ?>
				<?php the_post_thumbnail('solicitor-177x177', array('class' => 'testimonial-avatar')); ?>
			<div class="testimonial-info">
				<div class="testimonial-info-in">
					<strong><?php the_title(); ?></strong><span><?php echo esc_attr($client_info); ?></span>
				</div>
			</div>
		</div>
	</li>                                 
<?php
endwhile; endif; wp_reset_postdata();
echo '</ul>
    </div>
	</div>';
if(!empty($instance['listing_layout']['carousel_mode'])){ ?>              
</div>                  
<?php } ?>