<?php

/*
Widget Name: imithemes - Testimonials Widget
Description: A widget to show testimonials grid/carousel view.
Author: imithemes
Author URI: http://imithemes.com
*/

class Solicitor_Testimonials_Widget extends SiteOrigin_Widget {
	function __construct() {
		// Image Size and terms
		$arr = array();
		$arr[] = esc_html__('All', 'solicitor');
		$testimonial_terms = get_terms('testimonial-category');
		if(!is_wp_error($testimonial_terms))
		{
			foreach($testimonial_terms as $term)
			{
				$arr[$term->term_id] = $term->name;
			}
		}

		parent::__construct(
			'solicitor-testimonials-widget',
			esc_html__('imithemes - Testimonials Widget', 'solicitor'),
			array(
				'description' => esc_html__('A widget to show testimonials grid/carousel view.', 'solicitor'),
				'panels_icon' => 'dashicons dashicons-list-view',
				'panels_groups' => array('framework')
			),
			array(

			),
			array(
				'widget_title' => array(
					'label' => esc_html__( 'Widget Title', 'solicitor' ),
					'type' => 'text',
				),
				'categories' => array(
					'type' => 'select',
					'label' => esc_html__( 'Filter by categories', 'solicitor' ),
					'description' => esc_html__( 'To select multiple categories select with Ctrl/Command key pressed.', 'solicitor' ),
					'multiple' => true,
					'default' => '',
					'options' => $arr
				),
				'number_of_posts' => array(
					'type' => 'slider',
					'label' => esc_html__( 'Number of testimonials to show per page', 'solicitor' ),
					'default' => 4,
					'min' => 1,
					'max' => 50,
					'integer' => true,
				),
				'listing_layout' => array(
					'type' => 'section',
					'label' => esc_html__( 'Layout', 'solicitor' ),
					'hide' => false,
					'description' => esc_html__( 'Testimonial style', 'solicitor' ),
					'fields' => array(
						'style' => array(
							'type' => 'select',
							'label' => esc_html__( 'Choose style', 'solicitor' ),
							'options' => array(
								'' => esc_html__( 'Dark', 'solicitor' ),
								'accent-bg' => esc_html__( 'Light', 'solicitor' ),
							),
						),
						'grid_column' => array(
							'type' => 'select',
							'label' => esc_html__( 'Choose Grid View Column', 'solicitor' ),
							'options' => array(
								'12' => esc_html__( 'One', 'solicitor' ),
								'6' => esc_html__( 'Two', 'solicitor' ),
								'4' => esc_html__( 'Three', 'solicitor' ),
								'3' => esc_html__( 'Four', 'solicitor' ),
							),
						),
						'carousel_mode' => array(
							'type' => 'checkbox',
							'label' => esc_html__('Show as carousel', 'solicitor'),
						),
						'carousel_pagi' => array(
							'type' => 'checkbox',
							'default' => false,
							'label' => esc_html__('Enable carousel pagination', 'solicitor'),
						),
						'carousel_nav' => array(
							'type' => 'checkbox',
							'default' => true,
							'label' => esc_html__('Enable carousel Next/prev arrows', 'solicitor'),
						),
						'carousel_auto' => array(
							'type' => 'number',
							'default' => '',
							'label' => esc_html__('Enter time interval for Auto Carousel. 1000 = 1 second. Leave blank for no AutoPlay.', 'solicitor'),
						)
					)
				)
			),
			plugin_dir_path(__FILE__)
		);
	}


	
	function get_template_variables( $instance, $args ) {
		$layout = $instance['listing_layout'];
		return array(
				'layout_type' => array(
					'column'  => (!empty($layout['grid_column']))? $layout['grid_column'] : 4
				)
			);
	}
	
	function get_template_name( $instance ) {
		return 'template';
	}

	function get_style_name($instance) {
		return false;
	}

	function get_less_variables($instance){
		return array();
	}
	function modify_instance($instance){
		return $instance;
	}


}

siteorigin_widget_register('solicitor-testimonials-widget', __FILE__, 'Solicitor_Testimonials_Widget');